import json
import time
import os
import socket
import uuid
import traceback
from datetime import datetime

import dateutil.parser
from bebo.config import cfg

def write(queue, data, TTL=60):
    try:
        data['_id'] = data.get('_id', str(uuid.uuid4()))
        data['event_at'] = data.get('event_at', int(round(time.time() * 1000)))
        data['event_dttm'] = data.get('event_dttm', datetime.fromtimestamp(data['event_at'] / 1000).isoformat())
        data['_index'] = data.get('_index', gen_index_name(queue, data))
        data['env_tx'] = data.get('env_tx', cfg.ENV)
        data['hostname_tx'] = data.get('hostname_tx', cfg.HOSTNAME)
        data['region_tx'] = data.get('region_tx', cfg.REGION)
        data['service_tx'] = data.get('service_tx', cfg.SERVICE)

        current_min = int(round(time.time() / 60)) * 60
        pickup_time = int(round((time.time() + TTL) / 60)) * 60
        directory = "/data/dispatcher/%s" % queue
        try:
            _ensure_dir(directory)

            filename = "%s__%s" % (current_min, pickup_time)
            with open("%s/%s" % (directory, filename), "a+") as queuefile:
                queuefile.write("%s%s" % (json.dumps(data), "\n"))
        except OSError:
            print("dispatcher write OSError")
            traceback.print_exc()
    except Exception:
        print("something went wrong with dispatcher write event")
        traceback.print_exc()

def _ensure_dir(path):
    try:
        os.makedirs(path)
    except OSError:
        if not os.path.isdir(path):
            raise

def gen_index_name(queue, data):
    try:
        when = dateutil.parser.parse(data['event_dttm'])
    except ValueError:
        when = datetime.now()

    return '{}-{}-{}-{}'.format(queue, when.year, when.month, when.day)
