import numbers
import os

import sentry_sdk
from bebo.config import cfg

def init_sentry(dsn=None, **kwargs):
    args = {
        'dsn': dsn if cfg.ENV != 'local' else None,
        'release': cfg.VERSION,
        'environment': cfg.ENV,
        'server_name': cfg.HOSTNAME
    }
    args.update(kwargs)
    if cfg.ENV in ['dev', 'local']:
        print('Sentry: {}'.format(args))
    sentry_sdk.init(**args)

BANNED_ES_SUFFIX = ["tx", "nr", "ind", "key", "id", "dttm", "at", "sa", "dec"]
MAX_DEPTH = 10

def convert_to_es(_dict, depth=0):
    res = {}
    for key in _dict:
        ship_key = False

        for suffix in BANNED_ES_SUFFIX:
            if key.endswith("_" + suffix):
                ship_key = True

        if ship_key is True:
            res[key] = _dict[key]
            continue

        if isinstance(_dict[key], str):
            res[key + "_tx"] = _dict[key]
        elif isinstance(_dict[key], numbers.Number):
            if isinstance(_dict[key], bool):
                res[key + "_ind"] = _dict[key]
            elif isinstance(_dict[key], float):
                res[key + "_dec"] = _dict[key]
            else:
                res[key + "_nr"] = _dict[key]
        elif isinstance(_dict[key], dict):
            if depth < MAX_DEPTH:
                res[key] = convert_to_es(_dict[key], depth=depth+1)
        elif isinstance(_dict[key], list):
            res[key] = [
                convert_to_es(obj, depth=depth+1) if isinstance(obj, dict)
                else obj
                for obj in _dict[key]
            ]

    return res

def make_user_es_friendly(user):
    if not user:
        return None

    es_user = {
        'user_id': user.get('user_id', ''),
        'username_tx': user.get('username', ''),
        'created_dttm': user.get('created_dttm', ''),
    }

    if user.get('campaign', None) is not None:
        es_user['campaign'] = convert_to_es(user['campaign'])

    if user.get('days', None) is not None:
        es_user['days'] = user['days']

    if user.get('geo', None) is not None:
        es_user['geo'] = user['geo']

    if user.get('deleted_dttm', None) is not None:
        es_user['deleted_dttm'] = user['deleted_dttm']

    for key in user.keys():
        if key.startswith('has_'):
            es_user[key + '_ind'] = user[key]

        return es_user
