## Setup

* `git clone git@github.com:bebo/bebo-terraform.git && cd ./bebo-terraform`
	* `git submodule init && git submodule update --recursive`
	* [Install Terraform](https://terraform.io)
	* `python3.5 -m venv virtualenv && source ./virtualenv/bin/activate && pip install -r requirements.txt`

## How to create a new data center
There are two types of VPC that we currently support: App and Composer.
	* App -- Simply core systems, i.e an admin box, consul boxes, and security groups/elbs.
	* Composer -- An extension of the App VPC. This also has `composerpostgres` boxes, `speedtest` boxes, `composerproxy` boxes, and `composer` boxes

All of the commands below will automatically generate an **App** VPC. To make a **Composer** VPC, add `--preset composer` to any of the commands.

### Automatically (recommended!)
`aws-region` should be something like `us-west-1`

`env` should be one of: `dev`, `ptr`, `bebo-prod`

```
./deploy.py -r {aws-region} -e {env}
```


### Manual
`aws-region` should be something like `us-west-1`

`env` should be one of: `dev`, `ptr`, `bebo-prod`

#### Steps
* `./vpc.py --aws-region {aws-region} -e {env} create`
* Confirm with `yes` when prompted, if everything looks good. (See below for what "good" looks like)

### What's "good"?
When you create a new VPC (either manually or automatically), you'll be prompted to confirm at a certain step.

When prompted about `TFVars`, simply look through the printed JSON blob and confirm that you see refernces to the correct environment/region.

If you're building an **App VPC**, look for this log in the stdout:
	```
	Plan: 97 to add, 0 to change, 0 to destroy.
	```
If you're building a **Composer VPC**, look for this log in the stdout:
	```
	Plan: 114 to add, 0 to change, 0 to destroy.
	```

**If you ever see any values other than 0 for change or destroy, be very careful, this will modify existing vpcs**
