mac_address="$(curl -s http://169.254.169.254/latest/meta-data/mac)"
vpc_id="$(curl -s http://169.254.169.254/latest/meta-data/network/interfaces/macs/$mac_address/vpc-id)"
local_ipv4="$(curl -s http://169.254.169.254/latest/meta-data/local-ipv4)"
domain=$(hostname -d)
bebo_region="$(sudo salt-call grains.get vpc_tags:Name)"

# define variables

if /usr/share/consul/bin/consul kv get blabv1/projects/composer-ami/dev; then
    echo "projects have been set in consul -- specializing"

    sudo python3 /usr/local/sbin/salt_cloud.py

    sudo salt "*proxy*" cmd.run "if ! ( sudo netstat -tlpn | grep 443 ); then sudo salt-call state.highstate && journalctl -xe ; fi;" --no-color

    #echo "reloading consul agent"
    /usr/share/consul/bin/consul reload

    sudo systemctl restart rsyslog

else
    echo "specialize didnt finish -- consul keys missing"
fi
