import boto3
import json
from botocore.exceptions import ClientError

from tf_utils import convert_aws_region_to_short

class BucketPolicyManager():
    def __init__(self, aws_region, ec2_controller):
        self.ec2_controller = ec2_controller

        self.s3 = boto3.resource('s3', region_name=aws_region)
        self.short_region = convert_aws_region_to_short(aws_region)

        self.bucket_name = 'riano-deploy-%s' % self.short_region
        self.bucket_policy = self.s3.BucketPolicy(self.bucket_name)


    def remove_vpc_from_policy(self, vpc_id):
        policy_json = json.loads(self.bucket_policy.policy)
        vpc_endpoint = self.ec2_controller.get_vpc_endpoint(vpc_id)

        if vpc_endpoint is not None:
            vpc_endpoint_id = vpc_endpoint['VpcEndpointId']
        else:
            vpc_endpoint_id = None

        for statement in policy_json['Statement']:
            condition = statement['Condition']
            if statement['Sid'] == vpc_id or (condition.get('StringEquals', None) is not None and condition['StringEquals'].get('aws:sourceVpc', None) is not None and ( condition['StringEquals']['aws:sourceVpc'] == vpc_id or (type(condition['StringEquals']['aws:sourceVpc']) is list and vpc_id in statement['Condition']['StringEquals']['aws:sourceVpc']))):
                policy_json['Statement'].remove(statement)

        new_policy = json.dumps(policy_json, sort_keys=True)
        print("PUTing S3 policy to vpc %s: %s" % (vpc_id, new_policy))
        try:
            self.bucket_policy.put(
                    ConfirmRemoveSelfBucketAccess=False,
                    Policy=new_policy
                )
        except ClientError as e:
            print("ClientError while trying to PUT bucket policy:", e)
            return
