import json
import requests

from config import cfg

class MonitoringController:
    def __init__(self, vpc_id, bebo_env):
        self.vpc_id = vpc_id
        self.bebo_env = bebo_env

    def gen_headers(self):
        headers = {
                'Content-Type': 'application/json;charset=UTF-8',
                'Accept': 'application/json; version=2.0',
                'Authorization': 'Zoho-authtoken {}'.format(cfg.SITE24X7_TOKEN),
                }
        return headers


    def add_monitoring(self):
        domain = cfg.DOMAIN
        print("adding monitoring to %s vpc" % self.vpc_id)

        headers = self.gen_headers()

        data = json.dumps({
            'display_name': '%s-rey.%s' % (self.vpc_id, domain),
            'website': 'https://%s-rey.%s' % (self.vpc_id, domain),
            'check_frequency': 1,
            'use_ipv6': 'false',
            'threshold_profile_id': '258150000000025193',
            'response_type': 'T',
            'type': 'RESTAPI',
            'user_group_ids': ['258150000000025003'],
            'timeout': 10,
            'match_case': 'false',
            'up_status_codes': '200',
            'monitor_groups': ['258150000000116107'],
            'auth_method': 'B',
            'http_method': 'G',
            'use_name_server': 'false',
            'state': 0,
            'notification_profile_id': '258150000000025063',
            'location_profile_id': '258150000000025011'
        })

        print('monitoring payload:', data)
        print('monitoring headers:', json.dumps(headers))

        r = requests.post(cfg.SITE24X7_URL, headers=headers, data=data)
        return r

    def remove_monitoring(self):
        domain = cfg.DOMAIN
        print("removing monitoring from %s vpc" % self.vpc_id)

        headers = self.gen_headers()
        url = cfg.SITE24X7_URL + "/name/%s-rey.%s" % (self.vpc_id, domain)
        r = requests.delete(url, headers=headers)
        return r
