import boto3
from botocore.exceptions import ClientError

class Route53Controller:
    def __init__(self, aws_region, ec2_controller):
        self.aws_region = aws_region
        self.ec2_controller = ec2_controller

        self.route53_client = boto3.client('route53')

    def add_vpc_to_internal_routing(self, vpc, vpc_id, zone_id):
        aws_vpc_id = vpc['VpcId']

        try:
            self.route53_client.associate_vpc_with_hosted_zone(
                HostedZoneId=zone_id,
                VPC={
                    'VPCRegion': self.aws_region,
                    'VPCId': aws_vpc_id
                    },
                Comment="%s internal" % vpc_id
                )
            print("Route53Controller associated %s to internal hosted zone" % vpc_id)
        except ClientError as e:
            if e.response["Error"]["Code"] == "ConflictingDomainExists":
                print("Didnt add to internal routing because its already there -- is this an apply?")
            raise

    def remove_vpc_from_internal_routing(self, bebo_vpc_id, aws_vpc_id, zone_id):
        try:
            self.route53_client.disassociate_vpc_from_hosted_zone(
                HostedZoneId=zone_id,
                VPC={
                    'VPCRegion': self.aws_region,
                    'VPCId': aws_vpc_id
                    },
                Comment="%s internal" % bebo_vpc_id
                )
        except ClientError as e:
            response_code = e.response["Error"]["Code"]
            if response_code == "LastVPCAssociation":
                print("Not removing VPC from internal hosted zone due to it being last one -- Shouldn't ever happen")
                return
            if response_code == "VPCAssociationNotFound":
                print("VPC already removed from internal hosted zone -- Doing nothing")
                return
            raise e
