import json
import requests

def consul_kv_bootstrap(aws_region, vpc_id, domain, private_ip, bebo_env):
    s3_url = "https://s3.%s.amazonaws.com/riano-deploy-%s/" % (aws_region, "".join(list(vpc_id)[:4]))
    print("running consul_kv_bootstrap on vpc: %s with domain: %s, with s3_url: %s, and private_ip: %s" % (vpc_id, domain, s3_url, private_ip))

    def list_keys():
        url = "https://usw1-consul.bebo-dev.com/v1/kv/blabv1/projects?raw=true&recurse=true"
        return json.loads(requests.get(url).text)

    def get_tag(key):
        url = "https://usw1-consul.bebo-dev.com/v1/kv/%s?raw" % (key)
        return requests.get(url).text

    def put_tag(vpc_id, key, value):
        url = "https://%s-consul.%s/v1/kv/%s?raw" % (vpc_id, domain, key)
        requests.put(url, data=value)

    def put_config(vpc_id, key, value):
        url = "https://%s-consul.%s/v1/kv/config/%s" % (vpc_id, domain, key)
        requests.put(url, data=value)


    for obj in list_keys():
        key = obj["Key"]
        tag = get_tag(key)
        put_tag(vpc_id, key, tag)

    put_config(vpc_id, "composer/minimum-healthy", "5")
    put_config(vpc_id, "deploy/S3_RIANO_DEPLOY", s3_url)
    put_config(vpc_id, "deploy/BEBO_ENV", bebo_env)
    put_tag(vpc_id, "salt-shared/rsyslog/logserver", private_ip)
    put_tag(vpc_id, "salt-shared/rsyslog/port", "514")
