#!/usr/bin/python3

import functools
from subprocess import Popen, PIPE

aws_region = "${aws_region}"
vpc_id = "${vpc_id}"
bebo_domain = "${bebo_domain}"
profile_file = "/etc/salt/cloud.profiles.d/ec2.composer.profiles.conf"

consul_profiles = []
composerproxy_profiles = []

minimum_consul = 3
minimum_composerproxy = 3

composerproxy_exceptions = {
    'ap-northeast-1': lambda profile_names: list(filter(lambda profile_name: 'B' not in profile_name, profile_names))
    }
consul_exceptions = {
    'ap-northeast-1': lambda profile_names: list(filter(lambda profile_name: 'B' not in profile_name, profile_names))
    }

def get_n_digits_string(n, value):
    if len(value) < n:
        value = "0" + value
        return get_n_digits_string(n, value)

    return value

def spin_up(number, box_type, profiles):
    for i in range(0, number):
        try:
            profile = profiles[i]
        except IndexError:
            profile = profiles[-i]

        command = ['sudo', 'salt-cloud', '-p', '{}'.format(profile), '{}-{}-{}.aws.{}'.format(vpc_id, box_type, get_n_digits_string(3, str(i)), bebo_domain), '-l', 'debug', '--no-color']

        print(command)
        with Popen(command, stdout=PIPE) as consul_process:
            print(consul_process.stdout.read())

with open(profile_file, 'r') as contents:
    for line in contents.read().split("\n"):
        if "-consul-" in line:
            consul_profiles.append(line[:-1])
        elif "-composerproxy-" in line:
            composerproxy_profiles.append(line[:-1])

if aws_region in composerproxy_exceptions:
    composerproxy_profiles = composerproxy_exceptions[aws_region](composerproxy_profiles)

if aws_region in consul_exceptions:
    composerproxy_profiles = consul_exceptions[aws_region](composerproxy_profiles)

if len(consul_profiles) > minimum_consul:
    consul_bound = len(consul_profiles)
else:
    consul_bound = minimum_consul

if len(composerproxy_profiles) > minimum_composerproxy:
    composerproxy_bound = len(composerproxy_profiles)
else:
    composerproxy_bound = minimum_composerproxy

spin_up(consul_bound, "consul", consul_profiles)
spin_up(composerproxy_bound, "composerproxy", composerproxy_profiles)
