#!/bin/bash

ITERATION_COUNT=0
MAX_TERATION_COUNT=5
SLEEP_TIME=10
# 50 sec? :fingers_crossed:

setup_source() {
    echo "setting up salt source files" >> install_salt.log
    wget -O - https://repo.saltstack.com/apt/debian/9/amd64/archive/${salt_version}/SALTSTACK-GPG-KEY.pub | sudo apt-key add - &>> install_salt.log
    sudo mkdir -p /etc/apt/sources.list.d
    sudo touch /etc/apt/sources.list.d/saltstack_debian_repo.list
    sudo chmod 0666 /etc/apt/sources.list.d/saltstack_debian_repo.list
    echo "deb http://repo.saltstack.com/apt/debian/9/amd64/archive/${salt_version} stretch main" > /etc/apt/sources.list.d/saltstack_debian_repo.list
    sudo chmod 0644 /etc/apt/sources.list.d/saltstack_debian_repo.list
    echo "source setup" >> install_salt.log
}

success() {
    echo -e "\n Success! On iteration #$ITERATION_COUNT \n" >> install_salt.log
}

check_locks() {

    top -b -n 1 >> install_salt.log
    echo -e "\n" >> install_salt.log

    echo "checking lsof of /var/lib/dpkg/lock" >> install_salt.log
    echo -e "/var/lib/dpkg/lock lsof results: \n" >> install_salt.log
    sudo fuser /var/lib/dpkg/lock | awk -F: '{ print $1 }' | /usr/bin/tr -d '[:space:]' | xargs -0 -I pid cat /proc/pid/cmdline &>> install_salt.log
    echo -e "\n\n"

    echo "checking lsof of /var/lib/apt/lists/lock" >> install_salt.log
    echo -e "/var/lib/apt/lists/lock lsof results: \n" >> install_salt.log
    sudo fuser /var/lib/apt/lists/lock | awk -F: '{ print $1 }' | /usr/bin/tr -d '[:space:]' | xargs -0 -I pid cat /proc/pid/cmdline &>> install_salt.log

    echo -e "\n Sleeping for $SLEEP_TIME s \n" >> install_salt.log
    echo -e "\n Sleeping for $SLEEP_TIME s \n"
    sleep $SLEEP_TIME
    install_salt
}

install_salt() {
    if [ $ITERATION_COUNT -eq $MAX_TERATION_COUNT ]; then
        echo -e "Max iterations ($MAX_TERATION_COUNT) hit... exiting" >> install_salt.log
    else
        ITERATION_COUNT=$(( ITERATION_COUNT + 1))
        echo "Iteration #$ITERATION_COUNT"
        echo "Iteration #$ITERATION_COUNT" >> install_salt.log
        if hostname | grep admin; then
            echo "installing salt-minion and salt-master because on admin box" >> install_salt.log
            sudo apt update && sudo apt install salt-cloud salt-common salt-minion salt-master -y && success || check_locks
        else
            echo "installing salt-minion because not on admin box" >> install_salt.log
            sudo apt update && sudo apt install salt-common salt-minion -y && success || check_locks
        fi
    fi
}

> install_salt.log

setup_source
install_salt
