#!/usr/bin/env python3.5
# vim set sw=4 ts=4 et :

import sys
import argparse
from controller import Controller
from tf_utils import gen_vpc_id, convert_short_to_aws_region

parser = argparse.ArgumentParser(description="Create new VPCs with one command ")
parser.add_argument("command", help="one of: create, destroy, gen_id", choices=['create', 'destroy', 'gen_id'])
parser.add_argument("--aws-region", "-r", dest="aws_region", help="something like us-west-1")
parser.add_argument("--vpc-id", dest="vpc_id", help="usw1[0|1|2|etc]")
parser.add_argument("--bebo-env", "-e", dest="bebo_env", help="dev|prod|test|ptr", choices=["dev", "bebo-prod", "ptr"], default="dev")
parser.add_argument("-y", dest="prompt", help="disable prompt", action="store_false")
parser.add_argument("-f", dest="force", help="ignore sanity checks", action="store_true")
parser.add_argument("--dry-run", dest="dry_run", help="dry run, so you can see what will happen", action="store_true")


if __name__ == '__main__':
    args = parser.parse_args()
    aws_region = args.aws_region
    bebo_env = args.bebo_env
    vpc_id = args.vpc_id if args.vpc_id is not None else gen_vpc_id(aws_region)
    do_prompt = args.prompt
    force = args.force
    dry_run = args.dry_run
    command = args.command

    if command != 'destroy':
        if not aws_region:
            print("the following arguments are required for non-destroy runs: --aws-region/-r")
            sys.exit(1)
    #  else:
        #  bebo_env = None
        #  aws_region = convert_short_to_aws_region(vpc_id)

    controller = Controller(aws_region=aws_region, vpc_id=vpc_id, do_prompt=do_prompt, force=force, bebo_env=bebo_env, dry_run=dry_run)

    controller.act(command)
