import subprocess
from time import time
from config import cfg

def convert_aws_region_to_short(aws_region):
    split = aws_region.split("-")
    prefix = split[0]
    number = split[-1]
    modifier = ""
    if "north" in split[1]:
        modifier += "n"
    if "south" in split[1]:
        modifier += "s"
    if "east" in split[1]:
        modifier += "e"
    if "west" in split[1]:
        modifier += "w"
    if "central" in split[1]:
        modifier += "c"

    end = prefix + modifier + number

    #  end = split[0] + split[1][0] + split[2]
    return end

def convert_short_to_aws_region(short):
    first_four = short[:4]
    first_five = short[:5]
    if first_four == 'aps1':
        return 'ap-south-1'
    elif first_four == 'cac1':
        return 'ca-central-1'
    elif first_four == 'euc1':
        return 'eu-central-1'
    elif first_four == 'euw1':
        return 'eu-west-1'
    elif first_four == 'euw2':
        return 'eu-west-2'
    elif first_four == 'euw3':
        return 'eu-west-3'
    elif first_four == 'sae1':
        return 'sa-east-1'
    elif first_four == 'use1':
        return 'us-east-1'
    elif first_four == 'use2':
        return 'us-east-2'
    elif first_four == 'usw1':
        return 'us-west-1'
    elif first_four == 'usw2':
        return 'us-west-2'
    elif first_five == 'apne2':
        return 'ap-northeast-2'
    elif first_five == 'apne1':
        return 'ap-northeast-1'
    elif first_five == 'apse1':
        return 'ap-southeast-1'
    elif first_five == 'apse2':
        return 'ap-southeast-2'

def gen_vpc_id(aws_region):
    prefix = convert_aws_region_to_short(aws_region)
    suffix = str(int(time()))
    return prefix + suffix

def get_newest_tagged_saltstack_commit():
    cmd = "( ( ls | grep -x aws-saltstack -q && ( git submodule status | grep aws-saltstack ) ) || ( git ls-remote --tags git@github.com:bebo/aws-saltstack.git | sort | head -1 ) ) | awk  '{print $1}'"
    proc = subprocess.Popen(cmd, stdout=subprocess.PIPE, shell=True)
    stdout = proc.stdout.read()
    commit = stdout.rstrip().decode('utf-8')
    if commit[0] == "+": #local unstaged submodule changes
        return commit[1:]
    return commit

if __name__ == "__main__":
    print("testing convert_aws_region_to_short")
    test_regions = cfg.AWS_REGIONS
    for region in test_regions:
        short = convert_aws_region_to_short(region)
        print("{} --> {}".format(region, short))

    print("{} regions tested".format(len(test_regions)))

    short_test_map = {
        'apne11529366836': 'ap-northeast-1',
        'apne21529366836': 'ap-northeast-2',
        'aps11529366836': 'ap-south-1',
        'apse11529366837': 'ap-southeast-1',
        'apse21529366837': 'ap-southeast-2',
        'cac11529366837': 'ca-central-1',
        'euc11529366838': 'eu-central-1',
        'euw11529366838': 'eu-west-1',
        'euw21529366838': 'eu-west-2',
        'euw31530150559': 'eu-west-3',
        'sae11529366839': 'sa-east-1',
        'use11529366839': 'us-east-1',
        'use21529366840': 'us-east-2',
        'usw11529366840': 'us-west-1',
        'usw21529366840': 'us-west-2'
        }

    for short in short_test_map:
        assert convert_short_to_aws_region(short) == short_test_map[short], 'did not convert_short_to_aws_region correctly for {}'.format(short_test_map[short])

    print("convert_short_to_aws_region works on {} tested regions".format(len(set(short_test_map.values()))))
