## security groups

# default security group, mimics default aws default
resource "aws_default_security_group" "default" {
  vpc_id = "${aws_vpc.composer.id}"

  ingress {
		protocol  = -1
		self      = true
		from_port = 0
		to_port   = 0
  }

  egress {
		from_port   = 0
		to_port     = 0
		protocol    = "-1"
		cidr_blocks = ["0.0.0.0/0"]
  }
  tags {
    Name = "${aws_vpc.composer.id}-default"
  }
}


# composerproxy
resource "aws_security_group" "public_https" {
  name        = "public_https"
  description = "public http and https"
  vpc_id = "${aws_vpc.composer.id}"

  ingress {
    protocol  = "tcp"
    from_port = 80
    to_port   = 80
    cidr_blocks = ["0.0.0.0/0"]
    ipv6_cidr_blocks = ["::/0"]
    description = "public http"
  }

  ingress {
    protocol  = "tcp"
    from_port = 443
    to_port   = 443
    cidr_blocks = ["0.0.0.0/0"]
    ipv6_cidr_blocks = ["::/0"]
    description = "public https"
  }

  tags {
    Name = "${aws_vpc.composer.id}-public_https"
  }
}



# composer
resource "aws_security_group" "composer" {
  name        = "composer"
  description = "composer"
  vpc_id = "${aws_vpc.composer.id}"

  ingress {
    protocol  = "udp"
    from_port = 3478
    to_port   = 3478
    cidr_blocks = ["0.0.0.0/0"]
    description = "STUN"
  }

  ingress {
    protocol  = "tcp"
    from_port = 20000
    to_port   = 65535
    cidr_blocks = ["0.0.0.0/0"]
    description = "Janus -- TCP"
  }
  ingress {
    protocol  = "udp"
    from_port = 20000
    to_port   = 65535
    cidr_blocks = ["0.0.0.0/0"]
    description = "Janus"
  }

  ingress {
    protocol  = "tcp"
    from_port = 3478
    to_port   = 3478
    cidr_blocks = ["0.0.0.0/0"]
    description = "STUN"
  }
  ingress {
    protocol  = "tcp"
    from_port = 443
    to_port   = 443
    cidr_blocks = ["0.0.0.0/0"]
    description = "TURN"
  }
  ingress {
    protocol  = "tcp"
    from_port = 8443
    to_port   = 8443
    cidr_blocks = ["0.0.0.0/0"]
    description = "NGINX_OBIWAN_WS"
  }

  tags {
    Name = "${aws_vpc.composer.id}-composer"
  }
}

# allow http(s) from HQ and VPN
resource "aws_security_group" "allow_http_from_hq_vpn" {
  name = "allow_http_from_hq_vpn"
  description = "allow traffic from HQ and VPN"
  vpc_id = "${aws_vpc.composer.id}"

  # NO INLINE ingress/egress rules !!!

  tags {
    Name = "${aws_vpc.composer.id}-allow_http_from_hq_vpn"
  }
}

resource "aws_security_group_rule" "allow_http_from_hq_ingress_tcp_443" {
  count = "${length(var.bebo_allowed_prod_ip_addresses)}"
  type = "ingress"
  protocol  = "tcp"
  from_port = 443
  to_port   = 443
  cidr_blocks = ["${lookup(var.bebo_allowed_prod_ip_addresses[count.index], "cidr_block")}"]
  description = "${lookup(var.bebo_allowed_prod_ip_addresses[count.index], "description")}"
  security_group_id = "${aws_security_group.allow_http_from_hq_vpn.id}"
}

resource "aws_security_group_rule" "allow_http_from_hq_ingress_tcp_80" {
  count = "${length(var.bebo_allowed_prod_ip_addresses)}"
  type = "ingress"
  protocol  = "tcp"
  from_port = 80
  to_port   = 80
  cidr_blocks = ["${lookup(var.bebo_allowed_prod_ip_addresses[count.index], "cidr_block")}"]
  description = "${lookup(var.bebo_allowed_prod_ip_addresses[count.index], "description")}"
  security_group_id = "${aws_security_group.allow_http_from_hq_vpn.id}"
}

# admin
resource "aws_security_group" "admin" {
  name = "admin"
  description = "admin box"
  vpc_id = "${aws_vpc.composer.id}"

  # NO INLINE ingress/egress rules !!!

  tags {
    Name = "${aws_vpc.composer.id}-admin"
  }
}

resource "aws_security_group_rule" "allow_admin_ingress_tcp_443" {
  count = "${length(var.bebo_allowed_prod_ip_addresses)}"
  type = "ingress"
  protocol  = "tcp"
  from_port = 443
  to_port   = 443
  cidr_blocks = ["${lookup(var.bebo_allowed_prod_ip_addresses[count.index], "cidr_block")}"]
  description = "${lookup(var.bebo_allowed_prod_ip_addresses[count.index], "description")}"
  security_group_id = "${aws_security_group.admin.id}"
}

resource "aws_security_group_rule" "allow_admin_ingress_tcp_80" {
  count = "${length(var.bebo_allowed_prod_ip_addresses)}"
  type = "ingress"
  protocol  = "tcp"
  from_port = 80
  to_port   = 80
  cidr_blocks = ["${lookup(var.bebo_allowed_prod_ip_addresses[count.index], "cidr_block")}"]
  description = "${lookup(var.bebo_allowed_prod_ip_addresses[count.index], "description")}"
  security_group_id = "${aws_security_group.admin.id}"
}

resource "aws_security_group_rule" "allow_admin_ingress_tcp_80_from_elb" {
  type = "ingress"
  protocol  = "tcp"
  from_port = 80
  to_port   = 80
  description = "http from admin elb"
  security_group_id = "${aws_security_group.admin.id}"
  source_security_group_id = "${aws_security_group.admin_elb.id}"
}

resource "aws_security_group_rule" "allow_admin_ingress_tcp_22" {
  count = "${length(var.bebo_allowed_prod_ip_addresses)}"
  type = "ingress"
  protocol  = "tcp"
  from_port = 22
  to_port   = 22
  cidr_blocks = ["${lookup(var.bebo_allowed_prod_ip_addresses[count.index], "cidr_block")}"]
  description = "${lookup(var.bebo_allowed_prod_ip_addresses[count.index], "description")}"
  security_group_id = "${aws_security_group.admin.id}"
}

resource "aws_security_group" "admin_elb" {
  name = "admin_elb"
  description = "admin elb"
  vpc_id = "${aws_vpc.composer.id}"

  tags {
    Name = "${aws_vpc.composer.id}-admin_elb"
  }
}

resource "aws_security_group_rule" "allow_admin_elb_egress_high" {
  description = "high ports outbound for return traffic"
  type = "egress"
  protocol  = "tcp"
  from_port = 0
  to_port   = 65535
  cidr_blocks = ["0.0.0.0/0"]
  ipv6_cidr_blocks = ["::/0"]
  security_group_id = "${aws_security_group.admin_elb.id}"
}

# vpn-site-to-site
resource "aws_security_group" "vpn-tunnel" {
  name        = "vpn-tunnel"
  description = "vpn site to site tunnel to usw2"
  vpc_id = "${aws_vpc.composer.id}"

  ingress {
    protocol  = "udp"
    from_port = 10000
    to_port   = 10000
    cidr_blocks = ["52.27.136.77/32"]
    description = "usw2 vpn"
  }

  tags {
    Name = "${aws_vpc.composer.id}-vpn-tunnel"
  }
}
