#!/bin/bash

mac_address="$(curl -s http://169.254.169.254/latest/meta-data/mac)"
vpc_id="$(curl -s http://169.254.169.254/latest/meta-data/network/interfaces/macs/${mac_address}/vpc-id)"
local_ipv4="$(curl -s http://169.254.169.254/latest/meta-data/local-ipv4)"
domain=$(hostname -d)
bebo_region="$(sudo salt-call grains.get vpc_tags:Name)"
# define variables

total_composerpostgres_count=2
total_speedtest_count=2
total_supervisor_cnt=2

if /usr/share/consul/bin/consul kv get blabv1/projects/composer-ami/dev; then
    echo "projects have been set in consul -- specializing"

    composerpostgres_count="$(sudo salt-key | grep composerpostgres | wc -l)"
    speedtest_count="$(sudo salt-key | grep speedtest | wc -l)"
    supervisor_running=true

    #sudo salt '*' state.highstate
    #sudo salt-call state.highstate
    # highstate everything, including self

    sudo python3 /usr/local/sbin/salt_cloud.py

    echo "$composerpostgres_count composerpostgres servers found, expected $total_composerpostgres_count"
    if [ $composerpostgres_count -eq $total_composerpostgres_count ]; then
        echo "$composerpostgres_count composerpostgresses, we gucci"
    else
        echo "spinning up compostpostgreses"
        for i in $(seq 1 $total_speedtest_count); do
            profile=${vpc_id}-composerpostgres
            (( $i % 2 )) && profile="$profile-A" || profile="$profile-B"
            sudo salt-cloud -p ${profile} ${bebo_region}-composerpostgres-00$i.${domain}
        done
    fi

    echo "$speedtest_count speedtest servers found, expected $total_speedtest_count"

    if [ $speedtest_count -eq $total_speedtest_count ]; then
        echo "$total_speedtest_count speedtests, we gucci"
    else
        echo "spinning up speedtests"
        for i in $(seq 1 $total_speedtest_count); do
            profile=${vpc_id}-speedtest
            (( $i % 2 )) && profile="$profile-A" || profile="$profile-B"
            sudo salt-cloud -p ${profile} ${bebo_region}-speedtest-00$i.${domain}
        done
    fi

    supervisor_cnt=0

    for RES in $(sudo supervisorctl status | awk '{print $2}'); do
        supervisor_cnt=$((supervisor_cnt+1))
        if [ $RES == "ERROR" ]; then
            supervisor_running=false
        fi
    done

    echo "found $supervisor_cnt supervisor services, expected >= $total_supervisor_cnt"
    if [ $supervisor_cnt -lt $total_supervisor_cnt ]; then
        supervisor_running=false
    fi

    echo "supervisor_running? $supervisor_running"
    if [ "$supervisor_running" = false ]; then
        echo "apply autoscale,dispatcher,dispatcher.deploy states"
        sudo salt-call state.apply autoscale,dispatcher,dispatcher.deploy
        sudo rm -rf /srv/www/riano-dispatcher/*
        echo "reloading consul agent"
        /usr/share/consul/bin/consul reload
    fi

else
    echo "specialize didnt finish -- consul keys missing"
fi
