# Consul Instances

resource "aws_instance" "consul" {
  count = 3 # no max/min and we can either do 3 or 5

  connection {
    # The default username for our AMI
    user         = "admin"
    private_key  = "${file(var.key_filename)}"
    bastion_host = "${aws_eip.admin.public_ip}"
  }

  instance_type = "c4.large"

  root_block_device {
    volume_size = "100"
  }

  instance_initiated_shutdown_behavior = "terminate"

  # Lookup the correct AMI based on the region
  # we specified
  ami = "${var.general_ami}"

  # The name of our SSH keypair we created above.
  key_name = "${var.key_name}"

  vpc_security_group_ids = ["${aws_default_security_group.default.id}"]

  subnet_id = "${element(aws_subnet.subnet_private.*.id, count.index % var.zones_count)}"

  iam_instance_profile = "bebo-consul"

  tags {
    Name = "${var.dc["name"]}-consul-00${count.index}.${var.aws_domain}"
    Role = "consul"
  }

  #provisioner "file" {
  #  source      = "../../scripts/bootstrap-salt.sh"
  #  destination = "bootstrap-salt.sh"
  #}

  provisioner "remote-exec" {
    inline = [
      "until [ -f /var/lib/cloud/instance/boot-finished ]; do sleep 1 && echo sleep; done",
      "sudo rm -rf /srv/salt",
      "sudo sh -c 'echo ${var.dc["name"]}-consul-00${count.index}.${var.aws_domain} > /etc/salt/minion_id'",
      "sudo mkdir -p /etc/salt/minion.d",
      "sudo sh -c 'echo \"master: ${aws_instance.admin.private_ip}\" > /etc/salt/minion.d/master.conf'",
      "wget -O - https://repo.saltstack.com/apt/debian/9/amd64/archive/2017.7.4/SALTSTACK-GPG-KEY.pub | sudo apt-key add - || sudo lsof /var/lib/apt/lists/lock && sudo lsof /var/lib/dpkg/",
      "echo \"saltstack pub key added\" || sudo lsof /var/lib/apt/lists/lock && sudo lsof /var/lib/dpkg/",
      "sudo mkdir -p /etc/apt/sources.list.d || sudo lsof /var/lib/apt/lists/lock && sudo lsof /var/lib/dpkg/",
      "echo \"created sources.list.d dir\" || sudo lsof /var/lib/apt/lists/lock && sudo lsof /var/lib/dpkg/",
      "sudo touch /etc/apt/sources.list.d/saltstack_debian_repo.list || sudo lsof /var/lib/apt/lists/lock && sudo lsof /var/lib/dpkg/",
      "echo \" created saltstack depain repo list file\" || sudo lsof /var/lib/apt/lists/lock && sudo lsof /var/lib/dpkg/",
      "sudo chmod 0666 /etc/apt/sources.list.d/saltstack_debian_repo.list || sudo lsof /var/lib/apt/lists/lock && sudo lsof /var/lib/dpkg/",
      "echo \"chmodded debian repo file to 0666\" || sudo lsof /var/lib/apt/lists/lock && sudo lsof /var/lib/dpkg/",
      "echo \"deb http://repo.saltstack.com/apt/debian/9/amd64/archive/2017.7.4 stretch main\" > /etc/apt/sources.list.d/saltstack_debian_repo.list || sudo lsof /var/lib/apt/lists/lock && sudo lsof /var/lib/dpkg/",
      "echo \"populated debian repo list file\" || sudo lsof /var/lib/apt/lists/lock && sudo lsof /var/lib/dpkg/",
      "sudo chmod 0644 /etc/apt/sources.list.d/saltstack_debian_repo.list || sudo lsof /var/lib/apt/lists/lock && sudo lsof /var/lib/dpkg/",
      "echo \"chmodded debian repo file to 0644\" || sudo lsof /var/lib/apt/lists/lock && sudo lsof /var/lib/dpkg/",
      "sudo apt update || sudo lsof /var/lib/apt/lists/lock && sudo lsof /var/lib/dpkg/",
      "echo \"apt update ran\" || sudo lsof /var/lib/apt/lists/lock && sudo lsof /var/lib/dpkg/",
      "sudo apt install -y salt-minion || sudo lsof /var/lib/apt/lists/lock && sudo lsof /var/lib/dpkg/",
      "sudo \"salt-minion apt installed\" || sudo lsof /var/lib/apt/lists/lock && sudo lsof /var/lib/dpkg/"
    ]
  }

  depends_on = ["aws_instance.admin", "aws_route.private_route", "aws_eip.admin"]
}

