# Consul Instances

resource "aws_instance" "consul" {
  count = 3 # no max/min and we can either do 3 or 5

  connection {
    # The default username for our AMI
    user         = "admin"
    private_key  = "${file(var.key_filename)}"
    bastion_host = "${aws_eip.admin.public_ip}"
  }

  instance_type = "c4.large"

  root_block_device {
    volume_size = "100"
  }

  instance_initiated_shutdown_behavior = "terminate"

  # Lookup the correct AMI based on the region
  # we specified
  ami = "${var.general_ami}"

  # The name of our SSH keypair we created above.
  key_name = "${var.key_name}"

  vpc_security_group_ids = ["${aws_default_security_group.default.id}"]

  subnet_id = "${element(aws_subnet.subnet_private.*.id, count.index % var.zones_count)}"

  iam_instance_profile = "bebo-consul"

  tags {
    Name = "${var.dc["name"]}-consul-00${count.index}.${var.aws_domain}"
    Role = "consul"
  }

  #provisioner "file" {
  #  source      = "../../scripts/bootstrap-salt.sh"
  #  destination = "bootstrap-salt.sh"
  #}

  provisioner "remote-exec" {
    inline = [
      "until [ -f /var/lib/cloud/instance/boot-finished ]; do sleep 1 && echo sleep; done",
      "sudo rm -rf /srv/salt",
      "sudo sh -c 'echo ${var.dc["name"]}-consul-00${count.index}.${var.aws_domain} > /etc/salt/minion_id'",
      "sudo mkdir -p /etc/salt/minion.d",

      "sudo sh -c 'echo \"master: ${aws_instance.admin.private_ip}\" > /etc/salt/minion.d/master.conf'",
      "wget -O - https://repo.saltstack.com/apt/debian/9/amd64/archive/2017.7.4/SALTSTACK-GPG-KEY.pub | sudo apt-key add - || sudo fuser /var/lib/apt/lists/lock | awk -F: '{ print $1 }' | sudo ps && sudo fuser /var/lib/dpkg/ | awk -F: '{ print $1 }' | sudo xargs ps",
      "echo \"saltstack pub key added\" || sudo fuser /var/lib/apt/lists/lock | awk -F: '{ print $1 }' | sudo xargs ps && sudo fuser /var/lib/dpkg/ | awk -F: '{ print $1 }' | sudo xargs ps",
      "sudo mkdir -p /etc/apt/sources.list.d || sudo fuser /var/lib/apt/lists/lock | awk -F: '{ print $1 }' | sudo xargs ps && sudo fuser /var/lib/dpkg/ | awk -F: '{ print $1 }' | sudo xargs ps",
      "echo \"created sources.list.d dir\" || sudo fuser /var/lib/apt/lists/lock | awk -F: '{ print $1 }' | sudo xargs ps && sudo fuser /var/lib/dpkg/ | awk -F: '{ print $1 }' | sudo xargs ps",
      "sudo touch /etc/apt/sources.list.d/saltstack_debian_repo.list || sudo fuser /var/lib/apt/lists/lock | awk -F: '{ print $1 }' | sudo xargs ps && sudo fuser /var/lib/dpkg/ | awk -F: '{ print $1 }' | sudo xargs ps",
      "echo \" created saltstack depain repo list file\" || sudo fuser /var/lib/apt/lists/lock | awk -F: '{ print $1 }' | sudo xargs ps && sudo fuser /var/lib/dpkg/ | awk -F: '{ print $1 }' | sudo xargs ps",
      "sudo chmod 0666 /etc/apt/sources.list.d/saltstack_debian_repo.list || sudo fuser /var/lib/apt/lists/lock | awk -F: '{ print $1 }' | sudo xargs ps && sudo fuser /var/lib/dpkg/ | awk -F: '{ print $1 }' | sudo xargs ps",
      "echo \"chmodded debian repo file to 0666\" || sudo fuser /var/lib/apt/lists/lock | awk -F: '{ print $1 }' | sudo xargs ps && sudo fuser /var/lib/dpkg/ | awk -F: '{ print $1 }' | sudo xargs ps",
      "echo \"deb http://repo.saltstack.com/apt/debian/9/amd64/archive/2017.7.4 stretch main\" > /etc/apt/sources.list.d/saltstack_debian_repo.list || sudo fuser /var/lib/apt/lists/lock | awk -F: '{ print $1 }' | sudo xargs ps && sudo fuser /var/lib/dpkg/ | awk -F: '{ print $1 }' | sudo xargs ps",
      "echo \"populated debian repo list file\" || sudo fuser /var/lib/apt/lists/lock | awk -F: '{ print $1 }' | sudo xargs ps && sudo fuser /var/lib/dpkg/ | awk -F: '{ print $1 }' | sudo xargs ps",
      "sudo chmod 0644 /etc/apt/sources.list.d/saltstack_debian_repo.list || sudo fuser /var/lib/apt/lists/lock | awk -F: '{ print $1 }' | sudo xargs ps && sudo fuser /var/lib/dpkg/ | awk -F: '{ print $1 }' | sudo xargs ps",
      "echo \"chmodded debian repo file to 0644\" || sudo fuser /var/lib/apt/lists/lock | awk -F: '{ print $1 }' | sudo xargs ps && sudo fuser /var/lib/dpkg/ | awk -F: '{ print $1 }' | sudo xargs ps",
      "sudo apt update || sudo fuser /var/lib/apt/lists/lock | awk -F: '{ print $1 }' | sudo xargs ps && sudo fuser /var/lib/dpkg/ | awk -F: '{ print $1 }' | sudo xargs ps",
      "echo \"apt update ran\" || sudo fuser /var/lib/apt/lists/lock | awk -F: '{ print $1 }' | sudo xargs ps && sudo fuser /var/lib/dpkg/ | awk -F: '{ print $1 }' | sudo xargs ps",
      "sudo apt install -y salt-minion || sudo fuser /var/lib/apt/lists/lock | awk -F: '{ print $1 }' | sudo xargs ps && sudo fuser /var/lib/dpkg/ | awk -F: '{ print $1 }' | sudo xargs ps",
      "sudo \"salt-minion apt installed\" || sudo fuser /var/lib/apt/lists/lock | awk -F: '{ print $1 }' | sudo xargs ps && sudo fuser /var/lib/dpkg/ | awk -F: '{ print $1 }' | sudo xargs ps/"
    ]
  }

  depends_on = ["aws_instance.admin", "aws_route.private_route", "aws_eip.admin"]
}

