### composerproxy

resource "aws_route53_health_check" "obiwan-composerproxy" {
  count             = "${var.zones_count}"
  fqdn              = "obiwan.${var.bebo_domain}"
  ip_address        = "${element(aws_eip.composerproxy.*.public_ip, count.index)}"
  port              = 443
  type              = "HTTPS"
  resource_path     = "/"
  failure_threshold = "2"
  request_interval  = "10"
  measure_latency   = true

  tags = {
    Name = "${var.dc["name"]}-obiwan-composerproxy-00${count.index}"
  }
}

resource "aws_route53_health_check" "obiwan" {
  type                   = "CALCULATED"
  child_health_threshold = 1
  child_healthchecks     = ["${element(aws_route53_health_check.obiwan-composerproxy.*.id, count.index)}"]

  tags = {
    Name = "${var.dc["name"]}-obiwan.${var.bebo_domain}"
  }
}

resource "aws_route53_health_check" "composerproxy" {
  count             = "${var.zones_count}"
  ip_address        = "${element(aws_eip.composerproxy.*.public_ip, count.index)}"
  port              = 443
  type              = "TCP"
  failure_threshold = "2"
  request_interval  = "10"
  measure_latency   = true

  tags = {
    Name = "${var.dc["name"]}-composerproxy-00${count.index}"
  }
}

resource "aws_route53_record" "composerproxy" {
  count                            = "${var.zones_count}"
  zone_id                          = "${var.dns_zone_id}"
  name                             = "${var.dc["name"]}-obiwan.${var.bebo_domain}"
  type                             = "A"
  ttl                              = "10"
  health_check_id                  = "${element(aws_route53_health_check.composerproxy.*.id, count.index)}"
  multivalue_answer_routing_policy = true
  set_identifier                   = "${var.dc["name"]}-obiwan.00${count.index}"
  records                          = ["${element(aws_eip.composerproxy.*.public_ip, count.index)}"]
}

resource "aws_route53_record" "speedproxy" {
  count                            = "${var.zones_count}"
  zone_id                          = "${var.dns_zone_id}"
  name                             = "${var.dc["name"]}-speed.${var.bebo_domain}"
  type                             = "A"
  ttl                              = "10"
  health_check_id                  = "${element(aws_route53_health_check.composerproxy.*.id, count.index)}"
  multivalue_answer_routing_policy = true
  set_identifier                   = "${var.dc["name"]}-speed.00${count.index}"
  records                          = ["${element(aws_eip.composerproxy.*.public_ip, count.index)}"]
}

resource "aws_route53_record" "marioproxy" {
  count                            = "${var.zones_count}"
  zone_id                          = "${var.dns_zone_id}"
  name                             = "${var.dc["name"]}-mario.${var.bebo_domain}"
  type                             = "A"
  ttl                              = "10"
  health_check_id                  = "${element(aws_route53_health_check.composerproxy.*.id, count.index)}"
  multivalue_answer_routing_policy = true
  set_identifier                   = "${var.dc["name"]}-mario.00${count.index}"
  records                          = ["${element(aws_eip.composerproxy.*.public_ip, count.index)}"]
}

### admin

resource "aws_route53_record" "consul" {
  zone_id = "${var.dns_zone_id}"
  name    = "${var.dc["name"]}-consul.${var.bebo_domain}"
  type    = "A"

  alias {
    name                   = "${aws_alb.admin.dns_name}"
    zone_id                = "${aws_alb.admin.zone_id}"
    evaluate_target_health = false
  }
}

resource "aws_route53_record" "admin-beboinc" {
  zone_id = "Z1DZ79XB83YGFN"
  name    = "${var.dc["name"]}-admin.beboinc.com"
  type    = "A"
  ttl     = "300"
  records = ["${aws_eip.admin.public_ip}"]
}
