# Admin Server Intance

data "template_file" "specialize" {
    template = "${file(var.specialize_path)}"
    vars {
        admin_supervisor_service_cnt = "${var.admin_supervisor_service_cnt}"
    }
}

data "template_file" "connect" {
    template = "${file(var.connect_path)}"
    vars {}
}

resource "aws_instance" "admin" {
  # The connection block tells our provisioner how to
  # communicate with the resource (instance)
  connection {
    # The default username for our AMI
    user        = "admin"
    private_key = "${file(var.key_filename)}"

    # The connection will use the local SSH agent for authentication.
  }

  instance_type = "m4.xlarge"

  root_block_device {
    volume_size = "100"
  }

  instance_initiated_shutdown_behavior = "terminate"

  # Lookup the correct AMI based on the region
  # we specified
  ami = "${var.general_ami}"

  # The name of our SSH keypair we created above.
  key_name = "${var.key_name}"

  # Our Security group to allow HTTP and SSH access
  vpc_security_group_ids = ["${aws_default_security_group.default.id}",
    "${aws_security_group.admin.id}",
  ]

  # We're going to launch into the same subnet as our ELB. In a production
  # environment it's more common to have a separate private subnet for
  # backend instances.
  subnet_id = "${aws_subnet.subnet_public.0.id}"

  iam_instance_profile = "bebo-admin"

  tags {
    Name = "${var.dc["name"]}-admin-000.${var.aws_domain}"
  }

  provisioner "file" {
    source      = "/keybase/team/teambebo/keys/admin.rsa"
    destination = "/home/admin/.ssh/id_rsa"
  }

  provisioner "file" {
    source      = "/keybase/team/teambebo/keys/admin.rsa"
    destination = "/home/admin/.ssh/admin.aws"
  }

  provisioner "file" {
    source      = "/keybase/team/teambebo/keys/known_hosts"
    destination = "/home/admin/.ssh/known_hosts"
  }

  provisioner "file" {
    source      = "/keybase/team/teambebo/ssl/${var.ssl_cert}"
    destination = "${var.ssl_cert}"
  }

  provisioner "file" {
    source      = "/keybase/team/teambebo/ssl/${var.nginx_cert}"
    destination = "${var.nginx_cert}"
  }

  provisioner "file" {
    source      = "/keybase/team/teambebo/ssl/${var.nginx_key}"
    destination = "${var.nginx_key}"
  }

  provisioner "file" {
    source      = "${var.key_filename}"
    destination = "${var.key_name}"
  }

  provisioner "file" {
    source      = "../../files/pillar_top.tpl"
    destination = "/tmp/pillar_top.sls"
  }

  provisioner "file" {
    content     = "consul:\n  datacenter: ${var.dc["name"]}\nrsyslog:\n  logserver: ${aws_instance.admin.private_ip}\n  port: 514"
    destination = "/tmp/pillar_base_init.sls"
  }

  provisioner "file" {
    destination = "connect"
    content = "${data.template_file.connect.rendered}"
  }

  provisioner "file" {
    destination = "specialize"
    content = "${data.template_file.specialize.rendered}"
  }

  provisioner "file" {
    destination = "install_salt.sh"
    content = "${data.template_file.salt_install.rendered}"
  }

  provisioner "remote-exec" {
    inline = [
      "until [ -f /var/lib/cloud/instance/boot-finished ]; do sleep 1 && echo sleep; done",
      "sudo chown admin /home/admin/.ssh/id_rsa",
      "sudo chown admin /home/admin/.ssh/admin.aws",
      "sudo chown admin /home/admin/.ssh/known_hosts",
      "sudo chown 0600 /home/admin/.ssh/id_rsa",
      "sudo chown 0600 /home/admin/.ssh/admin.aws",
      "sudo chown 0600 /home/adminkk.ssh/known_hosts",
      "sudo mkdir -p /srv/pillar/base",
      "sudo cp /tmp/pillar_top.sls /srv/pillar/top.sls",
      "sudo cp /tmp/pillar_base_init.sls /srv/pillar/base/init.sls",
      "sudo rm -rf /srv/salt",
      "sudo mkdir -p /srv/www/aws-saltstack",
      "sudo chown admin -R /srv/www",
      "git clone git@github.com:bebo/aws-saltstack.git /srv/www/aws-saltstack/${var.saltstack_hash}",
      "cd /srv/www/aws-saltstack/${var.saltstack_hash} && git checkout ${var.saltstack_hash} && cd",
      "ln -s /srv/www/aws-saltstack/${var.saltstack_hash} /srv/www/aws-saltstack/active",
      "sudo mkdir -p /etc/salt/minion.d",
      "sudo sh -c 'echo \"master: ${aws_instance.admin.private_ip}\" > /etc/salt/minion.d/master.conf'",
      "sudo sh -c 'echo ${var.dc["name"]}-admin-000.${var.aws_domain} > /etc/salt/minion_id'",
      "sudo mkdir -p /srv/pillar/base",
      "sudo chmod +x /home/admin/install_salt.sh",
      "sudo /home/admin/install_salt.sh",
      "sudo salt-call --local state.highstate --file-root=/srv/www/aws-saltstack/active --pillar-root=/srv/pillar --retcode-passthrough",
      "sudo salt-key -a ${var.dc["name"]}-admin-000.${var.aws_domain} -y",
      "sudo mkdir -p /srv/secure-files/ssl",
      "sudo mv ${var.ssl_cert} /srv/secure-files/ssl/",
      "sudo mv ${var.nginx_cert} /srv/secure-files/ssl/",
      "sudo mv ${var.nginx_key} /srv/secure-files/ssl/",
      "sudo chown -R root:root /srv/secure-files",
      "sudo chmod 600 -R /srv/secure-files",
      "sudo chmod 600 /srv/secure-files/ssl/${var.ssl_cert}",
      "sudo chmod 600 /srv/secure-files/ssl/${var.nginx_cert}",
      "sudo chmod 600 /srv/secure-files/ssl/${var.nginx_key}",
      "sudo mkdir -p /etc/salt/ssl",
      "sudo mv ${var.key_name} /etc/salt/ssl/${var.key_name}_id_rsa",
      "sudo chmod 0400 /etc/salt/ssl/${var.key_name}_id_rsa",
      "sudo chmod +x /home/admin/connect",
      "sudo chmod +x /home/admin/specialize",
    ]
  }
}

resource "aws_ebs_volume" "admin_syslog" {
  availability_zone = "${aws_instance.admin.availability_zone}"
  size              = 250

  tags {
    Name = "${aws_vpc.main_vpc.id}-admin_syslog"
  }
}

resource "aws_volume_attachment" "admin_syslog" {
  device_name  = "/dev/xvdb"
  volume_id    = "${aws_ebs_volume.admin_syslog.id}"
  instance_id  = "${aws_instance.admin.id}"
  force_detach = true
}

resource "aws_eip" "admin" {
  vpc      = true
  instance = "${aws_instance.admin.id}"
}

resource "aws_route53_record" "admin-beboinc" {
  zone_id = "Z1DZ79XB83YGFN"
  name    = "${var.dc["name"]}-admin.beboinc.com"
  type    = "A"
  ttl     = "300"
  records = ["${aws_eip.admin.public_ip}"]
}

resource "aws_route53_record" "consul" {
  zone_id = "${var.dns_zone_id}"
  name    = "${var.dc["name"]}-consul.${var.bebo_domain}"
  type    = "A"

  alias {
    name                   = "${aws_alb.admin.dns_name}"
    zone_id                = "${aws_alb.admin.zone_id}"
    evaluate_target_health = false
  }
}
