# composer
resource "aws_security_group" "composer" {
  name        = "composer"
  description = "composer"
  vpc_id      = "${aws_vpc.main_vpc.id}"

  ingress {
    protocol    = "udp"
    from_port   = 3478
    to_port     = 3478
    cidr_blocks = ["0.0.0.0/0"]
    description = "STUN"
  }

  ingress {
    protocol    = "tcp"
    from_port   = 20000
    to_port     = 65535
    cidr_blocks = ["0.0.0.0/0"]
    description = "Janus -- TCP"
  }

  ingress {
    protocol    = "udp"
    from_port   = 20000
    to_port     = 65535
    cidr_blocks = ["0.0.0.0/0"]
    description = "Janus"
  }

  ingress {
    protocol    = "tcp"
    from_port   = 3478
    to_port     = 3478
    cidr_blocks = ["0.0.0.0/0"]
    description = "STUN"
  }

  ingress {
    protocol    = "tcp"
    from_port   = 443
    to_port     = 443
    cidr_blocks = ["0.0.0.0/0"]
    description = "TURN"
  }

  ingress {
    protocol    = "tcp"
    from_port   = 8443
    to_port     = 8443
    cidr_blocks = ["0.0.0.0/0"]
    description = "NGINX_OBIWAN_WS"
  }

  tags {
    Name = "${aws_vpc.main_vpc.id}-composer"
  }
}

resource "aws_route53_record" "speedproxy" {
  count                            = "${var.zones_count}"
  zone_id                          = "${var.dns_zone_id}"
  name                             = "${var.dc["name"]}-speed.${var.bebo_domain}"
  type                             = "A"
  ttl                              = "10"
  health_check_id                  = "${element(aws_route53_health_check.composerproxy.*.id, count.index)}"
  multivalue_answer_routing_policy = true
  set_identifier                   = "${var.dc["name"]}-speed.00${count.index}"
  records                          = ["${element(aws_eip.composerproxy.*.public_ip, count.index)}"]
}

resource "aws_route53_record" "marioproxy" {
  count                            = "${var.zones_count}"
  zone_id                          = "${var.dns_zone_id}"
  name                             = "${var.dc["name"]}-mario.${var.bebo_domain}"
  type                             = "A"
  ttl                              = "10"
  health_check_id                  = "${element(aws_route53_health_check.composerproxy.*.id, count.index)}"
  multivalue_answer_routing_policy = true
  set_identifier                   = "${var.dc["name"]}-mario.00${count.index}"
  records                          = ["${element(aws_eip.composerproxy.*.public_ip, count.index)}"]
}
