#!/bin/bash

total_supervisor_cnt=${admin_supervisor_service_cnt}

if /usr/share/consul/bin/consul kv get blabv1/projects/composer-ami/dev; then
    echo "projects have been set in consul -- specializing"

    sudo python3 /usr/local/sbin/salt_cloud.py

    supervisor_running=true

    supervisor_cnt=0

    for RES in $(sudo supervisorctl status | awk '{print $2}'); do
        supervisor_cnt=$((supervisor_cnt+1))
        if [ $RES == "ERROR" ]; then
            supervisor_running=false
        fi
    done

    echo "found $supervisor_cnt supervisor services, expected >= $total_supervisor_cnt"
    if [ $supervisor_cnt -lt $total_supervisor_cnt ]; then
        supervisor_running=false
    fi

    echo "supervisor_running? $supervisor_running"
    if [ "$supervisor_running" = false ]; then
        echo "reloading consul agent"
        /usr/share/consul/bin/consul reload
    fi

    sudo systemctl restart rsyslog

else
    echo "specialize didnt finish -- consul keys missing"
fi
