# provider.aws: version = "~> 1.2"

variable "aws_region" {
  description = "AWS region to launch servers."
}

variable "core_ami" {
  description = "AMI to base boxes off of. AMI is the active 'core' ami each region"
}

variable "key_filename" {
  description = "private ssh key filename for admin"
}

variable "key_name" {
  description = "private ssh key name for admin"
}

variable "dns_zone_id" {
  description = "zone id for bebo.com / bebo-dev.com"
  default     = "ZAT94KJ4QOV34"
}

variable "dc" {
  default = {
    name = "name"
  }
}

variable "vpc" {
  default = {}
}

variable "zones" {
  description = "AWS availability zones"
  default     = []
}

variable "zones_count" {
  default     = 0
  description = "AWS availability zones (count)"
}

variable "bebo_allowed_prod_ip_addresses" {
  default = [
    {
      cidr_block  = "208.64.184.114/32"
      description = "bebo hq ip"
    },
    {
      cidr_block  = "54.183.55.132/32"
      description = "bebo usw1 VPN ip"
    },
    {
      cidr_block  = "52.8.218.122/32"
      description = "fpn build box"
    },
    {
      cidr_block  = "54.183.109.177/32"
      description = "jenkins 002"
    },
    {
      cidr_block  = "54.183.141.100/32"
      description = "jenkins 001"
    },
    {
      cidr_block  = "52.9.150.71/32"
      description = "usw1-admin"
    },
    {
      cidr_block  = "54.219.138.36/32"
      description = "ronegade box"
    },
    {
      cidr_block  = "52.52.2.179/32"
      description = "furqan greengoblin"
    },
    {
      cidr_block  = "54.183.234.118/32"
      description = "theonlyjohnny box"
    },
    {
      cidr_block = "52.9.122.162/32"
      description = "jenkins windows box"
    },
  ]
}

variable "bebo_domain" {
  description = "dns domain bebo.com / bebo-dev.com"
  default     = "bebo.com"
}

variable "aws_domain" {
  default = "aws.bebo.com"
}

variable "ssl_cert" {
  description = "the ssl certificate to use for https"
  default     = "bundle-key-star.bebo.com.pem"
}

variable "nginx_cert" {
  description = "the ssl certificate to use for https"
  default     = "bundle-star.bebo.com.pem"
}

variable "nginx_key" {
  description = "the ssl certificate to use for https"
  default     = "star.bebo.com.key"
}

variable "salt_version" {
  description = "the version of salt to download from http://repo.saltstack.com/apt/debian/9/amd64/archive/"
  default     = "2017.7.4"
}

variable "saltstack_hash" {
  description = "saltstack commit hash"
}

variable "composer_ami" {
  description = "composer ami"
}
