## security groups

# default security group, mimics default aws default
resource "aws_default_security_group" "default" {
  vpc_id = "${aws_vpc.main_vpc.id}"

  ingress {
    protocol  = -1
    self      = true
    from_port = 0
    to_port   = 0
  }

  egress {
    from_port   = 0
    to_port     = 0
    protocol    = "-1"
    cidr_blocks = ["0.0.0.0/0"]
  }

  tags {
    Name = "${aws_vpc.main_vpc.id}-default"
  }
}

# allow http(s) from HQ and VPN
resource "aws_security_group" "allow_http_from_hq_vpn" {
  name        = "allow_http_from_hq_vpn"
  description = "allow traffic from HQ and VPN"
  vpc_id      = "${aws_vpc.main_vpc.id}"

  # NO INLINE ingress/egress rules !!!

  tags {
    Name = "${aws_vpc.main_vpc.id}-allow_http_from_hq_vpn"
  }
}

resource "aws_security_group_rule" "allow_http_from_hq_ingress_tcp_443" {
  count             = "${length(var.bebo_allowed_prod_ip_addresses)}"
  type              = "ingress"
  protocol          = "tcp"
  from_port         = 443
  to_port           = 443
  cidr_blocks       = ["${lookup(var.bebo_allowed_prod_ip_addresses[count.index], "cidr_block")}"]
  description       = "${lookup(var.bebo_allowed_prod_ip_addresses[count.index], "description")}"
  security_group_id = "${aws_security_group.allow_http_from_hq_vpn.id}"
}

resource "aws_security_group_rule" "allow_http_from_hq_ingress_tcp_80" {
  count             = "${length(var.bebo_allowed_prod_ip_addresses)}"
  type              = "ingress"
  protocol          = "tcp"
  from_port         = 80
  to_port           = 80
  cidr_blocks       = ["${lookup(var.bebo_allowed_prod_ip_addresses[count.index], "cidr_block")}"]
  description       = "${lookup(var.bebo_allowed_prod_ip_addresses[count.index], "description")}"
  security_group_id = "${aws_security_group.allow_http_from_hq_vpn.id}"
}

# admin
resource "aws_security_group" "admin" {
  name        = "admin"
  description = "admin box"
  vpc_id      = "${aws_vpc.main_vpc.id}"

  # NO INLINE ingress/egress rules !!!

  tags {
    Name = "${aws_vpc.main_vpc.id}-admin"
  }
}

resource "aws_security_group_rule" "allow_admin_ingress_tcp_443" {
  count             = "${length(var.bebo_allowed_prod_ip_addresses)}"
  type              = "ingress"
  protocol          = "tcp"
  from_port         = 443
  to_port           = 443
  cidr_blocks       = ["${lookup(var.bebo_allowed_prod_ip_addresses[count.index], "cidr_block")}"]
  description       = "${lookup(var.bebo_allowed_prod_ip_addresses[count.index], "description")}"
  security_group_id = "${aws_security_group.admin.id}"
}

resource "aws_security_group_rule" "allow_admin_ingress_tcp_80" {
  count             = "${length(var.bebo_allowed_prod_ip_addresses)}"
  type              = "ingress"
  protocol          = "tcp"
  from_port         = 80
  to_port           = 80
  cidr_blocks       = ["${lookup(var.bebo_allowed_prod_ip_addresses[count.index], "cidr_block")}"]
  description       = "${lookup(var.bebo_allowed_prod_ip_addresses[count.index], "description")}"
  security_group_id = "${aws_security_group.admin.id}"
}

resource "aws_security_group_rule" "allow_admin_ingress_tcp_22" {
  count             = "${length(var.bebo_allowed_prod_ip_addresses)}"
  type              = "ingress"
  protocol          = "tcp"
  from_port         = 22
  to_port           = 22
  cidr_blocks       = ["${lookup(var.bebo_allowed_prod_ip_addresses[count.index], "cidr_block")}"]
  description       = "${lookup(var.bebo_allowed_prod_ip_addresses[count.index], "description")}"
  security_group_id = "${aws_security_group.admin.id}"
}

# vpn-site-to-site
resource "aws_security_group" "vpn-tunnel" {
  name        = "vpn-tunnel"
  description = "vpn site to site tunnel to usw2"
  vpc_id      = "${aws_vpc.main_vpc.id}"

  ingress {
    protocol    = "udp"
    from_port   = 10000
    to_port     = 10000
    cidr_blocks = ["52.27.136.77/32"]
    description = "usw2 vpn"
  }

  tags {
    Name = "${aws_vpc.main_vpc.id}-vpn-tunnel"
  }
}

resource "aws_security_group" "composer" {
  name        = "composer"
  description = "composer"
  vpc_id      = "${aws_vpc.main_vpc.id}"

  ingress {
    protocol    = "tcp"
    from_port   = 443
    to_port     = 443
    cidr_blocks = ["0.0.0.0/0"]
    description = "TURN"
  }

  ingress {
    protocol    = "tcp"
    from_port   = 8443
    to_port     = 8443
    cidr_blocks = ["0.0.0.0/0"]
    description = "NGINX_OBIWAN_WS"
  }

  ingress {
    protocol    = "tcp"
    from_port   = 1935
    to_port     = 1935
    cidr_blocks = ["0.0.0.0/0"]
    description = "NGINX RTMP"
  }

  tags {
    Name = "${aws_vpc.main_vpc.id}-composer"
  }
}
