## Elastic Load Balancers

resource "aws_alb_target_group" "admin-http" {
  name     = "${var.dc["name"]}-admin-http"  # _ not allowed
  port     = 80
  protocol = "HTTP"
  vpc_id   = "${aws_vpc.composer.id}"
}

resource "aws_alb" "admin" {
  name            = "${var.dc["name"]}-admin"
  subnets         = ["${aws_subnet.subnet_public.*.id}"]
  security_groups = ["${aws_security_group.allow_http_from_hq_vpn.id}", "${aws_security_group.admin_elb.id}"]
}

resource "aws_alb_listener" "https" {
  load_balancer_arn = "${aws_alb.admin.id}"
  port              = "443"
  protocol          = "HTTPS"
  certificate_arn   = "${data.aws_acm_certificate.bebo_wildcard.arn}"

  default_action {
    target_group_arn = "${aws_alb_target_group.admin-http.id}"
    type             = "forward"
  }
}

resource "aws_lb_target_group_attachment" "admin_http" {
  target_group_arn = "${aws_alb_target_group.admin-http.id}"
  target_id        = "${aws_instance.admin.id}"
  port             = 80
}
