#!/bin/bash

local_ipv4="$(curl -s http://169.254.169.254/latest/meta-data/local-ipv4)"

wait_until_ping() {
    until ! ( sudo salt "*" test.ping | grep "Not connected" ); do echo "sleeping because not all nodes responding to ping" && sleep 1; done
}

connect() {

    echo "connecting"
    if ! (/usr/share/consul/bin/consul catalog nodes | grep -- "-consul-") &>> /dev/null; then
        # list nodes in consul, grep for the consul nodes. If they don't exist, we must not be part of the consul cluster yet

        echo "not part of consul cluster"
        sudo salt-key -A -y
        # add self to salt-key and accept implicitly
        wait_until_ping
        sudo salt '*' state.highstate
        # highstate everything

        wait_until_ping
        sudo salt '*' cmd.run "systemctl restart consul"
        # restart consul everywhere

    fi

    sudo salt "*proxy*" cmd.run "if ! ( sudo netstat -tlpn | grep 443 ); then sudo salt-call state.highstate && journalctl -xe ; fi;"

}

connect
wait_until_ping
connect

echo "done connecting to salt/consul"
