# Composer Proxy Instances
resource "aws_instance" "composerproxy" {

  count = "${var.zones_count}"

  connection {
    # The default username for our AMI
    # user = "debian"
    user = "admin"
    private_key = "${file(var.key_filename)}"
    bastion_host = "${aws_eip.admin.public_ip}"
    host = "${self.private_ip}"
  }
  instance_type = "t2.medium"

  root_block_device {
    volume_size = "100"
  }

  instance_initiated_shutdown_behavior = "terminate"

  # Lookup the correct AMI based on the region
  # we specified
  ami = "${var.general_ami}"

  # The name of our SSH keypair we created above.
  key_name = "${var.key_name}"

  vpc_security_group_ids = ["${aws_default_security_group.default.id}",
                                                        "${aws_security_group.public_https.id}"]

  subnet_id = "${element(aws_subnet.subnet_public.*.id, count.index % var.zones_count)}"

  iam_instance_profile = "bebo-composerproxy"

  tags {
    Name = "${var.dc["name"]}-composerproxy-00${count.index}.${var.aws_domain}"
    Role = "composerproxy"
  }

  provisioner "file" {
    source = "/keybase/team/teambebo/ssl/${var.ssl_cert}"
    destination = "${var.ssl_cert}"
  }

  provisioner "remote-exec" {
    inline = [
      "until [ -f /var/lib/cloud/instance/boot-finished ]; do sleep 1 && echo sleep; done",
      "sudo rm -rf /srv/salt",
      "sudo sh -c 'echo ${var.dc["name"]}-composerproxy-00${count.index}.${var.aws_domain} > /etc/salt/minion_id'",
      "sudo sh -c 'echo \"master: ${aws_instance.admin.private_ip}\" > /etc/salt/minion.d/master.conf'",
      "until ( sudo apt update | grep \"11: Resource temporarily unavailable\" ); do echo \"waiting on apt because got opcode11\" && sleep 1; done",
      "sudo apt install -y salt-minion",
      "sudo mkdir -p /etc/haproxy",
      "sudo mv ${var.ssl_cert} /etc/haproxy/${var.ssl_cert}"
    ]
  }

  depends_on = ["aws_instance.admin", "aws_instance.consul", "aws_eip.admin"]
}

resource "aws_eip" "composerproxy" {
    count = "${var.zones_count}"
    instance = "${element(aws_instance.composerproxy.*.id, count.index)}"
    vpc      = true
}
