mac_address="$(curl -s http://169.254.169.254/latest/meta-data/mac)"
vpc_id="$(curl -s http://169.254.169.254/latest/meta-data/network/interfaces/macs/$mac_address/vpc-id)"
local_ipv4="$(curl -s http://169.254.169.254/latest/meta-data/local-ipv4)"
domain=$(hostname -d)
bebo_region="$(sudo salt-call grains.get vpc_tags:Name)"
total_composerpostgres_count=2
total_speedtest_count=2
# define variables

sudo salt "*proxy*" cmd.run "if ! ( sudo netstat -tlpn | grep 443 ); then sudo salt-call state.highstate && journalctl -xe ; fi;"

composerpostgres_count="$(sudo salt-key | grep composerpostgres | wc -l)"
speedtest_count="$(sudo salt-key | grep speedtest | wc -l)"

echo "$composerpostgres_count composerpostgres servers found, expected $total_composerpostgres_count"
if [ $composerpostgres_count -eq $total_composerpostgres_count ]; then
    echo "$composerpostgres_count composerpostgresses, we gucci"
else
    echo "spinning up compostpostgreses"
    for i in $(seq 1 $total_speedtest_count); do
        profile=$vpc_id-composerpostgres
        (( $i % 2 )) && profile="$profile-A" || profile="$profile-B"
        sudo salt-cloud -p $profile $bebo_region-composerpostgres-00$i.$domain
    done
fi

echo "$speedtest_count speedtest servers found, expected $total_speedtest_count"

if [ $speedtest_count -eq $total_speedtest_count ]; then
    echo "$total_speedtest_count speedtests, we gucci"
else
    echo "spinning up speedtests"
    for i in $(seq 1 $total_speedtest_count); do
        profile=$vpc_id-speedtest
        (( $i % 2 )) && profile="$profile-A" || profile="$profile-B"
        sudo salt-cloud -p $profile $bebo_region-speedtest-00$i.$domain
    done
fi
