import requests

from bran.shared.config import config
from bran.shared.logger import log


class Pharah(object):
    def get_detectors(self):
        return self._get('bran/detector')

    def get_match(self, match_id, user_id):
        return self._get('match?match_id={}'.format(match_id), {
            'X-User-Id': user_id
        })

    def get_user_me(self, user_id):
        return self._get('user/me', {
            'X-User-Id': user_id
        })

    def delete_user_state_bran(self, user_id):
        return self._delete('user/state/bran', {'X-User-Id': user_id})

    def put_user_state(self, user_id, data):
        body = {
            'user_id': user_id,
            'data': data,
            'expire': 15
        }
        headers = {'X-User-Id': user_id}
        return self._put('user/state/bran', body, headers)

    def post_user_detection(self, user_id, detection_type, detection_id, label, prob, image_url, game):
        body = {
            'user_id': user_id,
            'user_{}_id'.format(detection_type): detection_id,
            'label': label,
            'prob': prob,
            'image_url': image_url,
            'game': game
        }
        headers = {'X-User-Id': user_id}
        return self._post('user/{}'.format(detection_type), body, headers)

    def _get(self, url, headers={}):
        headers['X-Api-Key'] = config.API_KEY
        response = requests.get('{}/{}'.format(config.PHARAH_URL, url), headers=headers)
        response.raise_for_status()
        return response.json().get('result', [])

    def _post(self, url, body={}, headers={}):
        headers['X-Api-Key'] = config.API_KEY
        response = requests.post('{}/{}'.format(config.PHARAH_URL, url), json=body, headers=headers)
        response.raise_for_status()
        return response.json().get('result', [])

    def _put(self, url, body={}, headers={}):
        headers['X-Api-Key'] = config.API_KEY
        response = requests.put('{}/{}'.format(config.PHARAH_URL, url), json=body, headers=headers)
        response.raise_for_status()
        return response.json().get('result', [])

    def _delete(self, url, headers={}):
        headers['X-Api-Key'] = config.API_KEY
        response = requests.delete('{}/{}'.format(config.PHARAH_URL, url), headers=headers)
        response.raise_for_status()
        return response.json().get('result', [])

PharahAPI = Pharah()
