from bebo.sqs import SQS
from bran.shared.config import config

from bran.shared.logger import log

class SQSApi(object):
    def __init__(self):
        self.handlers = []
        self.sqs = SQS(self.on_message, config.SNS_TOPIC_ARN, log=log, runner_count=1)

    def start(self):
        self.sqs.start()

    def register_handler(self, handler):
        self.handlers.append(handler)

    def on_message(self, messages):
        for message in messages:
            for handler in self.handlers:
                handler(message)

SQSSingleton = SQSApi()
