import json
import threading
import logging

from tornado.ioloop import IOLoop
import tornado
import tornado.web

from bran.shared.config import config
from bran.shared.logger import log


class ServiceHealthResource(tornado.web.RequestHandler):
    def initialize(self, session_controller):
        self.session_controller = session_controller

    def get(self):
        payload = self.session_controller.get_health()
        self.write(json.dumps(payload))


class ServiceHealthController(object):
    def __init__(self, session_controller):
        self.session_controller = session_controller

    def start(self):
        t = threading.Thread(target=self.do_start, daemon=True)
        t.start()

    def do_start(self):
        logging.getLogger('tornado').addHandler(logging.NullHandler) # prevent double logging
        ioloop = tornado.ioloop.IOLoop()
        self.app = tornado.web.Application([
            (r"/active", ServiceHealthResource,
             dict(session_controller=self.session_controller))
        ])
        self.app.listen(config.PORT)
        ioloop.start()
