from queue import Queue
import json
import multiprocessing
import time

from bebo import dispatcher
from bebo import utils as bebo_utils
import redis
import cachetools

from bran.session import Session
from bran.shared.config import config
from bran.shared.logger import log
import sentry_sdk
import bran.shared.util as util
from bran.shared.user import UserAPI


class TrackerWorker(multiprocessing.Process):
    def __init__(self):
        super().__init__()
        self.username_cache = cachetools.LRUCache(maxsize=config.CAPACITY)

    def run(self):
        track_redis = redis.Redis(
            host=config.LOCAL_REDIS_URL, db=config.REDIS_TRACK_DB)
        while True:
            try:
                all_keys = [k.decode('utf-8') for k in track_redis.keys("*")]
                for k in all_keys:
                    event_list = track_redis.lrange(k, 0, -1)
                    event_payload = {}

                    for e in event_list:
                        event_payload.update(json.loads(e.decode('utf-8')))

                    es_payload = bebo_utils.convert_to_es(event_payload)
                    if "user_id" in event_payload:
                        user = UserAPI.get(event_payload['user_id'])
                        es_payload["user"] = bebo_utils.make_user_es_friendly(user)

                    es_payload["_id"] = k

                    dispatcher.write("gamesense_es", es_payload)

                    track_redis.delete(k)
            except KeyboardInterrupt:
                raise
            except Exception as e:
                sentry_sdk.capture_exception()
                log.error("error tracking event: {}".format(e), exc_info=True)

            time.sleep(10)

class TrackerController(object):
    def __init__(self):
        self.worker = TrackerWorker()
        self.worker.daemon = True

    def start(self):
        self.worker.start()

    def stop(self):
        self.worker.terminate()
