from bran.shared.config import config
import sentry_sdk
import torch
import random

import numpy
import cv2
import numpy as np

from bran.detectors.base_detector import BaseDetector
from bran.shared.logger import log
from bran.shared.util import S_TO_NS
from bran.train.nets import model_from_config
from bran.models.pytorch_svhn import PyTorchSVHN
from bran.api.sqs import SQSSingleton
import bran.shared.image_utils as ImageUtils
from bran.models.pytorch_pool import PyTorchPool

class ApexKillDetector(BaseDetector):
    def __init__(self, *args, **kwargs):
        kwargs['name'] = 'kill'
        kwargs['game'] = 'apex'
        kwargs['save_event'] = True
        super().__init__(*args, **kwargs)

        self.model = PyTorchPool('apex-kill')

        self.last_kill = 0
        self.user_game_id = None

    def do_detect(self, user_id, detection_id, frame, timestamp, **kwargs):
        user_game_id = kwargs.get('user_game_id', None)
        if user_game_id != self.user_game_id:
            log.info("ApexKillDetector do_detect user_game_id != self.user_game_id")
            self.last_kill = 0
            self.user_game_id = user_game_id

        image = ImageUtils.crop(
            frame, {"x": 0.819, "y": 0.047, "width": 0.034, "height": 0.031})
        image = cv2.cvtColor(image, cv2.COLOR_BGR2GRAY)

        label, prob = self.model.detect(image)
        detected_prob = prob * 100

        detected = False
        duplicate = False

        output = "no"
        if detected_prob >= 99 and label != -1:
            if label <= self.last_kill:
                log.info("DUP APEX KILL {} {} {} -- IGNORING".format(label, prob,
                                                              self.last_kill))
                output = "yes"
                duplicate = True
            else:
                log.info("APEX KILL {} {} {}".format(label, prob, self.last_kill))
                self.last_kill += 1
                output = "yes"
                detected = True

        return {
            "detected": detected,
            "duplicate": duplicate,
            "label": output,
            "prob": detected_prob
        }
