import random

import numpy
import cv2
import numpy as np

from bran.detectors.base_detector import BaseDetector
from bran.shared.logger import log
from bran.shared.util import S_TO_NS
from bran.train.nets import model_from_config
from bran.models.pytorch_resnet import PyTorchResNet
import bran.shared.image_utils as ImageUtils
from bran.models.pytorch_pool import PyTorchPool

class VictoryDetector(BaseDetector):
    def __init__(self, *args, **kwargs):
        kwargs['name'] = 'victory'
        kwargs['save_event'] = True
        super().__init__(*args, **kwargs)

        self.model = PyTorchPool('victory')

        self.dedupe_timestamp = None
        self.dedupe_time_threshold = 300

    def do_detect(self, user_id, detection_id, frame, timestamp, **kwargs):
        image = ImageUtils.crop(frame,
            { "x": 0.21875, "y": 0, "width": 0.5625, "height": 0.5 })
        image = cv2.cvtColor(image, cv2.COLOR_BGR2RGB)
        label, prob = self.model.detect(image)
        detected_prob = prob * 100

        detected = False
        duplicate = False

        if label == "yes" and detected_prob > 90:
            if self.dedupe_timestamp and (timestamp - self.dedupe_timestamp) < self.dedupe_time_threshold * S_TO_NS:
                log.info("DUPLICATE {} {:.3f}s -- IGNORING".format(self.name,
                                                                   (timestamp - self.dedupe_timestamp) / S_TO_NS))
                duplicate = True
            else:
                self.dedupe_timestamp = timestamp
                detected = True

        return {"detected": detected, "duplicate": duplicate, "prob": detected_prob, "label": label}
