import json
import os
import tarfile
import urllib.parse

import boto3

from bran.shared.config import config
from bran.shared.logger import log
from bran.shared.util import get_md5_etag, get_s3_etag
import sentry_sdk

s3 = boto3.resource("s3")

def download_models():
    log.info("detectors {}".format(config.DETECTOR_BUCKET_URL))

    _scheme, bucket, path, _query, _frag = urllib.parse.urlsplit(
            config.DETECTOR_BUCKET_URL)

    os.makedirs("/var/bran/gamesense/detectors", exist_ok=True)
    os.makedirs("/var/bran/gamesense/tarfiles", exist_ok=True)

    for obj in s3.Bucket(bucket).objects.filter(Prefix=path.lstrip('/')):
        filename = os.path.basename(obj.key)

        extract_dir = "/var/bran/gamesense/detectors/{}".format(filename.split('.')[0])
        download_path = "/var/bran/gamesense/tarfiles/{}".format(filename)

        if os.path.exists(download_path) and os.path.exists(extract_dir):
            if get_md5_etag(download_path) == obj.e_tag or \
                get_s3_etag(download_path) == obj.e_tag:
                log.debug('skip existing file {} {}'.format(obj.key, obj.e_tag))
                continue

        s3.Bucket(bucket).download_file(obj.key, download_path)
        log.info("Downloading {} to {}".format(obj.key, download_path))
        tar = tarfile.open(download_path)
        tar.extractall(path=extract_dir)
