import json

import redis
from bran.api.pharah import PharahAPI
from bran.shared.config import config

class User(object):
#  TODO move to bebo-python-commons
    def __init__(self):
        super().__init__()
        self.redis = redis.Redis(host=config.REGIONAL_REDIS_URL, db=config.REDIS_AUTH_DB)

    def get(self, user_id):
        user = self.get_user_from_redis(user_id)
        if user:
            return user

        return self.get_user_from_api(user_id)

    def get_user_from_redis(self, user_id):
        redis_user = self.redis.get(user_id)
        if not redis_user:
            return None

        return json.loads(redis_user.decode('utf-8'))

    def get_user_from_api(self, user_id):
        user_response = PharahAPI.get_user_me(user_id)
        try:
            user = user_response[0]
            self.save_user_to_redis(user_id, user)
            return user
        except IndexError:
            return None

    def save_user_to_redis(self, user_id, user):
        self.redis.setex(user_id, config.REDIS_AUTH_TTL, json.dumps(user))

UserAPI = User()
