import csv
import json
import os
import threading
import urllib
import uuid
import time
import hashlib

from bebo import dispatcher
from bebo import utils as bebo_utils
import cv2
import numpy as np
import redis
import requests
import sentry_sdk

from bran.shared.config import config
from bran.shared.logger import log

S_TO_NS = 1000000000

track_redis = redis.Redis(host=config.LOCAL_REDIS_URL,
                          db=config.REDIS_TRACK_DB)

def get_app_version():
    if config.ENV == "local":
        return "0.0.0"

    return os.path.realpath("./").split("/")[-1]


def track_event_sync(event_payload, event_id):
    track_redis.lpush(event_id, json.dumps(event_payload))
    track_redis.expire(event_id, 30)


def track_event(event_payload, event_id=None):
    if event_id is None:
        event_id = uuid.uuid4().hex
    event_payload['event_at'] = int(round(time.time() * 1000))
    t1 = threading.Thread(target=track_event_sync, args=[
                          event_payload, event_id])
    t1.start()


def download_image(url):
    resp = urllib.request.urlopen(url)
    image = np.asarray(bytearray(resp.read()), dtype="uint8")
    image = cv2.imdecode(image, cv2.IMREAD_COLOR)
    return image


def notify(data):
    url = config.WEBHOOK_URL

    requests.post(url, data={
        "payload": json.dumps(data)
    })

def get_md5_etag(filename):
  f = open(filename, 'rb')
  m = hashlib.md5()
  while True:
    data = f.read(10240)
    if len(data) == 0:
        break
    m.update(data)
  return '"{}"'.format(m.hexdigest())

def get_s3_etag(source_path, chunk_size=8 * 1024 * 1024, expected=None):
    md5s = []
    with open(source_path,'rb') as fp:
        while True:
            data = fp.read(chunk_size)
            if not data:
                break
            md5s.append(hashlib.md5(data))

    digests = b"".join(m.digest() for m in md5s)
    new_md5 = hashlib.md5(digests)
    new_etag = '"{}-{}"'.format(new_md5.hexdigest(),len(md5s))
    return new_etag
