import os
import glob


class AverageMeter(object):
     """Computes and stores the average and current value"""
     def __init__(self):
         self.reset()

     def reset(self):
         self.val = 0
         self.avg = 0
         self.sum = 0
         self.count = 0

     def update(self, val, n=1):
         self.val = val
         self.sum += val * n
         self.count += n
         self.avg = self.sum / self.count


def get_best_weight_file(folder):
    if os.path.exists(os.path.join(folder, "weights.pt")):
        return os.path.join(folder, "weights.pt")

    epochs = list(sorted(glob.glob(os.path.join(folder, "epoch_*.pt")),
        key=lambda x: int(os.path.splitext(os.path.basename(x))[0].split("_")[-1])))
    model_file = epochs[-1]
    return model_file

