import os
import torch
import torch.nn as nn
import torch.nn.functional as F
import torchvision
from .resnet import BasicBlock


class SVHNNet(nn.Module):
    def __init__(self):
        super().__init__()
        self.in_planes = 64

        block = BasicBlock
        num_blocks = [2, 2, 2, 2]
        num_classes = 11

        self.conv1 = nn.Conv2d(1, 64, kernel_size=3,
                               stride=1, padding=1, bias=False)
        self.bn1 = nn.BatchNorm2d(64)
        self.layer1 = self._make_layer(block, 64, num_blocks[0], stride=1)
        self.layer2 = self._make_layer(block, 128, num_blocks[1], stride=2)
        self.layer3 = self._make_layer(block, 256, num_blocks[2], stride=2)
        self.layer4 = self._make_layer(block, 512, num_blocks[3], stride=2)

        self.digit1 = nn.Linear(512*block.expansion, num_classes)
        self.digit2 = nn.Linear(512*block.expansion, num_classes)
        self.digit3 = nn.Linear(512*block.expansion, num_classes)

    def _make_layer(self, block, planes, num_blocks, stride):
        strides = [stride] + [1]*(num_blocks-1)
        layers = []
        for stride in strides:
            layers.append(block(self.in_planes, planes, stride))
            self.in_planes = planes * block.expansion
        return nn.Sequential(*layers)

    def forward(self, x):
        out = F.relu(self.bn1(self.conv1(x)))
        out = self.layer1(out)
        out = self.layer2(out)
        out = self.layer3(out)
        out = self.layer4(out)
        out = F.avg_pool2d(out, 4)
        out = out.view(out.size(0), -1)

        return [
            self.digit1(out),
            self.digit2(out),
            self.digit3(out),
        ]
