from IPython.display import Image, HTML, display
import urllib.request
import cv2
import numpy as np


def show_image(img):
    display(Image(url=img))


def show_images(urls, width=190):
    display(HTML(''.join(
        ["<img style='width: {}px; margin: 0px; float: left; border: 1px solid black;' src='{}' />".format(width, url) for url in urls])))


def url_to_image(url):
    resp = urllib.request.urlopen(url)
    image = np.asarray(bytearray(resp.read()), dtype="uint8")
    image = cv2.imdecode(image, cv2.IMREAD_COLOR)
    return image


from PIL import Image
import requests
from io import BytesIO


def url_to_np(url):
    response = requests.get(url)
    img = np.array(Image.open(BytesIO(response.content)))
    return img


import cv2
import matplotlib.pyplot as plt


def fortnite_kill_crop(img):
    ih, iw, _id = img.shape
    #img = cv2.resize(img, (1920, 1080))
    #x,y,w,h = 1830,0,120,60
    x, y, w, h = map(int, [iw * 0.85, ih * 0.01, iw * 0.2, ih * 0.04])
    img = img[y:y+h, x:x+w]
    #img = cv2.resize(img, (128, 32))
    return img


import boto3
import urllib.parse
from pymongo import MongoClient
import time
from bran.shared.config import config


def backfill_preclassify_to_mongo(path, collection):
    mongo_collection = MongoClient(config.MONGO_DB)['pre_classify'][collection]

    scheme, bucket, path, _query, _frag = urllib.parse.urlsplit(path)
    counter = 0
    if scheme == 's3':
        objs = boto3.resource('s3').Bucket(
            bucket).objects.filter(Prefix=path.lstrip('/'))

        size = sum(1 for _ in objs.all())

        div, mod = divmod(size, 10)

        for obj in objs:
            if mongo_collection.count_documents({'bucket_name': bucket, 'key': obj.key}):
                continue

            now = time.time()
            doc = {
                "bucket_name": bucket,
                "key": obj.key,
                "created_at": now,
                "updated_at": now
            }
            mongo_collection.insert_one(doc)
            counter += 1

            if (counter - mod) % div == 0:
                print('{:.2f}% [{}/{}]'.format(counter /
                                               size * 100, counter, size))
    print('Total', counter)

import matplotlib.pyplot as plt
import cv2


def inspect_img(dataset, idx):
    img, label, _ = dataset[idx]

    raw, _, _, data = dataset.get_raw_data(idx)

    print(idx, img.shape, label, data)
    plt.imshow(cv2.cvtColor(img.numpy().swapaxes(0, 2), cv2.COLOR_RGB2BGR))
    plt.show()

    plt.imshow(cv2.cvtColor(raw, cv2.COLOR_RGB2BGR))
    plt.show()
