from shutil import copyfile
from datetime import datetime
import json
import logging
import os
import sys
import time
import traceback
import uuid
import math
import functools

from imgaug import augmenters as iaa
import argparse
import boto3
import imgaug
import numpy as np
import torch
import torchvision
import tqdm
from tensorboardX import SummaryWriter
import torchvision.transforms as transforms
import cv2

from bran.shared.config import config, get_config
from bran.shared.logger import log
import bran.shared.image_utils as ImageUtils
from bran.train import AverageMeter
from bran.train.mongo_dataset import MongoDataset, MalformedError

seq = iaa.Sequential([
    iaa.Affine(
        # scale images to 95-105% of their size, individually per axis
        scale={"x": (0.95, 1.05), "y": (0.95, 1.05)},
        # translate by -5 to +5 percent (per axis)
        translate_percent={"x": (-0.05, 0.05), "y": (-0.05, 0.05)},
        rotate=(-5, 5),  # rotate by -5 to +5 degrees
        shear=(-5, 5),  # shear by -5 to +5 degrees
        order=[0, 1],  # use nearest neighbour or bilinear interpolation (fast)
        cval=(0, 255),
        # use any of scikit-image's warping modes (see 2nd image from the top for examples)
        mode=imgaug.ALL
    ),
    iaa.SomeOf((0, 3), [
        # blur images with a sigma between 0 and 0.3
        iaa.GaussianBlur((0, 0.3)),
        # search either for all edges or for directed edges,
        # blend the result with the original image using a blobby mask
        iaa.SimplexNoiseAlpha(iaa.OneOf([
            iaa.EdgeDetect(alpha=(0.0, 0.3)),
            iaa.DirectedEdgeDetect(alpha=(0.0, 0.3), direction=(0.0, 1.0)),
        ])),
        # add gaussian noise to images
        iaa.AdditiveGaussianNoise(loc=0, scale=(
            0.0, 0.02*255), per_channel=0.5),
        # change brightness of images (by -10 to 10 of original value)
        iaa.Add((-5, 5), per_channel=0.5),
        iaa.AddToHueAndSaturation((-5, 5)),  # change hue and saturation
        # either change the brightness of the whole image (sometimes
        # per channel) or change the brightness of subareas
        iaa.Multiply((0.95, 1.05), per_channel=0.5),
        # improve or worsen the contrast
        iaa.ContrastNormalization((0.95, 1.05), per_channel=0.5),
        iaa.PerspectiveTransform(scale=(0.01, 0.05))
    ], random_order=True)
])

augmenter = seq.augment_image
