#!/bin/bash
set -e

JOB_NAME=bran
DOCKERFILE=""
RUNTIME=""
while getopts ":gl" o; do
    case "${o}" in
        g)
            RUNTIME="--runtime=nvidia"
            DOCKERFILE="-f Dockerfile.gpu"
            ;;
        l)
            JOB_NAME=bran_loadtest
            DOCKERFILE="-f Dockerfile.loadtest"
            ;;
    esac
done
shift $((OPTIND-1))

set -x

SSH_PRIVATE_KEY=${SSH_PRIVATE_KEY:-~/.ssh/id_rsa}
cp ${SSH_PRIVATE_KEY} ./ssh_private_key

BEBO_ENV=${BEBO_ENV:-local}
CONTAINER_HOSTNAME=$(hostname).${JOB_NAME}

docker rm -f ${JOB_NAME}:local || true

docker build -t ${JOB_NAME}:local --rm --build-arg BEBO_ENV=${BEBO_ENV} $DOCKERFILE .
rm ./ssh_private_key

docker run --rm -it \
    $RUNTIME \
    -e "GST_DEBUG_DUMP_DOT_DIR=/tmp/" \
    -e "GST_DEBUG=*:3" \
    -e "BEBO_ENV=${BEBO_ENV}" \
    --network="host" \
    --name ${JOB_NAME} \
    --hostname ${CONTAINER_HOSTNAME} \
    -v /data/dispatcher:/data/dispatcher \
    ${JOB_NAME}:local
