#!/bin/bash
set -e
set -x

FILENAME="${JOB_NAME}_${ENV}_${TAG}.tar.gz"

rm -rf package
mkdir -p package


rsync -av --progress . package --exclude-from=.jenkins_ignore
cp -R ./etc/${ENV}/supervisor package

cd package

../install.sh

tar czvf /data/build/${FILENAME} *

if [[ $LIVE == 'true' ]]; then
  /usr/local/bin/jenkins_uploader --project ${JOB_NAME} --env ${ENV} --tag ${TAG}
else
  /usr/local/bin/jenkins_uploader --project ${JOB_NAME} --env ${ENV} --tag ${TAG} --no-deploy
fi
