import sys
import warnings
import shutil

import tensorflow as tf
import onnx
from onnx_tf.backend import prepare

warnings.filterwarnings('ignore') # Ignore all the warning messages in this tutorial
model = onnx.load('out.onnx') # Load the ONNX file

x_in = list(filter(lambda i: i.name == 'input', model.graph.input))[0]
x_in.type.tensor_type.shape.dim[0].Clear()

tf_rep = prepare(model, strict=False) # Import the ONNX model to Tensorflow

export_path = "serving/{}".format(sys.argv[1])
shutil.rmtree(export_path, ignore_errors=True)

with tf.Session(graph=tf_rep.graph) as sess:
    inputs = {}
    outputs = {}
    for i in tf_rep.inputs:
        t = sess.graph.get_tensor_by_name(
            tf_rep.tensor_dict[i].name
        )
        tensor_info = tf.saved_model.utils.build_tensor_info(t)
        inputs[t.name.split(':')[0].lower()] = tensor_info
        print(
            'input tensor [name=%s, type=%s, shape=%s]'
            % (t.name, t.dtype.name, t.shape.as_list())
        )

    for i in tf_rep.outputs:
        t = sess.graph.get_tensor_by_name(
            tf_rep.tensor_dict[i].name
        )
        tensor_info = tf.saved_model.utils.build_tensor_info(t)
        outputs[t.name.split(':')[0]] = tensor_info
        print(
            'output tensor [name=%s, type=%s, shape=%s]'
            % (t.name, t.dtype.name, t.shape.as_list())
        )

    print('INPUTS')
    print(inputs)
    print('OUTPUTS')
    print(outputs)

    prediction_signature = (
        tf.saved_model.signature_def_utils.build_signature_def(
            inputs=inputs,
            outputs=outputs,
            method_name=tf.saved_model.signature_constants.PREDICT_METHOD_NAME)
    )
    builder = tf.saved_model.builder.SavedModelBuilder(export_path)
    builder.add_meta_graph_and_variables(
        sess, [tf.saved_model.tag_constants.SERVING],
        signature_def_map={
            tf.saved_model.signature_constants.DEFAULT_SERVING_SIGNATURE_DEF_KEY:
                prediction_signature
        })
    builder.save()
    print('Model saved to %s' % export_path)

