import argparse
import time
import logging

from bran.shared.config import config, get_config

from bran.train.mongo_dataset_creator import MongoDatasetCreator

parser = argparse.ArgumentParser(description="")
parser.add_argument("--dataset", required=True, help="Fortnite_kill|Fortnite_victory|Fortnite_gamestate")
parser.add_argument("--labels", nargs="+", required=True, help="space seperated list of labels")
parser.add_argument("--env", default="prod")

if __name__ == '__main__':
    args = parser.parse_args()
    print("args: {}".format(args))

    config.MONGO_DB = get_config(args.env).MONGO_DB

    creator = MongoDatasetCreator(dataset=args.dataset, labels=args.labels)
    creator.populate()
