import argparse
import json
import requests
import os
import tarfile
import boto3

from bran.train import get_best_weight_file
from bran.shared.config import get_config

def str2bool(v):
    if v.lower() in ('yes', 'true', 't', 'y', '1'):
        return True
    elif v.lower() in ('no', 'false', 'f', 'n', '0'):
        return False
    else:
        raise argparse.ArgumentTypeError('Boolean value expected.')

parser = argparse.ArgumentParser(description="Deploy a detector")
parser.add_argument("--name", required=True, action="store")
parser.add_argument("--job_id", required=True, action="store")
parser.add_argument("--env", required=True, action="store")
parser.add_argument("--live", type=str2bool, action="store", default=False)
parser.add_argument("--epoch", required=False, action="store")
parser.add_argument("--model_dir", default="/var/bran/gamesense/models", action="store")
args = parser.parse_args()

config = get_config(args.env)

model_dir = "{}/{}".format(args.model_dir, args.job_id)
bucket = "gamesense"

tar_name = "{}/{}.tar.gz".format(args.model_dir, args.name)

if args.epoch:
    model_file = os.path.join(model_dir, "epoch_{}.pt".format(args.epoch))
else:
    model_file = get_best_weight_file(model_dir)

print('Model: {}'.format(model_file))

with tarfile.open(tar_name, "w:gz") as tar:
    tar.add(model_file, arcname="weights.pt")

print("tarred file")
s3_name = "detectors/{}/{}.tar.gz".format(args.env, args.name)

s3 = boto3.client("s3")
s3.upload_file(tar_name, bucket, s3_name)
print("uploading file")

