import gi
gi.require_version("Gst", "1.0")
from gi.repository import Gst, GObject
Gst.init(None)
from threading import Thread, Lock
from bran.shared import logger as log
import os
import time

def make(name):
    return Gst.ElementFactory.make(name)

def make_capsfilter(caps_string):
    capsfilter = Gst.ElementFactory.make("capsfilter")
    caps = Gst.Caps.from_string(caps_string)
    capsfilter.set_property("caps", caps)
    return capsfilter

def add(els):
    for e in els:
        pipeline.add(e)

class MainLoopThread(Thread):
    def run(self):
        try:
            self.loop = GObject.MainLoop()
            self.loop.run()
        except KeyboardInterrupt:
            log.info("interrupt!!")
            self.loop.quit()
        
    def cleanup(self):
        self.loop.quit()

class TestPipeline:
    def __init__(self):
        self.eos = False
        self.pipeline = None

    def run(self, clip_url, stream_key):
        self.pipeline = Gst.parse_launch("curlhttpsrc location={} ! qtdemux ! flvmux streamable=true ! rtmpsink location=rtmp://127.0.0.1/gamesense/{}".format(clip_url, stream_key))
        self.bus = self.pipeline.get_bus()
        self.bus.add_signal_watch()
        self.bus.connect("message", self.on_message)
        self.main_loop_thread = MainLoopThread()
        self.main_loop_thread.start()
        self.pipeline.set_state(Gst.State.PLAYING)

        while not self.eos and self.main_loop_thread.is_alive():
            time.sleep(0.5)

    def on_message(self, bus, message):
        t = message.type
        if t == Gst.MessageType.EOS:
            self.eos = True

    def cleanup(self):
        if self.pipeline:
            self.pipeline.set_state(Gst.State.NULL)
            self.main_loop_thread.cleanup()
