# cell-emulation-util

A script based on Linux TC netem to emulate the latency, loss, and
bandwidth of a real-world cellular network.

## Update

Bitrate and RTT updated based on netinfo from brazil. The max seems to be capped at 10 MBit.

https://app.mode.com/twitch/reports/c3795915a72c/runs/9600f2023645

20/30 ms added to good & fair as netinfo shows 0 ms.

### Brazil - Wifi

```
good      p10     10 Mbit      20 ms RTT    2.45405% packet loss
fair      p25     10 Mbit      30 ms RTT    3.18609% packet loss
passable  p50    4.7 Mbit     100 ms RTT    3.97950% packet loss
poor      p75    1.6 Mbit     150 ms RTT    4.65212% packet loss
verypoor  p10   1.45 Mbit     200 ms RTT    5.15073% packet loss
```

### Brazil - cellular/mobile network
```
good      p10     10 Mbit      20 ms RTT    2.45405% packet loss
fair      p25    9.7 Mbit      30 ms RTT    3.18609% packet loss
passable  p50    2.7 Mbit     150 ms RTT    3.97950% packet loss
poor      p75   1.45 Mbit     200 ms RTT    4.65212% packet loss
verypoor  p10    0.4 Mbit     400 ms RTT    5.15073% packet loss
```

## Usage

In order to emulate a cellular network, run the script on a network
element connection client and server:

```sh
$ ./cellular_emulation.sh <type_of_simulation> <condition>
```

The possible values for `<type_of_simulation>` are `loss_based` and
`experience_based` and "mgst_brazil"

The possible condition values when `loss_based` are `good`, `median`,
and `poor`.

The possible condition values when `experience_based` are `noloss`,
`good`, `fair`, `passable`, `poor`, and `verypoor`.


So an example command would be:

```sh
$ ./cellular_emulation.sh loss_based good
```

## Background

This utility was created by Utkarsh Goel at Akamai during research for
a paper entitled "Making HTTP/2 Pages Load Faster in Lossy Cellular
Networks" authored by Utkarsh Goel, Moritz Steiner, Mike P. Wittie,
Martin Flack, and Stephen Ludin.
The
[manuscript is available](https://www.akamai.com/us/en/multimedia/documents/technical-publication/domain-sharding-for-faster-http2-in-lossy-cellular-networks.pdf);
also, [detailed instructions to setup this testbed are
available](https://developer.akamai.com/blog/2017/11/27/replaying-cellular-network-characteristics-cloud-infrastructure/).

(c) Copyright 2016 Akamai Technologies, Inc. Released under Apache
License Version 2.0.
