#!/bin/bash
# cellular_emulation.sh
# Copyright (c) 2016 Akamai Technologies, Inc. Released under Apache License Version 2.0.
# Copyright (c) 2019 Twitch Tv
# Version 0.2.1

# ETH1 is the uplink
ETH1=wlx7c8bca14189c 
# ETH2 is the hotspot
ETH2=wlp2s0

TC=tc

declare -a lat_array
declare -a thru_array
declare -a gap_array
declare -a loss_array

if [ "$1" == "loss_based" ]
then
	lat_array=(22 31 43 96 30 39 81 29 39 60 29 38 56 28 33 52 255 37 50 26 32 49 162 33 48 24 33 46 22 31 43 96 30 39 81 30 41 80 30 38 73 30 37 65 27 37 50 26 32 49 162 31 40 120 31 46 22 31 43 90 30 39 81 29 39 58 29 33 56 22 33 52 255 37 50 26 32 49 145.2 31 40 120 30 40 69 30 40 65 30 35 61 25 39 58 29 33 56 22 32 44 30 40 90 29 39 60 29 34 58 23 38 52 28 32 51 26 32 50 162 31 41 130 30 40 70 30 37 69 27 40 86 29 39 60 29 33 56 23 33 46 22 30 42 90 30 42 81 31 41 130 30 40 70 30 37 65 27 36 50 26 34 48 24 31 48 110 33 46 22 30 42 90 30 39 81 30 39 76 29 38 54 28 32 51 218 36 50 26 32 48 24 31 47 110 31 40 100 30 40 62)
	if [ "$2" == "good" ]
	then
		echo "Simulating good connections."
		thru_array=(2.196708 144.6429 2761.239 10062.17 97.91667 1241 8812.5 25.66964 1175 5581.25 24.55357 963.9509 5140.625 17.47946 430.5342 4700 14687.5 645.9866 4341.429 9.616815 289.2857 3854.554 12983.82 456.25 3525 4.249841 449.1071 3182.143 1.326141 144.6429 2761.239 10062.17 97.91667 1241 8812.5 75.26339 2133.25 8373.103 57.70089 963.9509 7637.5 46.98661 743.3571 6756.25 11.54018 645.9866 4341.429 7.507068 289.2857 3854.554 12983.82 228.2455 2048.314 11456.25 146.875 3182.143 1.326141 144.6429 2761.239 9693.75 97.91667 1241 8812.5 25.66964 1128.962 5322.545 23.26339 456.25 5140.625 2.196708 430.5342 4700 14687.5 645.9866 4341.429 7.507068 289.2857 3854.554 12585.87 203.2366 2048.314 11456.25 53.73661 1762.5 7050 30.02232 1468.75 6756.25 28.125 578.5714 6168.75 5.771652 1128.962 5322.545 23.26339 449.1071 5140.625 2.196708 353.1 2937.5 97.91667 1446.429 9693.75 25.66964 1175 5875 24.55357 467.808 5322.545 3.152311 867.8571 4700 13.95089 293.75 4531.473 9.616815 289.2857 4112.5 12983.82 228.2455 2133.25 12022.88 53.73661 1865.772 7343.75 46.98661 743.3571 7050 11.54018 1446.429 9253.125 25.66964 1175 5875 24.55357 456.25 5140.625 3.152311 430.5342 3182.143 1.326141 118.5268 2603.571 9693.75 92.57812 2365.379 8812.5 228.2455 2133.25 12022.88 53.73661 1762.5 7343.75 46.98661 743.3571 6756.25 11.54018 587.5 4341.429 7.507068 533.9777 3724.272 4.249841 203.2366 3525 10964.03 430.5342 3182.143 1.326141 118.5268 2603.571 9693.75 92.57812 1175 8812.5 65.06696 1128.962 8000.893 23.26339 881.25 4917.857 13.95089 353.1 4531.473 14100 587.5 4112.5 7.507068 267.6339 3724.272 4.249841 203.2366 3300.888 10964.03 146.875 1762.5 10575 38.11533 1468.75 6462.5)
		gap_array=(0.07 0.63 1.54 3.36 0.56 1.19 2.94 0.315 1.19 2.1 0.28 1.12 2.03 0.21 0.91 1.96 5.425 1.05 1.855 0.175 0.77 1.785 4.2 0.98 1.68 0.07 0.98 1.61 0.07 0.63 1.54 3.36 0.56 1.19 2.94 0.49 1.4 2.8 0.455 1.12 2.59 0.42 1.085 2.38 0.175 1.05 1.855 0.14 0.77 1.785 4.2 0.735 1.365 3.885 0.63 1.61 0.07 0.63 1.54 3.22 0.56 1.19 2.94 0.315 1.155 2.065 0.28 0.98 2.03 0.07 0.91 1.96 5.425 1.05 1.855 0.14 0.77 1.785 4.06 0.7 1.365 3.885 0.455 1.295 2.45 0.35 1.26 2.38 0.35 1.05 2.24 0.14 1.155 2.065 0.28 0.98 2.03 0.07 0.91 1.575 0.56 1.225 3.22 0.315 1.19 2.17 0.28 1.015 2.065 0.07 1.085 1.96 0.21 0.84 1.925 0.175 0.77 1.82 4.2 0.735 1.4 3.99 0.455 1.33 2.52 0.42 1.085 2.45 0.175 1.225 3.045 0.315 1.19 2.17 0.28 0.98 2.03 0.07 0.91 1.61 0.07 0.595 1.505 3.22 0.525 1.47 2.94 0.735 1.4 3.99 0.455 1.295 2.52 0.42 1.085 2.38 0.175 1.05 1.855 0.14 1.015 1.75 0.07 0.7 1.68 3.71 0.91 1.61 0.07 0.595 1.505 3.22 0.525 1.19 2.94 0.49 1.155 2.73 0.28 1.12 2.0196 0.21 0.91 1.925 4.795 1.05 1.82 0.14 0.77 1.75 0.07 0.7 1.645 3.71 0.63 1.295 3.5 0.385 1.26 2.31)
		loss_array=(0.703122 7.1429 50 60 5.8824 33.3333 50 2.5641 33.3333 50 2.381 26.6667 50 1.8519 14.2857 50 75 25 50 1.4085 11.1111 50 66.6667 16.6667 50 0.9174 16.6667 50 0.5556 7.1429 50 60 5.8824 33.3333 50 5.2632 50 50 4.5455 26.6667 50 3.8462 25 50 1.5385 25 50 1.2821 11.1111 50 66.6667 9.0909 50 66.6667 7.6923 50 0.5556 7.1429 50 50 5.8824 33.3333 50 2.5641 33.3333 50 2.2222 16.6667 50 0.703122 14.2857 50 75 25 50 1.2821 11.1111 50 66.6667 8.928868 50 66.6667 4.1667 40 50 3.3333 33.3333 50 3.0303 20 50 1.14082 33.3333 50 2.2222 16.6667 50 0.703122 14.2857 50 5.8824 33.3333 50 2.5641 33.3333 50 2.381 16.6667 50 0.817489 25 50 1.6949 12.5 50 1.4085 11.1111 50 66.6667 9.0909 50 66.6667 4.1667 50 50 3.8462 25 50 1.5385 33.3333 50 2.5641 33.3333 50 2.381 16.6667 50 0.817489 14.2857 50 0.5556 6.6667 50 50 5.5556 50 50 9.0909 50 66.6667 4.1667 40 50 3.8462 25 50 1.5385 20 50 1.2821 20 50 0.9174 8.928868 50 66.6667 14.2857 50 0.5556 6.6667 50 50 5.5556 33.3333 50 4.7619 33.3333 50 2.2222 25 50 1.6949 14.2857 50 71.4286 20 50 1.2821 10 50 0.9174 8.928868 50 66.6667 7.6923 40 66.6667 3.5714 33.3333 50)
	elif [ "$2" == "median" ]
	then
		echo "Simulating median connections/"
		thru_array=(2.845982 35.27679 850.6384 6462.5 28.34821 451.2277 5207.143 20.42411 447.9911 2643.75 19.19643 381.4326 2262.528 13.14935 137.686 1912.277 13885.71 289.2857 1664.583 8.441369 68.10789 1439.696 10575 146.875 1157.143 5.691964 144.6429 937.9353 1.646205 35.27679 850.6384 6462.5 28.34821 451.2277 5207.143 26.11607 578.5714 4865.147 25.22321 381.4326 4476.594 23.4375 289.2857 3633.594 10.41425 289.2857 1664.583 6.609747 68.10789 1439.696 10575 57.70089 482.1429 8225 36.71875 937.9353 1.646205 35.27679 850.6384 5962.277 28.34821 451.2277 5207.143 20.42411 432.7009 2371.366 17.52232 146.875 2262.528 2.845982 137.686 1912.277 13885.71 289.2857 1664.583 6.609747 68.10789 1439.696 9693.75 48.95833 482.1429 8225 24.24107 459.933 3910.737 21.65179 457.1429 3633.594 21.65179 225.8929 3096.558 5.691964 432.7009 2371.366 17.52232 144.6429 2262.528 2.845982 108.4821 867.8571 28.34821 453.9062 5962.277 20.42411 447.9911 2892.857 19.19643 183.2589 2371.366 4.347098 293.75 1912.277 11.91406 95.53571 1762.5 8.441369 68.10789 1468.75 10575 57.70089 578.5714 8874.777 24.24107 465.8482 4209.821 23.4375 289.2857 3910.737 10.41425 453.9062 5581.25 20.42411 447.9911 2892.857 19.19643 146.875 2262.528 4.347098 137.686 937.9353 1.646205 29.375 733.1122 5962.277 27.23214 593.1518 5207.143 57.70089 578.5714 8874.777 24.24107 459.933 4209.821 23.4375 289.2857 3633.594 10.41425 246.3393 1664.583 6.609747 195.8333 1227.567 5.691964 48.95833 1157.143 7591.853 137.686 937.9353 1.646205 29.375 733.1122 5962.277 27.23214 447.9911 5207.143 25.22321 432.7009 4553.125 17.52232 293.75 2056.25 11.91406 108.4821 1762.5 12631.25 246.3393 1468.75 6.609747 57.70089 1227.567 5.691964 48.95833 1095.411 7591.853 36.71875 459.933 7050 22.76786 457.1429 3358.705)
		gap_array=(0.07 0.245 0.49 0.98 0.21 0.385 0.91 0.14 0.375 0.63 0.105 0.35 0.595 0.07 0.28 0.56 3.5 0.35 0.56 0.07 0.28 0.525 1.89 0.315 0.49 0.07 0.29 0.49 0.07 0.245 0.49 0.98 0.21 0.385 0.91 0.21 0.42 0.84 0.21 0.35 0.805 0.175 0.35 0.7 0.07 0.35 0.56 0.07 0.28 0.525 1.89 0.28 0.42 1.19 0.28 0.49 0.07 0.245 0.49 0.945 0.21 0.385 0.91 0.14 0.35 0.63 0.07 0.315 0.595 0.07 0.28 0.56 3.5 0.35 0.56 0.07 0.28 0.525 1.61 0.28 0.42 1.19 0.175 0.42 0.735 0.14 0.385 0.7 0.14 0.315 0.665 0.07 0.35 0.63 0.07 0.29 0.595 0.07 0.28 0.49 0.21 0.385 0.945 0.14 0.375 0.64 0.105 0.315 0.63 0.07 0.35 0.56 0.07 0.28 0.56 0.07 0.28 0.525 1.89 0.28 0.42 1.4 0.175 0.42 0.77 0.175 0.35 0.735 0.07 0.385 0.91 0.14 0.375 0.64 0.105 0.315 0.595 0.07 0.28 0.49 0.07 0.21 0.455 0.945 0.21 0.455 0.91 0.28 0.42 1.4 0.175 0.42 0.77 0.175 0.35 0.7 0.07 0.315 0.56 0.07 0.315 0.49 0.07 0.28 0.49 1.05 0.28 0.49 0.07 0.21 0.455 0.945 0.21 0.375 0.91 0.21 0.35 0.84 0.07 0.35 0.572 0.07 0.28 0.56 2.59 0.315 0.525 0.07 0.28 0.49 0.07 0.28 0.49 1.05 0.28 0.42 0.98 0.14 0.385 0.7)
		loss_array=(0.9434 16.6667 50 66.6667 14.2857 50 66.6667 4.7619 50 60 4.3478 44.23392 55.5556 3.125 25 50 80 33.3333 50 2.2727 25 50 75 28.5714 50 1.3514 27.2727 50 0.7042 16.6667 50 66.6667 14.2857 50 66.6667 11.7647 50 66.6667 10 44.23392 66.6667 7.6923 33.3333 66.6667 2.5 33.3333 50 2.0408 25 50 75 20 50 66.6667 16.6667 50 0.7042 16.6667 50 66.6667 14.2857 50 66.6667 4.7619 50 57.1429 4 28.5714 55.5556 0.9434 25 50 80 33.3333 50 2.0408 25 50 71.4286 20 50 66.6667 9.0909 50 66.6667 6.6667 50 66.6667 5.8824 33.3333 62.5 1.8182 50 57.1429 4 27.2727 55.5556 0.9434 25 50 14.2857 50 66.6667 4.7619 50 60 4.3478 33.3333 57.1429 1.1364 33.3333 50 2.8571 25 50 2.2727 25 50 75 20 50 66.6667 9.0909 50 66.6667 7.6923 33.3333 66.6667 2.5 50 66.6667 4.7619 50 60 4.3478 28.5714 55.5556 1.1364 25 50 0.7042 16.6667 50 66.6667 12.5 50 66.6667 20 50 66.6667 9.0909 50 66.6667 7.6923 33.3333 66.6667 2.5 33.3333 50 2.0408 33.3333 50 1.3514 20 50 66.6667 25 50 0.7042 16.6667 50 66.6667 12.5 50 66.6667 11.1111 50 66.6667 4 40 50 2.8571 25 50 75 33.3333 50 2.0408 25 50 1.3514 20 50 66.6667 16.6667 50 66.6667 7.1429 50 66.6667)
	elif [ "$2" == "poor" ]
	then
		echo "Simulating poor connections."
		thru_array=(5.691964 27.90179 578.5714 4700 25.22321 289.2857 4506.25 22.76786 282.1429 2669.509 22.76786 227.0614 2284.263 20.42411 69.67411 1784.426 11456.25 146.875 1473.757 19.19643 46.20815 1175 7189.192 89.12946 945.5279 6.708147 73.4375 734.7768 2.846354 27.90179 578.5714 4700 25.22321 289.2857 4506.25 25.22321 457.4777 4506.25 25.22321 227.0614 4426.844 25.22321 146.875 3762.298 20.42411 146.875 1473.757 15.625 46.20815 1175 7189.192 37.26786 456.3616 5399.33 28.92857 734.7768 2.846354 27.90179 578.5714 4521.875 25.22321 289.2857 4506.25 22.76786 256.5848 2490.848 22.76786 89.12946 2284.263 5.691964 69.67411 1784.426 11456.25 146.875 1473.757 15.625 46.20815 1175 6462.5 36.16071 456.3616 5399.33 25.22321 449.3571 4040.402 23.32589 310.2165 3762.298 22.76786 120.8884 3229.397 12.98363 256.5848 2490.848 22.76786 73.4375 2284.263 5.691964 58.75 587.5 25.22321 293.75 4521.875 22.76786 282.1429 2937.5 22.76786 96.42857 2490.848 5.691964 153.311 1784.426 20.42411 57.70089 1726.116 19.19643 46.20815 1419.688 7189.192 37.26786 457.4777 5932.254 25.22321 453.9062 4235.045 25.22321 146.875 4040.402 20.42411 293.75 4515.848 22.76786 282.1429 2937.5 22.76786 89.12946 2284.263 5.691964 69.67411 734.7768 2.846354 26.89732 526.7857 4521.875 25.22321 477.6786 4506.25 37.26786 457.4777 5932.254 25.22321 449.3571 4235.045 25.22321 146.875 3762.298 20.42411 144.6429 1473.757 15.625 97.91667 1150 6.708147 36.16071 945.5279 5094.42 69.67411 734.7768 2.846354 26.89732 526.7857 4521.875 25.22321 282.1429 4506.25 25.22321 256.5848 4488.281 22.76786 189.8438 2025.393 20.42411 58.75 1726.116 9400 144.6429 1419.688 15.625 43.19196 1150 6.708147 36.16071 867.8571 5094.42 28.92857 449.3571 4936.779 24.10714 310.2165 3517.455)
		gap_array=(0.07 0.07 0.21 0.42 0.07 0.175 0.35 0.07 0.17 0.245 0.07 0.155 0.245 0.07 0.14 0.245 2.31 0.14 0.245 0.07 0.105 0.215 0.77 0.14 0.21 0.07 0.14 0.21 0.07 0.07 0.21 0.42 0.07 0.175 0.35 0.07 0.21 0.35 0.07 0.155 0.35 0.07 0.14 0.28 0.07 0.14 0.245 0.07 0.105 0.215 0.77 0.07 0.175 0.49 0.07 0.21 0.07 0.07 0.21 0.42 0.07 0.175 0.35 0.07 0.165 0.245 0.07 0.14 0.245 0.07 0.14 0.245 2.31 0.14 0.245 0.07 0.105 0.215 0.63 0.07 0.175 0.49 0.07 0.175 0.28 0.07 0.175 0.28 0.07 0.14 0.28 0.07 0.165 0.245 0.07 0.14 0.245 0.07 0.14 0.21 0.07 0.175 0.42 0.07 0.17 0.28 0.07 0.14 0.245 0.07 0.14 0.245 0.07 0.105 0.245 0.07 0.105 0.235 0.77 0.07 0.21 0.56 0.07 0.175 0.28 0.07 0.14 0.28 0.07 0.175 0.385 0.07 0.17 0.28 0.07 0.14 0.245 0.07 0.14 0.21 0.07 0.07 0.21 0.42 0.07 0.21 0.35 0.07 0.21 0.56 0.07 0.175 0.28 0.07 0.14 0.28 0.07 0.14 0.245 0.07 0.14 0.21 0.07 0.07 0.21 0.49 0.14 0.21 0.07 0.07 0.21 0.42 0.07 0.17 0.35 0.07 0.165 0.35 0.07 0.14 0.245 0.07 0.14 0.245 1.4 0.14 0.235 0.07 0.105 0.21 0.07 0.07 0.21 0.49 0.07 0.175 0.455 0.07 0.175 0.28)
		loss_array=(0.9901 15.6863 50 75 12.5 50 71.4286 2.9412 50 66.6667 2.5 50 66.6667 1.9608 33.3333 66.6667 88.8889 42.8571 66.6667 1.5873 25 60 83.3333 33.3333 60 1.2048 33.3333 57.1429 0.8403 15.6863 50 75 12.5 50 71.4286 9.0909 50 66.6667 7.1429 50 66.6667 5.5556 46.1538 66.6667 1.6949 42.8571 66.6667 1.4925 25 60 83.3333 20 50 80 16.6667 57.1429 0.8403 15.6863 50 75 12.5 50 71.4286 2.9412 50 66.6667 2.2727 33.3333 66.6667 0.9901 33.3333 66.6667 88.8889 42.8571 66.6667 1.4925 25 60 83.3333 20 50 80 6.25 50 66.6667 4.3478 50 66.6667 3.8462 36.3636 66.6667 1.4286 50 66.6667 2.2727 33.3333 66.6667 0.9901 28.5714 53.8462 12.5 50 75 2.9412 50 66.6667 2.5 33.3333 66.6667 1.1111 50 66.6667 1.80195 25 66.6667 1.5873 25 62.5 83.3333 20 50 83.3333 6.25 50 66.6667 5.5556 46.1538 66.6667 1.6949 50 71.4286 2.9412 50 66.6667 2.5 33.3333 66.6667 1.1111 33.3333 57.1429 0.8403 14.2857 50 75 11.1111 50 71.4286 20 50 83.3333 6.25 50 66.6667 5.5556 46.1538 66.6667 1.6949 40 66.6667 1.4925 33.3333 60 1.2048 20 60 77.7778 33.3333 57.1429 0.8403 14.2857 50 75 11.1111 50 71.4286 8.3333 50 66.6667 2.2727 50 66.6667 1.80195 28.5714 66.6667 83.97435 40 62.5 1.4925 22.2222 60 1.2048 20 57.1429 77.7778 16.6667 50 75 4.9695 50 66.6667)
	else
		echo "Please select a valid network condition to simulate. Valid values are good, median, and poor."
		exit 1
	fi
elif [ "$1" == "experience_based" ]
then
	if [ "$2" == "noloss" ]
	then
		echo "Simulating no loss experiences."
		lat_array=(20.56 30.7592 43.9624 153.344 30.16 39.4964 118.9918 25.533 39.42 68.1714 25.2544 39.22 61.515 24.4012 35.4 59.082 672.2598 38.109 54.6944 23.4624 33.7564 51.2916 351.5868 36.148 49.0964 21.3584 35.7596 45.49 20.2346 30.7592 43.9624 153.344 30.16 39.4964 118.9918 29.5268 40.2752 108.1076 28.5304 39.22 89.0132 27.326 38.7588 77.8762 23.88 38.109 54.6944 22.96 33.7564 51.2916 351.5868 32.8068 40 235.9766 31.1934 45.49 20.2346 30.7592 43.9624 139.6554 30.16 39.4964 118.9918 25.533 39.34 65.18 24.9466 36.148 61.515 20.56 35.4 59.082 672.2598 38.109 54.6944 22.96 33.7564 51.2916 310.28 32.1326 40 235.9766 27.8244 39.8692 80.616 26.36 39.7 77.8762 26.01 37.3326 71.1716 22.3952 39.34 65.18 24.9466 35.7596 61.515 20.56 35.1168 44.6748 30.16 39.6 139.6554 25.533 39.42 69.6688 25.2544 36.5462 65.18 21.0192 39.0454 59.082 24.16 34.82 56.9152 23.4624 33.7564 52.706 351.5868 32.8068 40.2752 279.092 27.8244 39.93 84.1918 27.326 38.7588 80.616 23.88 39.6 127.6508 25.533 39.42 69.6688 25.2544 36.148 61.515 21.0192 35.4 45.49 20.2346 30.3814 42.3784 139.6554 29.835 41.3906 118.9918 32.8068 40.2752 279.092 27.8244 39.8692 84.1918 27.326 38.7588 77.8762 23.88 37.7232 54.6944 22.96 36.88 49.7652 21.3584 32.1326 49.0964 199.9244 35.4 45.49 20.2346 30.3814 42.3784 139.6554 29.835 39.42 118.9918 29.03 39.34 95.423 24.9466 39.14 60.2036 24.16 35.1168 56.9152 529.9752 37.7232 52.706 22.96 33.3324 49.7652 21.3584 32.1326 46.976 199.9244 31.1934 39.8692 177.2254 26.8 39.7 74.108)
		thru_array=(395.221 6554.214 7461.344 8323.839 6429.107 7232.143 8202.533 4589.431 7221.044 7804.938 4502.281 7119.916 7608.482 4311.079 6756.25 7521.429 9828.482 6942.857 7521.429 4080.344 6667 7499.558 9306.643 6756.25 7490.625 1855.857 6756.25 7484.414 205.3672 6554.214 7461.344 8323.839 6429.107 7232.143 8202.533 6333 7398.513 8174.621 6172.661 7119.916 8125.045 6093.75 6942.857 7985.732 4147.655 6942.857 7521.429 3851.882 6667 7499.558 9306.643 6655.286 7385.275 8501.585 6632.554 7484.414 205.3672 6554.214 7461.344 8278.813 6429.107 7232.143 8202.533 4589.431 7170.48 7684.5 4456.248 6756.25 7608.482 395.221 6756.25 7521.429 9828.482 6942.857 7521.429 3851.882 6667 7499.558 9209.933 6653.571 7385.275 8501.585 6132.188 7339.286 8045.036 5357.571 7247.768 7985.732 4906.266 6873.812 7940.652 3276.326 7170.48 7684.5 4456.248 6756.25 7608.482 395.221 6756.25 7477.138 6429.107 7232.143 8278.813 4589.431 7221.044 7925.375 4502.281 6756.25 7684.5 973.5335 6987.666 7521.429 4220.614 6735.036 7521.429 4080.344 6667 7512.187 9306.643 6655.286 7398.513 8855.759 6132.188 7363.448 8101.708 6093.75 6942.857 8045.036 4147.655 7232.143 8233.786 4589.431 7221.044 7925.375 4502.281 6756.25 7608.482 973.5335 6756.25 7484.414 205.3672 6475.875 7433.522 8278.813 6388.839 7405.701 8202.533 6655.286 7398.513 8855.759 6132.188 7339.286 8101.708 6093.75 6942.857 7985.732 4147.655 6942.857 7521.429 3851.882 6797.304 7490.625 1855.857 6653.571 7490.625 8374.036 6756.25 7484.414 205.3672 6475.875 7433.522 8278.813 6388.839 7221.044 8202.533 6252.83 7170.48 8148.382 4456.248 7055.71 7560.893 4220.614 6756.25 7521.429 9531.964 6942.857 7512.187 3851.882 6661.143 7490.625 1855.857 6653.571 7490.625 8374.036 6632.554 7339.286 8351.705 5832 7247.768 7950.536)
		gap_array=(99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999)
		loss_array=(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 )
	elif [ "$2" == "good" ]
	then
		echo "Simulating good experiences."
		lat_array=(20.56 30.7592 43.9624 153.344 30.16 39.4964 118.9918 25.533 39.42 68.1714 25.2544 39.22 61.515 24.4012 35.4 59.082 672.2598 38.109 54.6944 23.4624 33.7564 51.2916 351.5868 36.148 49.0964 21.3584 35.7596 45.49 20.2346 30.7592 43.9624 153.344 30.16 39.4964 118.9918 29.5268 40.2752 108.1076 28.5304 39.22 89.0132 27.326 38.7588 77.8762 23.88 38.109 54.6944 22.96 33.7564 51.2916 351.5868 32.8068 40 235.9766 31.1934 45.49 20.2346 30.7592 43.9624 139.6554 30.16 39.4964 118.9918 25.533 39.34 65.18 24.9466 36.148 61.515 20.56 35.4 59.082 672.2598 38.109 54.6944 22.96 33.7564 51.2916 310.28 32.1326 40 235.9766 27.8244 39.8692 80.616 26.36 39.7 77.8762 26.01 37.3326 71.1716 22.3952 39.34 65.18 24.9466 35.7596 61.515 20.56 35.1168 44.6748 30.16 39.6 139.6554 25.533 39.42 69.6688 25.2544 36.5462 65.18 21.0192 39.0454 59.082 24.16 34.82 56.9152 23.4624 33.7564 52.706 351.5868 32.8068 40.2752 279.092 27.8244 39.93 84.1918 27.326 38.7588 80.616 23.88 39.6 127.6508 25.533 39.42 69.6688 25.2544 36.148 61.515 21.0192 35.4 45.49 20.2346 30.3814 42.3784 139.6554 29.835 41.3906 118.9918 32.8068 40.2752 279.092 27.8244 39.8692 84.1918 27.326 38.7588 77.8762 23.88 37.7232 54.6944 22.96 36.88 49.7652 21.3584 32.1326 49.0964 199.9244 35.4 45.49 20.2346 30.3814 42.3784 139.6554 29.835 39.42 118.9918 29.03 39.34 95.423 24.9466 39.14 60.2036 24.16 35.1168 56.9152 529.9752 37.7232 52.706 22.96 33.3324 49.7652 21.3584 32.1326 46.976 199.9244 31.1934 39.8692 177.2254 26.8 39.7 74.108)
		thru_array=(395.221 6554.214 7461.344 8323.839 6429.107 7232.143 8202.533 4589.431 7221.044 7804.938 4502.281 7119.916 7608.482 4311.079 6756.25 7521.429 9828.482 6942.857 7521.429 4080.344 6667 7499.558 9306.643 6756.25 7490.625 1855.857 6756.25 7484.414 205.3672 6554.214 7461.344 8323.839 6429.107 7232.143 8202.533 6333 7398.513 8174.621 6172.661 7119.916 8125.045 6093.75 6942.857 7985.732 4147.655 6942.857 7521.429 3851.882 6667 7499.558 9306.643 6655.286 7385.275 8501.585 6632.554 7484.414 205.3672 6554.214 7461.344 8278.813 6429.107 7232.143 8202.533 4589.431 7170.48 7684.5 4456.248 6756.25 7608.482 395.221 6756.25 7521.429 9828.482 6942.857 7521.429 3851.882 6667 7499.558 9209.933 6653.571 7385.275 8501.585 6132.188 7339.286 8045.036 5357.571 7247.768 7985.732 4906.266 6873.812 7940.652 3276.326 7170.48 7684.5 4456.248 6756.25 7608.482 395.221 6756.25 7477.138 6429.107 7232.143 8278.813 4589.431 7221.044 7925.375 4502.281 6756.25 7684.5 973.5335 6987.666 7521.429 4220.614 6735.036 7521.429 4080.344 6667 7512.187 9306.643 6655.286 7398.513 8855.759 6132.188 7363.448 8101.708 6093.75 6942.857 8045.036 4147.655 7232.143 8233.786 4589.431 7221.044 7925.375 4502.281 6756.25 7608.482 973.5335 6756.25 7484.414 205.3672 6475.875 7433.522 8278.813 6388.839 7405.701 8202.533 6655.286 7398.513 8855.759 6132.188 7339.286 8101.708 6093.75 6942.857 7985.732 4147.655 6942.857 7521.429 3851.882 6797.304 7490.625 1855.857 6653.571 7490.625 8374.036 6756.25 7484.414 205.3672 6475.875 7433.522 8278.813 6388.839 7221.044 8202.533 6252.83 7170.48 8148.382 4456.248 7055.71 7560.893 4220.614 6756.25 7521.429 9531.964 6942.857 7512.187 3851.882 6661.143 7490.625 1855.857 6653.571 7490.625 8374.036 6632.554 7339.286 8351.705 5832 7247.768 7950.536)
		gap_array=(0.14 0.28 0.63 2.52 0.28 0.49 2.03 0.21 0.48 1.05 0.21 0.42 0.98 0.21 0.35 0.91 6.9167 0.42 0.8043 0.14 0.35 0.77 4.13 0.35 0.7 0.14 0.35 0.63 0.07 0.28 0.63 2.52 0.28 0.49 2.03 0.28 0.56 1.89 0.28 0.42 1.75 0.26 0.42 1.3573 0.21 0.42 0.8043 0.14 0.35 0.77 4.13 0.28 0.56 3.22 0.28 0.63 0.07 0.28 0.63 2.38 0.28 0.49 2.03 0.21 0.42 1.05 0.21 0.35 0.98 0.14 0.35 0.91 6.9167 0.42 0.8043 0.14 0.35 0.77 3.99 0.28 0.56 3.22 0.28 0.49 1.47 0.21 0.49 1.3573 0.21 0.42 1.19 0.14 0.42 1.05 0.21 0.35 0.98 0.14 0.35 0.63 0.28 0.49 2.38 0.21 0.48 1.12 0.21 0.35 1.05 0.14 0.42 0.91 0.21 0.35 0.84 0.14 0.35 0.77 4.13 0.28 0.56 3.5602 0.28 0.56 1.61 0.26 0.42 1.47 0.21 0.49 2.17 0.21 0.48 1.12 0.21 0.35 0.98 0.14 0.35 0.63 0.07 0.28 0.63 2.38 0.28 0.56 2.03 0.28 0.56 3.5602 0.28 0.49 1.61 0.26 0.42 1.3573 0.21 0.42 0.8043 0.14 0.35 0.7 0.14 0.28 0.7 2.94 0.35 0.63 0.07 0.28 0.63 2.38 0.28 0.48 2.03 0.28 0.42 1.82 0.21 0.42 0.91 0.21 0.35 0.84 5.46 0.42 0.77 0.14 0.35 0.7 0.14 0.28 0.7 2.94 0.28 0.49 2.73 0.21 0.49 1.26)
		loss_array=(2.838572 16.6667 33.3333 50 16.6667 33.3333 50 9.0909 33.3333 50 9.0909 33.3333 50 7.1429 21.89471 50 73.42858 25 50 5.8824 20 50 66.6667 25 40 3.780248 25 37.5 1.7241 16.6667 33.3333 50 16.6667 33.3333 50 14.2857 33.3333 50 14.2857 33.3333 50 12.5 25 50 6.25 25 50 5.2632 20 50 66.6667 20 33.3333 50 16.6667 37.5 1.7241 16.6667 33.3333 50 16.6667 33.3333 50 9.0909 33.3333 50 8.878772 25 50 2.838572 21.89471 50 73.42858 25 50 5.2632 20 50 59.8919 20 33.3333 50 12.5 33.3333 50 11.1111 33.3333 50 11.1111 25 50 5 33.3333 50 8.878772 25 50 2.838572 20 33.3333 16.6667 33.3333 50 9.0909 33.3333 50 9.0909 25 50 3.3701 26.55441 50 6.6667 20 50 5.8824 20 50 66.6667 20 33.3333 50 12.5 33.3333 50 12.5 25 50 6.25 33.3333 50 9.0909 33.3333 50 9.0909 25 50 3.3701 21.89471 37.5 1.7241 16.6667 33.3333 50 14.2857 33.3333 50 20 33.3333 50 12.5 33.3333 50 12.5 25 50 6.25 25 50 5.2632 25 45.24671 3.780248 20 40 50 21.89471 37.5 1.7241 16.6667 33.3333 50 14.2857 33.3333 50 14.2857 33.3333 50 8.878772 30 50 6.6667 20 50 66.6667 25 50 5.2632 20 45.24671 3.780248 20 40 50 16.6667 33.3333 50 11.1111 33.3333 50)
	elif [ "$2" == "fair" ]
	then
		echo "Simulating fair experiences."
		lat_array=(24.5532 39.64 68.1866 248.802 39.4232 57.3712 180.0614 35.513 56.1282 92.7914 35.23 54.1672 86.805 33.7704 43.3392 81.9986 704.6982 49.559 78.4564 31.3656 40.7452 75.0716 449.7536 44.99 71.5382 27.354 44.2998 69.682 22.6184 39.64 68.1866 248.802 39.4232 57.3712 180.0614 39.2568 63.9138 160.3852 39.0204 54.1672 140.0204 37.89 50.3144 118.9692 32.1504 49.559 78.4564 30.3974 40.7452 75.0716 449.7536 40.0324 62.9956 326.6704 39.7278 69.682 22.6184 39.64 68.1866 220.3746 39.4232 57.3712 180.0614 35.513 55.12 89.4212 34.93 44.99 86.805 24.5532 43.3392 81.9986 704.6982 49.559 78.4564 30.3974 40.7452 75.0716 410.303 39.9342 62.9956 326.6704 38.5288 60.7084 123.4372 36.87 59.208 118.9692 36.5388 47.6 102.874 29.8128 55.12 89.4212 34.93 44.2998 86.805 24.5532 42.43 68.7744 39.4232 58.5176 220.3746 35.513 56.1282 97.502 35.23 45.711 89.4212 25.9576 51.877 81.9986 33.024 41.6956 80.0712 31.3656 40.7452 77.7 449.7536 40.0324 63.9138 363.8056 38.5288 61.7 130.611 37.89 50.3144 123.4372 32.1504 58.5176 198.55 35.513 56.1282 97.502 35.23 44.99 86.805 25.9576 43.3392 69.682 22.6184 39.54 67.1804 220.3746 39.35 65.95 180.0614 40.0324 63.9138 363.8056 38.5288 60.7084 130.611 37.89 50.3144 118.9692 32.1504 48.7008 78.4564 30.3974 46.46 73.6604 27.354 39.9342 71.5382 303.9104 43.3392 69.682 22.6184 39.54 67.1804 220.3746 39.35 56.1282 180.0614 39.12 55.12 149.876 34.93 52.9276 84.3612 33.024 42.43 80.0712 624.2464 48.7008 77.7 30.3974 40.3524 73.6604 27.354 39.9342 70.33 303.9104 39.7278 60.7084 280.336 37.3816 59.208 110.692)
		thru_array=(391.7165 2622.857 3513.047 4316.049 2603.571 3197.857 4088.136 1887.98 3172.962 3818.75 1732.022 3089.315 3817.857 1334.866 2892.857 3811.593 5427.866 2912.946 3769.586 1174.393 2669.138 3761.653 4882.571 2892.857 3635.786 493.8929 2892.857 3525 195.9141 2622.857 3513.047 4316.049 2603.571 3197.857 4088.136 2583.571 3384.717 4064.799 2481.071 3089.315 4050 2347.143 2931.25 4038.538 1199.652 2912.946 3769.586 1072.106 2669.138 3761.653 4882.571 2646.991 3338.152 4386.179 2639.33 3525 195.9141 2622.857 3513.047 4220.779 2603.571 3197.857 4088.136 1887.98 3131.138 3818.75 1573.788 2892.857 3817.857 391.7165 2892.857 3811.593 5427.866 2912.946 3769.586 1072.106 2669.138 3761.653 4681.964 2643.75 3338.152 4386.179 2414.5 3231.25 4044.487 2245.366 3231.25 4038.538 2192.002 2892.857 3903.279 803.9129 3131.138 3818.75 1573.788 2892.857 3817.857 391.7165 2892.857 3525 2603.571 3217.991 4220.779 1887.98 3172.962 3818.75 1732.022 2892.857 3818.75 483.5056 2976.011 3811.593 1241.518 2839.554 3790.589 1174.393 2669.138 3762.98 4882.571 2646.991 3384.717 4534.071 2414.5 3281.96 4050 2347.143 2931.25 4044.487 1199.652 3217.991 4125.509 1887.98 3172.962 3818.75 1732.022 2892.857 3817.857 483.5056 2892.857 3525 195.9141 2606.384 3484.219 4220.779 2603.571 3455.391 4088.136 2646.991 3384.717 4534.071 2414.5 3231.25 4050 2347.143 2931.25 4038.538 1199.652 2894.643 3769.586 1072.106 2892.857 3732.429 493.8929 2643.75 3635.786 4339.286 2892.857 3525 195.9141 2606.384 3484.219 4220.779 2603.571 3172.962 4088.136 2532.321 3131.138 4050 1573.788 3034.491 3816.393 1241.518 2892.857 3790.589 5274.482 2894.643 3762.98 1072.106 2658.065 3732.429 493.8929 2643.75 3539.143 4339.286 2639.33 3231.25 4339.286 2290.942 3231.25 3992.143)
		gap_array=(0.14 0.28 0.56 2.24 0.28 0.42 1.82 0.21 0.42 0.98 0.21 0.42 0.91 0.21 0.35 0.77 6.9167 0.42 0.77 0.14 0.2984 0.7 4.06 0.35 0.63 0.14 0.35 0.63 0.07 0.28 0.56 2.24 0.28 0.42 1.82 0.28 0.56 1.68 0.28 0.42 1.4 0.21 0.42 1.1595 0.21 0.42 0.77 0.14 0.2984 0.7 4.06 0.28 0.49 2.94 0.28 0.63 0.07 0.28 0.56 2.03 0.28 0.42 1.82 0.21 0.42 0.91 0.21 0.35 0.91 0.14 0.35 0.77 6.9167 0.42 0.77 0.14 0.2984 0.7 3.85 0.28 0.49 2.94 0.24 0.49 1.2132 0.21 0.49 1.1595 0.21 0.35 1.05 0.14 0.42 0.91 0.21 0.35 0.91 0.14 0.35 0.63 0.28 0.49 2.03 0.21 0.42 0.98 0.21 0.35 0.91 0.14 0.42 0.77 0.21 0.35 0.77 0.14 0.2984 0.7 4.06 0.28 0.56 3.22 0.24 0.49 1.33 0.21 0.42 1.2132 0.21 0.49 1.89 0.21 0.42 0.98 0.21 0.35 0.91 0.14 0.35 0.63 0.07 0.28 0.56 2.03 0.28 0.56 1.82 0.28 0.56 3.22 0.24 0.49 1.33 0.21 0.42 1.1595 0.21 0.42 0.77 0.14 0.35 0.7 0.14 0.28 0.63 2.6936 0.35 0.63 0.07 0.28 0.56 2.03 0.28 0.42 1.82 0.28 0.42 1.54 0.21 0.42 0.84 0.21 0.35 0.77 5.46 0.42 0.7 0.14 0.28 0.7 0.14 0.28 0.63 2.6936 0.28 0.49 2.45 0.21 0.49 1.12)
		loss_array=(3.308304 20 50 66.6667 20 46.86628 60 11.1111 40 50 11.1111 34.66666 50 9.0909 33.3333 50 80 33.3333 50 7.1429 25 50 75 33.3333 50 4.5455 33.3333 50 2.589188 20 50 66.6667 20 46.86628 60 19.05712 50 57.1429 16.6667 34.66666 50 14.2857 33.3333 50 7.6923 33.3333 50 6.25 25 50 75 25 50 66.6667 20 50 2.589188 20 50 66.6667 20 46.86628 60 11.1111 38.4615 50 10 33.3333 50 3.308304 33.3333 50 80 33.3333 50 6.25 25 50 71.14288 25 50 66.6667 16.6667 50 50 14.2857 50 50 12.5 33.3333 50 5.8824 38.4615 50 10 33.3333 50 3.308304 26.83638 50 20 50 66.6667 11.1111 40 50 11.1111 33.3333 50 4.053344 33.3333 50 8.3333 25 50 7.1429 25 50 75 25 50 66.6667 16.6667 50 50 14.2857 33.3333 50 7.6923 50 65.50002 11.1111 40 50 11.1111 33.3333 50 4.053344 33.3333 50 2.589188 20 50 66.6667 20 50 60 25 50 66.6667 16.6667 50 50 14.2857 33.3333 50 7.6923 33.3333 50 6.25 33.3333 50 4.5455 25 50 66.6667 33.3333 50 2.589188 20 50 66.6667 20 40 60 16.6667 38.4615 55.32568 10 33.3333 50 8.3333 26.83638 50 75.23077 33.3333 50 6.25 25 50 4.5455 25 50 66.6667 20 50 66.6667 14.2857 50 50)
	elif [ "$2" == "passable" ]
	then
		echo "Simulating passable experiences."
		lat_array=(27.067 43.524 79.901 292.35 41.322 68.13 233.148 39.32 67.197 129.7615 39.18 64.8 117.585 37.8935 55.151 106.979 720.645 61.11 99.265 35.98 49.831 91.1785 470.262 57.08 87.277 32.556 56.3315 83.535 24.109 43.524 79.901 292.35 41.322 68.13 233.148 40.494 74.7915 218.506 39.917 64.8 185.762 39.75 61.88 153.917 36.5865 61.11 99.265 35.52 49.831 91.1785 470.262 47.732 73.476 369.396 44.525 83.535 24.109 43.524 79.901 270.4085 41.322 68.13 233.148 39.32 65.78 123.76 39.1 57.08 117.585 27.067 55.151 106.979 720.645 61.11 99.265 35.52 49.831 91.1785 435.335 46.387 73.476 369.396 39.8285 70.996 160.097 39.58 69.666 153.917 39.49 59.8695 140.0315 34.848 65.78 123.76 39.1 56.3315 117.585 27.067 53.8455 81.866 41.322 68.822 270.4085 39.32 67.197 136.295 39.18 58.407 123.76 30.2065 62.9795 106.979 37.14 52.458 101.52 35.98 49.831 94.545 470.262 47.732 74.7915 410.042 39.8285 71.884 174.504 39.75 61.88 160.097 36.5865 68.822 253.526 39.32 67.197 136.295 39.18 57.08 117.585 30.2065 55.151 83.535 24.109 42.371 79.11 270.4085 40.845 78.168 233.148 47.732 74.7915 410.042 39.8285 70.996 174.504 39.75 61.88 153.917 36.5865 60.588 99.265 35.52 59.234 89.012 32.556 46.387 87.277 331.576 55.151 83.535 24.109 42.371 79.11 270.4085 40.845 67.197 233.148 40.0055 65.78 199.365 39.1 63.704 110.654 37.14 53.8455 101.52 640.259 60.588 94.545 35.52 48.8095 89.012 32.556 46.387 85.246 331.576 44.525 70.996 314.0905 39.6715 69.666 148.31)
		thru_array=(190.2857 435.5893 578.5714 710.1786 433.9286 485.1964 591.0893 296.4453 480.5926 587.5 295.7321 478.6708 587.5 291.5625 462.6295 587.5 1294.554 478.0301 587.5 289.2857 457.1429 581.1607 777.1429 468.7054 578.5714 268.6741 462.721 578.5714 95.19866 435.5893 578.5714 710.1786 433.9286 485.1964 591.0893 417.7857 578.5714 588.8929 335.0536 478.6708 587.5 319.6429 478.3504 587.5 289.2857 478.0301 587.5 289.2857 457.1429 581.1607 777.1429 457.1429 578.5714 723.5915 437.0078 578.5714 95.19866 435.5893 578.5714 656.7321 433.9286 485.1964 591.0893 296.4453 479.6317 587.5 294.6339 468.7054 587.5 190.2857 462.6295 587.5 1294.554 478.0301 587.5 289.2857 457.1429 581.1607 725.971 451.4141 578.5714 723.5915 326.5067 575.2098 587.5 304.0469 506.2969 587.5 296.5368 477.6786 587.5 289.2857 479.6317 587.5 294.6339 462.721 587.5 190.2857 462.5379 578.5714 433.9286 490.8248 656.7321 296.4453 480.5926 587.5 295.7321 474.8371 587.5 245.1998 478.4598 587.5 289.7321 461.2143 587.5 289.2857 457.1429 584.8214 777.1429 457.1429 578.5714 724.7813 326.5067 578.5714 587.5 319.6429 478.3504 587.5 289.2857 490.8248 603.2857 296.4453 480.5926 587.5 295.7321 468.7054 587.5 245.1998 462.6295 578.5714 95.19866 434.1708 578.5714 656.7321 433.9286 578.5714 591.0893 457.1429 578.5714 724.7813 326.5067 575.2098 587.5 319.6429 478.3504 587.5 289.2857 477.7098 587.5 289.2857 477.6786 578.5714 268.6741 451.4141 578.5714 723.2143 462.6295 578.5714 95.19866 434.1708 578.5714 656.7321 433.9286 480.5926 591.0893 376.4196 479.6317 587.5 294.6339 478.4598 587.5 289.7321 462.5379 587.5 998.0357 477.7098 584.8214 289.2857 457.1429 578.5714 268.6741 451.4141 578.5714 723.2143 437.0078 575.2098 723.2143 312.1462 506.2969 587.5)
		gap_array=(0.07 0.28 0.56 1.946 0.28 0.42 1.54 0.21 0.42 0.84 0.21 0.42 0.77 0.1568 0.35 0.7 6.9146 0.35 0.7 0.14 0.28 0.63 3.6484 0.35 0.63 0.14 0.35 0.56 0.07 0.28 0.56 1.946 0.28 0.42 1.54 0.26 0.49 1.4 0.21 0.42 1.19 0.21 0.35 1.05 0.14 0.35 0.7 0.14 0.28 0.63 3.6484 0.28 0.49 2.4822 0.28 0.56 0.07 0.28 0.56 1.82 0.28 0.42 1.54 0.21 0.42 0.77 0.21 0.35 0.77 0.07 0.35 0.7 6.9146 0.35 0.7 0.14 0.28 0.63 3.143 0.28 0.49 2.4822 0.21 0.49 1.05 0.21 0.42 1.05 0.21 0.35 0.91 0.14 0.42 0.77 0.21 0.35 0.77 0.07 0.2856 0.56 0.28 0.42 1.82 0.21 0.42 0.91 0.21 0.35 0.77 0.14 0.42 0.7 0.14 0.28 0.7 0.14 0.28 0.63 3.6484 0.28 0.49 2.7776 0.21 0.49 1.12 0.21 0.35 1.05 0.14 0.42 1.68 0.21 0.42 0.91 0.21 0.35 0.77 0.14 0.35 0.56 0.07 0.28 0.56 1.82 0.28 0.49 1.54 0.28 0.49 2.7776 0.21 0.49 1.12 0.21 0.35 1.05 0.14 0.35 0.7 0.14 0.35 0.63 0.14 0.28 0.63 2.31 0.35 0.56 0.07 0.28 0.56 1.82 0.28 0.42 1.54 0.21 0.42 1.26 0.21 0.42 0.77 0.14 0.2856 0.7 5.1884 0.35 0.63 0.14 0.28 0.63 0.14 0.28 0.56 2.31 0.28 0.49 2.1 0.21 0.42 0.98)
		loss_array=(0 3.4345 25 50 75 20 50 71.4286 12.5 50 66.6667 11.1111 50 66.6667 9.0909 33.3333 62.5 83.3333 39.6923 55.5556 7.1429 33.3333 50 80.82522 33.3333 50 4.5455 33.3333 50 2.7027 25 50 75 20 50 71.4286 20 50 71.4286 16.6667 50 66.6667 16.6667 50 66.6667 7.6923 39.6923 55.5556 6.283336 33.3333 50 80.82522 25 50 78.85383 25 50 2.7027 25 50 75 20 50 71.4286 12.5 50 66.6667 11.1111 33.3333 66.6667 3.4345 33.3333 62.5 83.3333 39.6923 55.5556 6.283336 33.3333 50 80 25 50 78.85383 16.6667 50 66.6667 14.2857 50 66.6667 14.2857 33.3333 66.6667 5.8824 50 66.6667 11.1111 33.3333 66.6667 3.4345 33.3333 50 20 50 75 12.5 50 66.6667 11.1111 33.3333 66.6667 4.1667 50 62.5 9.0909 33.3333 60 7.1429 33.3333 50 80.82522 25 50 80 16.6667 50 66.6667 16.6667 50 66.6667 7.6923 50 75 12.5 50 66.6667 11.1111 33.3333 66.6667 4.1667 33.3333 50 2.7027 20 50 75 20 50 71.4286 25 50 80 16.6667 50 66.6667 16.6667 50 66.6667 7.6923 34.23899 55.5556 6.283336 33.3333 50 4.5455 25 50 75 33.3333 50 2.7027 20 50 75 20 50 71.4286 20 50 71.4286 11.1111 50 66.6667 9.0909 33.3333 60 83.3333 34.23899 50 6.283336 25 50 4.5455 25 50 75 25 50 75 14.2857 50 66.6667)
	elif [ "$2" == "poor" ]
	then
		echo "Simulating poor experiences."
		lat_array=(25.7696 44.738 86.852 309.572 42.6192 70.3264 258.0316 39.253 69.6964 148.3806 39.0948 67.7718 137.01 37.0004 56.5448 123.3224 720.87 63.3 112.766 35.2636 51.95 102.0044 501.8212 58.806 96.7186 29.9812 57.4378 91.051 23.582 44.738 86.852 309.572 42.6192 70.3264 258.0316 40.9 79.2838 244.4508 39.9808 67.7718 214.0656 39.77 64.1644 181.5894 35.91 63.3 112.766 34.0748 51.95 102.0044 501.8212 49.472 78.2556 393.2282 45.719 91.051 23.582 44.738 86.852 291.1656 42.6192 70.3264 258.0316 39.253 68.76 141.3916 38.7198 58.806 137.01 25.7696 56.5448 123.3224 720.87 63.3 112.766 34.0748 51.95 102.0044 448.015 48.4178 78.2556 393.2282 39.88 75.3784 191.2936 39.5876 72.2352 181.5894 39.48 61.3278 159.5956 33.5004 68.76 141.3916 38.7198 57.4378 137.01 25.7696 55.87 88.7448 42.6192 71.136 291.1656 39.253 69.6964 152.9192 39.0948 59.64 141.3916 28.423 65.3086 123.3224 36.42 54.6052 118.3164 35.2636 51.95 109.238 501.8212 49.472 79.2838 415.9 39.88 77.3992 201.2512 39.77 64.1644 191.2936 35.91 71.136 271.736 39.253 69.6964 152.9192 39.0948 58.806 137.01 28.423 56.5448 91.051 23.582 43.767 84.9368 291.1656 41.49 83.061 258.0316 49.472 79.2838 415.9 39.88 75.3784 201.2512 39.77 64.1644 181.5894 35.91 62.3308 112.766 34.0748 60.4944 99.6776 29.9812 48.4178 96.7186 347.6744 56.5448 91.051 23.582 43.767 84.9368 291.1656 41.49 69.6964 258.0316 40.4674 68.76 229.332 38.7198 66.4708 129.7108 36.42 55.87 118.3164 640.3208 62.3308 109.238 34.0748 50.2318 99.6776 29.9812 48.4178 93.4524 347.6744 45.719 75.3784 324.5362 39.6958 72.2352 169.944)
		thru_array=(11.91741 145.2857 146.875 188.2589 144.6429 146.875 186.0223 93.41518 146.875 146.875 76.77232 146.875 146.875 41.79018 146.875 146.875 282.6049 146.875 146.875 27.25893 146.875 146.875 218.8482 146.875 146.875 22.50893 146.875 146.875 6.014511 145.2857 146.875 188.2589 144.6429 146.875 186.0223 144.6429 146.875 184.7411 144.6429 146.875 178.0536 144.6429 146.875 153.5112 27.625 146.875 146.875 27.00893 146.875 146.875 218.8482 146.875 146.875 188.3929 145.8348 146.875 6.014511 145.2857 146.875 187.7098 144.6429 146.875 186.0223 93.41518 146.875 146.875 64.78348 146.875 146.875 11.91741 146.875 146.875 282.6049 146.875 146.875 27.00893 146.875 146.875 188.3929 146.6161 146.875 188.3929 144.6429 146.875 163.8527 144.6429 146.875 153.5112 142.8348 146.875 147.3973 27.00893 146.875 146.875 64.78348 146.875 146.875 11.91741 146.875 146.875 144.6429 146.875 187.7098 93.41518 146.875 146.875 76.77232 146.875 146.875 17.38393 146.875 146.875 30.625 146.875 146.875 27.25893 146.875 146.875 218.8482 146.875 146.875 188.3929 144.6429 146.875 173.7522 144.6429 146.875 163.8527 27.625 146.875 187.1607 93.41518 146.875 146.875 76.77232 146.875 146.875 17.38393 146.875 146.875 6.014511 144.7366 146.875 187.7098 144.6429 146.875 186.0223 146.875 146.875 188.3929 144.6429 146.875 173.7522 144.6429 146.875 153.5112 27.625 146.875 146.875 27.00893 146.875 146.875 22.50893 146.6161 146.875 188.3929 146.875 146.875 6.014511 144.7366 146.875 187.7098 144.6429 146.875 186.0223 144.6429 146.875 182.3549 64.78348 146.875 146.875 30.625 146.875 146.875 275.9241 146.875 146.875 27.00893 146.875 146.875 22.50893 146.6161 146.875 188.3929 145.8348 146.875 188.3929 144.6429 146.875 147.9464)
		gap_array=(0.07 0.28 0.49 1.82 0.21 0.42 1.33 0.21 0.42 0.77 0.14 0.35 0.7 0.14 0.28 0.7 6.9167 0.35 0.63 0.14 0.28 0.63 3.22 0.28 0.56 0.07 0.28 0.56 0.07 0.28 0.49 1.82 0.21 0.42 1.33 0.21 0.49 1.26 0.21 0.35 1.12 0.21 0.35 0.98 0.14 0.35 0.63 0.14 0.28 0.63 3.22 0.28 0.42 2.3569 0.28 0.56 0.07 0.28 0.49 1.6737 0.21 0.42 1.33 0.21 0.42 0.77 0.14 0.28 0.7 0.07 0.28 0.7 6.9167 0.35 0.63 0.14 0.28 0.63 2.87 0.28 0.42 2.3569 0.21 0.42 0.98 0.21 0.42 0.98 0.21 0.35 0.84 0.14 0.42 0.77 0.14 0.28 0.7 0.07 0.28 0.5332 0.21 0.42 1.6737 0.21 0.42 0.84 0.14 0.35 0.77 0.07 0.35 0.7 0.14 0.28 0.63 0.14 0.28 0.63 3.22 0.28 0.49 2.5802 0.21 0.42 1.05 0.21 0.35 0.98 0.14 0.42 1.54 0.21 0.42 0.84 0.14 0.28 0.7 0.07 0.28 0.56 0.07 0.24 0.49 1.6737 0.21 0.49 1.33 0.28 0.49 2.5802 0.21 0.42 1.05 0.21 0.35 0.98 0.14 0.35 0.63 0.14 0.35 0.56 0.07 0.28 0.56 2.1 0.28 0.56 0.07 0.24 0.49 1.6737 0.21 0.42 1.33 0.21 0.42 1.1475 0.14 0.35 0.7 0.14 0.28 0.63 4.97 0.35 0.63 0.14 0.28 0.56 0.07 0.28 0.56 2.1 0.28 0.42 1.89 0.21 0.42 0.91)
		loss_array=(3.4483 25 50 83.3333 20 50 81.51371 12.5 50 71.4286 12.5 50 66.6667 9.208416 33.3333 66.6667 85.7143 50 66.6667 7.6923 33.3333 66.6667 83.3333 33.3333 66.6667 4.709964 33.3333 59.33332 2.735744 25 50 83.3333 20 50 81.51371 20 50 80 16.6667 50 80 16.6667 50 75 8.3333 50 66.6667 6.704796 33.3333 66.6667 83.3333 25 50 83.3333 25 59.33332 2.735744 25 50 83.3333 20 50 81.51371 12.5 50 71.4286 11.1111 33.3333 66.6667 3.4483 33.3333 66.6667 85.7143 50 66.6667 6.704796 33.3333 66.6667 83.3333 25 50 83.3333 16.6667 50 75 14.2857 50 75 14.2857 33.3333 75 6.117664 50 71.4286 11.1111 33.3333 66.6667 3.4483 33.3333 50 20 50 83.3333 12.5 50 75 12.5 33.3333 71.4286 4.287916 50 66.6667 9.0909 33.3333 66.6667 7.6923 33.3333 66.6667 83.3333 25 50 83.3333 16.6667 50 80 16.6667 50 75 8.3333 50 83.3333 12.5 50 75 12.5 33.3333 66.6667 4.287916 33.3333 59.33332 2.735744 20 50 83.3333 20 50 81.51371 25 50 83.3333 16.6667 50 80 16.6667 50 75 8.3333 40.83077 66.6667 6.704796 33.3333 66.6667 4.709964 25 66.6667 83.3333 33.3333 59.33332 2.735744 20 50 83.3333 20 50 81.51371 20 50 80 11.1111 50 66.6667 9.0909 33.3333 66.6667 85.7143 40.83077 66.6667 6.704796 26.71699 66.6667 4.709964 25 62.5 83.3333 25 50 83.3333 16.6667 50 75)
	elif [ "$2" == "verypoor" ]
	then
		echo "Simulating very poor experiences."
		lat_array=(25.7696 44.7592 87.8132 313.076 42.6728 70.6276 264.8418 39.253 69.9446 150.5224 39.0948 68.007 139.99 37.0004 56.6448 127.7086 720.87 63.38 115.0416 35.2636 52.3896 105.3186 508.776 58.828 98.1294 29.9812 57.6778 92.378 23.582 44.7592 87.8132 313.076 42.6728 70.6276 264.8418 40.9136 79.967 248.7832 40 68.007 220.222 39.77 64.34 187.75 35.91 63.38 115.0416 34.0748 52.3896 105.3186 508.776 49.5572 78.678 399.4336 45.769 92.378 23.582 44.7592 87.8132 297.5126 42.6728 70.6276 264.8418 39.253 68.99 145.4408 38.7198 58.828 139.99 25.7696 56.6448 127.7086 720.87 63.38 115.0416 34.0748 52.3896 105.3186 448.529 48.6742 78.678 399.4336 39.88 75.746 196.594 39.5876 73.0452 187.75 39.48 61.3552 167.1096 33.5004 68.99 145.4408 38.7198 57.6778 139.99 25.7696 55.9502 89.892 42.6728 71.4106 297.5126 39.253 69.9446 158.4188 39.0948 59.6648 145.4408 28.423 65.4508 127.7086 36.42 54.7364 120.4064 35.2636 52.3896 110.66 508.776 49.5572 79.967 416.6324 39.88 77.8896 207.996 39.77 64.34 196.594 35.91 71.4106 280.7444 39.253 69.9446 158.4188 39.0948 58.828 139.99 28.423 56.6448 92.378 23.582 43.817 85.9964 297.5126 41.49 83.9514 264.8418 49.5572 79.967 416.6324 39.88 75.746 207.996 39.77 64.34 187.75 35.91 62.3408 115.0416 34.0748 60.5352 100.6884 29.9812 48.6742 98.1294 354.2584 56.6448 92.378 23.582 43.817 85.9964 297.5126 41.49 69.9446 264.8418 40.4886 68.99 233.957 38.7198 66.7144 132.0828 36.42 55.9502 120.4064 640.3208 62.3408 110.66 34.0748 50.4412 100.6884 29.9812 48.6742 94.5568 354.2584 45.769 75.746 328.54 39.6958 73.0452 179.476)
		thru_array=(0.11161 21.04464 37.34152 144.6429 17.1875 27.90179 144.6429 14.67634 27.90179 122.135 12.21652 27.90179 90.70871 5.69196 27.00893 83.64062 144.6429 27.59487 56.73437 2.799108 27.00893 48.84598 144.6429 27.00893 45.56027 0.11161 27.00893 41.96987 0.11161 21.04464 37.34152 144.6429 17.1875 27.90179 144.6429 17.0625 29.96094 144.6429 16.42188 27.90179 144.6429 16.40625 27.82366 144.6429 4.446426 27.59487 56.73437 1.470985 27.00893 48.84598 144.6429 27.00893 28.79464 144.6429 24.33928 41.96987 0.11161 21.04464 37.34152 144.6429 17.1875 27.90179 144.6429 14.67634 27.90179 100.6741 8.60156 27.00893 90.70871 0.11161 27.00893 83.64062 144.6429 27.59487 56.73437 1.470985 27.00893 48.84598 144.6429 26.49107 28.79464 144.6429 16.40625 28.75893 144.6429 15.92188 28.02679 144.6429 15.59152 27.21987 144.6429 0.83036 27.90179 100.6741 8.60156 27.00893 90.70871 0.11161 27.00893 39.36161 17.1875 27.90179 144.6429 14.67634 27.90179 143.596 12.21652 27.00893 100.6741 0.11161 27.90179 83.64062 5.69196 27.00893 70.1875 2.799108 27.00893 51.31696 144.6429 27.00893 29.96094 144.6429 16.40625 28.79464 144.6429 16.40625 27.82366 144.6429 4.446426 27.90179 144.6429 14.67634 27.90179 143.596 12.21652 27.00893 90.70871 0.11161 27.00893 41.96987 0.11161 17.75 36.15179 144.6429 17.1875 34.96206 144.6429 27.00893 29.96094 144.6429 16.40625 28.75893 144.6429 16.40625 27.82366 144.6429 4.446426 27.36607 56.73437 1.470985 27.08259 46.75 0.11161 26.49107 45.56027 144.6429 27.00893 41.96987 0.11161 17.75 36.15179 144.6429 17.1875 27.90179 144.6429 16.74219 27.90179 144.6429 8.60156 27.90179 88.10045 5.69196 27.00893 70.1875 144.6429 27.36607 51.31696 1.470985 27.00893 46.75 0.11161 26.49107 44.37054 144.6429 24.33928 28.75893 144.6429 16.24219 28.02679 144.6429)
		gap_array=(0.07 0.21 0.49 1.61 0.21 0.35 1.19 0.14 0.35 0.7 0.14 0.35 0.7 0.14 0.28 0.63 6.8201 0.35 0.63 0.07 0.28 0.56 2.94 0.28 0.56 0.07 0.28 0.49 0.07 0.21 0.49 1.61 0.21 0.35 1.19 0.21 0.42 1.12 0.21 0.35 0.98 0.21 0.35 0.84 0.07 0.35 0.63 0.07 0.28 0.56 2.94 0.28 0.42 2.1 0.21 0.49 0.07 0.21 0.49 1.47 0.21 0.35 1.19 0.14 0.35 0.7 0.14 0.28 0.7 0.07 0.28 0.63 6.8201 0.35 0.63 0.07 0.28 0.56 2.66 0.28 0.42 2.1 0.21 0.42 0.91 0.21 0.42 0.84 0.14 0.3417 0.77 0.07 0.35 0.7 0.14 0.28 0.7 0.07 0.28 0.49 0.21 0.42 1.47 0.14 0.35 0.77 0.14 0.28 0.7 0.07 0.35 0.63 0.14 0.28 0.63 0.07 0.28 0.56 2.94 0.28 0.42 2.38 0.21 0.42 0.98 0.21 0.35 0.91 0.07 0.42 1.33 0.14 0.35 0.77 0.14 0.28 0.7 0.07 0.28 0.49 0.07 0.21 0.49 1.47 0.21 0.49 1.19 0.28 0.42 2.38 0.21 0.42 0.98 0.21 0.35 0.84 0.07 0.35 0.63 0.07 0.28 0.56 0.07 0.28 0.56 1.89 0.28 0.49 0.07 0.21 0.49 1.47 0.21 0.35 1.19 0.21 0.35 1.05 0.14 0.35 0.63 0.14 0.28 0.63 4.6802 0.35 0.56 0.07 0.28 0.56 0.07 0.28 0.49 1.89 0.21 0.42 1.7703 0.21 0.42 0.84)
		loss_array=(3.4483 25 50 83.3333 20 50 83.3333 12.5 50 75 12.5 50 75 9.854544 33.3333 66.6667 90.9091 50 66.6667 7.6923 33.3333 66.6667 88.8889 33.3333 66.6667 4.709964 33.3333 62.5 2.735744 25 50 83.3333 20 50 83.3333 20 50 83.3333 20 50 83.3333 16.6667 50 80 8.3333 50 66.6667 6.704796 33.3333 66.6667 88.8889 25 50 85.7143 25 62.5 2.735744 25 50 83.3333 20 50 83.3333 12.5 50 75 11.1111 33.3333 75 3.4483 33.3333 66.6667 90.9091 50 66.6667 6.704796 33.3333 66.6667 85.7143 25 50 85.7143 16.6667 50 80 14.2857 50 80 14.2857 37.16666 75 6.117664 50 75 11.1111 33.3333 75 3.4483 33.3333 55.80957 20 50 83.3333 12.5 50 75 12.5 33.3333 75 4.287916 50 66.6667 9.0909 33.3333 66.6667 7.6923 33.3333 66.6667 88.8889 25 50 85.7143 16.6667 50 83.3333 16.6667 50 80 8.3333 50 83.3333 12.5 50 75 12.5 33.3333 75 4.287916 33.3333 62.5 2.735744 20.7333 50 83.3333 20 50 83.3333 25 50 85.7143 16.6667 50 83.3333 16.6667 50 80 8.3333 50 66.6667 6.704796 33.3333 66.6667 4.709964 25 66.6667 84.47618 33.3333 62.5 2.735744 20.7333 50 83.3333 20 50 83.3333 20 50 83.3333 11.1111 50 71.4286 9.0909 33.3333 66.6667 90.10909 50 66.6667 6.704796 28.87905 66.6667 4.709964 25 66.6667 84.47618 25 50 83.3333 16.6667 50 80)
	else
		echo "Please select a valid network experience to simulate. Valid values are noloss, good, fair, passable, poor, and verypoor."
		exit 1	
	fi
elif [ "$1" == "mgst_brazil_2019_09_17" ]
then
	if [ "$2" == "noloss" ]
	then
		echo "Simulating no loss experiences."
        # recalcualted from akamai based on 20 ms (gut feel, stats show 0..)
        lat_array=(5.3035 8.5622 14.7283 53.7412 8.5154 12.3922 38.8933 7.6708 12.1237 20.0430 7.6097 11.7001 18.7499 7.2944 9.3613 17.7117 152.2148 10.7048 16.9466 6.7750 8.8010 16.2155 97.1468 9.7178 15.4522 5.9085 9.5688 15.0513 4.8856 8.5622 14.7283 53.7412 8.5154 12.3922 38.8933 8.4795 13.8054 34.6432 8.4284 11.7001 30.2444 8.1842 10.8679 25.6974 6.9445 10.7048 16.9466 6.5658 8.8010 16.2155 97.1468 8.6470 13.6070 70.5608 8.5812 15.0513 4.8856 8.5622 14.7283 47.6009 8.5154 12.3922 38.8933 7.6708 11.9059 19.3150 7.5449 9.7178 18.7499 5.3035 9.3613 17.7117 152.2148 10.7048 16.9466 6.5658 8.8010 16.2155 88.6254 8.6258 13.6070 70.5608 8.3222 13.1130 26.6624 7.9639 12.7889 25.6974 7.8924 10.2816 22.2208 6.4396 11.9059 19.3150 7.5449 9.5688 18.7499 5.3035 9.1649 14.8553 8.5154 12.6398 47.6009 7.6708 12.1237 21.0604 7.6097 9.8736 19.3150 5.6068 11.2054 17.7117 7.1332 9.0062 17.2954 6.7750 8.8010 16.7832 97.1468 8.6470 13.8054 78.5820 8.3222 13.3272 28.2120 8.1842 10.8679 26.6624 6.9445 12.6398 42.8868 7.6708 12.1237 21.0604 7.6097 9.7178 18.7499 5.6068 9.3613 15.0513 4.8856 8.5406 14.5110 47.6009 8.4996 14.2452 38.8933 8.6470 13.8054 78.5820 8.3222 13.1130 28.2120 8.1842 10.8679 25.6974 6.9445 10.5194 16.9466 6.5658 10.0354 15.9106 5.9085 8.6258 15.4522 65.6446 9.3613 15.0513 4.8856 8.5406 14.5110 47.6009 8.4996 12.1237 38.8933 8.4499 11.9059 32.3732 7.5449 11.4324 18.2220 7.1332 9.1649 17.2954 134.8372 10.5194 16.7832 6.5658 8.7161 15.9106 5.9085 8.6258 15.1913 65.6446 8.5812 13.1130 60.5526 8.0744 12.7889 23.9095)
        # recalcualted from akamai based on p90 = 10 Mbit 
        thru_array=(600.7359 9962.4053 11341.2429 12652.2353 9772.2426 10992.8574 12467.8502 6975.9351 10975.9869 11863.5058 6843.4671 10822.2723 11564.8926 6552.8401 10269.5000 11432.5721 14939.2926 10553.1426 11432.5721 6202.1229 10133.8400 11399.3282 14146.0974 10269.5000 11385.7500 2820.9026 10269.5000 11376.3093 312.1581 9962.4053 11341.2429 12652.2353 9772.2426 10992.8574 12467.8502 9626.1600 11245.7398 12425.4239 9382.4447 10822.2723 12350.0684 9262.5000 10553.1426 12138.3126 6304.4356 10553.1426 11432.5721 5854.8606 10133.8400 11399.3282 14146.0974 10116.0347 11225.6180 12922.4092 10081.4821 11376.3093 312.1581 9962.4053 11341.2429 12583.7958 9772.2426 10992.8574 12467.8502 6975.9351 10899.1296 11680.4400 6773.4970 10269.5000 11564.8926 600.7359 10269.5000 11432.5721 14939.2926 10553.1426 11432.5721 5854.8606 10133.8400 11399.3282 13999.0982 10113.4279 11225.6180 12922.4092 9320.9258 11155.7147 12228.4547 8143.5079 11016.6074 12138.3126 7457.5243 10448.1942 12069.7910 4980.0155 10899.1296 11680.4400 6773.4970 10269.5000 11564.8926 600.7359 10269.5000 11365.2498 9772.2426 10992.8574 12583.7958 6975.9351 10975.9869 12046.5700 6843.4671 10269.5000 11680.4400 1479.7709 10621.2523 11432.5721 6415.3333 10237.2547 11432.5721 6202.1229 10133.8400 11418.5242 14146.0974 10116.0347 11245.7398 13460.7537 9320.9258 11192.4410 12314.5962 9262.5000 10553.1426 12228.4547 6304.4356 10992.8574 12515.3547 6975.9351 10975.9869 12046.5700 6843.4671 10269.5000 11564.8926 1479.7709 10269.5000 11376.3093 312.1581 9843.3300 11298.9534 12583.7958 9711.0353 11256.6655 12467.8502 10116.0347 11245.7398 13460.7537 9320.9258 11155.7147 12314.5962 9262.5000 10553.1426 12138.3126 6304.4356 10553.1426 11432.5721 5854.8606 10331.9021 11385.7500 2820.9026 10113.4279 11385.7500 12728.5347 10269.5000 11376.3093 312.1581 9843.3300 11298.9534 12583.7958 9711.0353 10975.9869 12467.8502 9504.3016 10899.1296 12385.5406 6773.4970 10724.6792 11492.5574 6415.3333 10269.5000 11432.5721 14488.5853 10553.1426 11418.5242 5854.8606 10124.9374 11385.7500 2820.9026 10113.4279 11385.7500 12728.5347 10081.4821 11155.7147 12694.5916 8864.6400 11016.6074 12084.8147)
		gap_array=(99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999)
		loss_array=(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 )
	elif [ "$2" == "good" ]
	then
		echo "Simulating good experiences. - p10"
        # recalcualted from akamai based on 20 ms (gut feel, stats show 0..)
        lat_array=(5.3035 8.5622 14.7283 53.7412 8.5154 12.3922 38.8933 7.6708 12.1237 20.0430 7.6097 11.7001 18.7499 7.2944 9.3613 17.7117 152.2148 10.7048 16.9466 6.7750 8.8010 16.2155 97.1468 9.7178 15.4522 5.9085 9.5688 15.0513 4.8856 8.5622 14.7283 53.7412 8.5154 12.3922 38.8933 8.4795 13.8054 34.6432 8.4284 11.7001 30.2444 8.1842 10.8679 25.6974 6.9445 10.7048 16.9466 6.5658 8.8010 16.2155 97.1468 8.6470 13.6070 70.5608 8.5812 15.0513 4.8856 8.5622 14.7283 47.6009 8.5154 12.3922 38.8933 7.6708 11.9059 19.3150 7.5449 9.7178 18.7499 5.3035 9.3613 17.7117 152.2148 10.7048 16.9466 6.5658 8.8010 16.2155 88.6254 8.6258 13.6070 70.5608 8.3222 13.1130 26.6624 7.9639 12.7889 25.6974 7.8924 10.2816 22.2208 6.4396 11.9059 19.3150 7.5449 9.5688 18.7499 5.3035 9.1649 14.8553 8.5154 12.6398 47.6009 7.6708 12.1237 21.0604 7.6097 9.8736 19.3150 5.6068 11.2054 17.7117 7.1332 9.0062 17.2954 6.7750 8.8010 16.7832 97.1468 8.6470 13.8054 78.5820 8.3222 13.3272 28.2120 8.1842 10.8679 26.6624 6.9445 12.6398 42.8868 7.6708 12.1237 21.0604 7.6097 9.7178 18.7499 5.6068 9.3613 15.0513 4.8856 8.5406 14.5110 47.6009 8.4996 14.2452 38.8933 8.6470 13.8054 78.5820 8.3222 13.1130 28.2120 8.1842 10.8679 25.6974 6.9445 10.5194 16.9466 6.5658 10.0354 15.9106 5.9085 8.6258 15.4522 65.6446 9.3613 15.0513 4.8856 8.5406 14.5110 47.6009 8.4996 12.1237 38.8933 8.4499 11.9059 32.3732 7.5449 11.4324 18.2220 7.1332 9.1649 17.2954 134.8372 10.5194 16.7832 6.5658 8.7161 15.9106 5.9085 8.6258 15.1913 65.6446 8.5812 13.1130 60.5526 8.0744 12.7889 23.9095)
        # recalcualted from akamai based on p90 = 10 Mbit 
        thru_array=(600.7359 9962.4053 11341.2429 12652.2353 9772.2426 10992.8574 12467.8502 6975.9351 10975.9869 11863.5058 6843.4671 10822.2723 11564.8926 6552.8401 10269.5000 11432.5721 14939.2926 10553.1426 11432.5721 6202.1229 10133.8400 11399.3282 14146.0974 10269.5000 11385.7500 2820.9026 10269.5000 11376.3093 312.1581 9962.4053 11341.2429 12652.2353 9772.2426 10992.8574 12467.8502 9626.1600 11245.7398 12425.4239 9382.4447 10822.2723 12350.0684 9262.5000 10553.1426 12138.3126 6304.4356 10553.1426 11432.5721 5854.8606 10133.8400 11399.3282 14146.0974 10116.0347 11225.6180 12922.4092 10081.4821 11376.3093 312.1581 9962.4053 11341.2429 12583.7958 9772.2426 10992.8574 12467.8502 6975.9351 10899.1296 11680.4400 6773.4970 10269.5000 11564.8926 600.7359 10269.5000 11432.5721 14939.2926 10553.1426 11432.5721 5854.8606 10133.8400 11399.3282 13999.0982 10113.4279 11225.6180 12922.4092 9320.9258 11155.7147 12228.4547 8143.5079 11016.6074 12138.3126 7457.5243 10448.1942 12069.7910 4980.0155 10899.1296 11680.4400 6773.4970 10269.5000 11564.8926 600.7359 10269.5000 11365.2498 9772.2426 10992.8574 12583.7958 6975.9351 10975.9869 12046.5700 6843.4671 10269.5000 11680.4400 1479.7709 10621.2523 11432.5721 6415.3333 10237.2547 11432.5721 6202.1229 10133.8400 11418.5242 14146.0974 10116.0347 11245.7398 13460.7537 9320.9258 11192.4410 12314.5962 9262.5000 10553.1426 12228.4547 6304.4356 10992.8574 12515.3547 6975.9351 10975.9869 12046.5700 6843.4671 10269.5000 11564.8926 1479.7709 10269.5000 11376.3093 312.1581 9843.3300 11298.9534 12583.7958 9711.0353 11256.6655 12467.8502 10116.0347 11245.7398 13460.7537 9320.9258 11155.7147 12314.5962 9262.5000 10553.1426 12138.3126 6304.4356 10553.1426 11432.5721 5854.8606 10331.9021 11385.7500 2820.9026 10113.4279 11385.7500 12728.5347 10269.5000 11376.3093 312.1581 9843.3300 11298.9534 12583.7958 9711.0353 10975.9869 12467.8502 9504.3016 10899.1296 12385.5406 6773.4970 10724.6792 11492.5574 6415.3333 10269.5000 11432.5721 14488.5853 10553.1426 11418.5242 5854.8606 10124.9374 11385.7500 2820.9026 10113.4279 11385.7500 12728.5347 10081.4821 11155.7147 12694.5916 8864.6400 11016.6074 12084.8147)
		gap_array=(0.14 0.28 0.63 2.52 0.28 0.49 2.03 0.21 0.48 1.05 0.21 0.42 0.98 0.21 0.35 0.91 6.9167 0.42 0.8043 0.14 0.35 0.77 4.13 0.35 0.7 0.14 0.35 0.63 0.07 0.28 0.63 2.52 0.28 0.49 2.03 0.28 0.56 1.89 0.28 0.42 1.75 0.26 0.42 1.3573 0.21 0.42 0.8043 0.14 0.35 0.77 4.13 0.28 0.56 3.22 0.28 0.63 0.07 0.28 0.63 2.38 0.28 0.49 2.03 0.21 0.42 1.05 0.21 0.35 0.98 0.14 0.35 0.91 6.9167 0.42 0.8043 0.14 0.35 0.77 3.99 0.28 0.56 3.22 0.28 0.49 1.47 0.21 0.49 1.3573 0.21 0.42 1.19 0.14 0.42 1.05 0.21 0.35 0.98 0.14 0.35 0.63 0.28 0.49 2.38 0.21 0.48 1.12 0.21 0.35 1.05 0.14 0.42 0.91 0.21 0.35 0.84 0.14 0.35 0.77 4.13 0.28 0.56 3.5602 0.28 0.56 1.61 0.26 0.42 1.47 0.21 0.49 2.17 0.21 0.48 1.12 0.21 0.35 0.98 0.14 0.35 0.63 0.07 0.28 0.63 2.38 0.28 0.56 2.03 0.28 0.56 3.5602 0.28 0.49 1.61 0.26 0.42 1.3573 0.21 0.42 0.8043 0.14 0.35 0.7 0.14 0.28 0.7 2.94 0.35 0.63 0.07 0.28 0.63 2.38 0.28 0.48 2.03 0.28 0.42 1.82 0.21 0.42 0.91 0.21 0.35 0.84 5.46 0.42 0.77 0.14 0.35 0.7 0.14 0.28 0.7 2.94 0.28 0.49 2.73 0.21 0.49 1.26)
		loss_array=(2.838572 16.6667 33.3333 50 16.6667 33.3333 50 9.0909 33.3333 50 9.0909 33.3333 50 7.1429 21.89471 50 73.42858 25 50 5.8824 20 50 66.6667 25 40 3.780248 25 37.5 1.7241 16.6667 33.3333 50 16.6667 33.3333 50 14.2857 33.3333 50 14.2857 33.3333 50 12.5 25 50 6.25 25 50 5.2632 20 50 66.6667 20 33.3333 50 16.6667 37.5 1.7241 16.6667 33.3333 50 16.6667 33.3333 50 9.0909 33.3333 50 8.878772 25 50 2.838572 21.89471 50 73.42858 25 50 5.2632 20 50 59.8919 20 33.3333 50 12.5 33.3333 50 11.1111 33.3333 50 11.1111 25 50 5 33.3333 50 8.878772 25 50 2.838572 20 33.3333 16.6667 33.3333 50 9.0909 33.3333 50 9.0909 25 50 3.3701 26.55441 50 6.6667 20 50 5.8824 20 50 66.6667 20 33.3333 50 12.5 33.3333 50 12.5 25 50 6.25 33.3333 50 9.0909 33.3333 50 9.0909 25 50 3.3701 21.89471 37.5 1.7241 16.6667 33.3333 50 14.2857 33.3333 50 20 33.3333 50 12.5 33.3333 50 12.5 25 50 6.25 25 50 5.2632 25 45.24671 3.780248 20 40 50 21.89471 37.5 1.7241 16.6667 33.3333 50 14.2857 33.3333 50 14.2857 33.3333 50 8.878772 30 50 6.6667 20 50 66.6667 25 50 5.2632 20 45.24671 3.780248 20 40 50 16.6667 33.3333 50 11.1111 33.3333 50)
	elif [ "$2" == "fair" ]
	then
		echo "Simulating fair experiences. - p25"
        # recalcualted from akamai based on p75 = 50 ms rtt
        lat_array=(13.2587 21.4056 36.8208 134.3531 21.2885 30.9804 97.2332 19.1770 30.3092 50.1074 19.0242 29.2503 46.8747 18.2360 23.4032 44.2792 380.5370 26.7619 42.3665 16.9374 22.0024 40.5387 242.8669 24.2946 38.6306 14.7712 23.9219 37.6283 12.2139 21.4056 36.8208 134.3531 21.2885 30.9804 97.2332 21.1987 34.5135 86.6080 21.0710 29.2503 75.6110 20.4606 27.1698 64.2434 17.3612 26.7619 42.3665 16.4146 22.0024 40.5387 242.8669 21.6175 34.0176 176.4020 21.4530 37.6283 12.2139 21.4056 36.8208 119.0023 21.2885 30.9804 97.2332 19.1770 29.7648 48.2874 18.8622 24.2946 46.8747 13.2587 23.4032 44.2792 380.5370 26.7619 42.3665 16.4146 22.0024 40.5387 221.5636 21.5645 34.0176 176.4020 20.8056 32.7825 66.6561 19.9098 31.9723 64.2434 19.7310 25.7040 55.5520 16.0989 29.7648 48.2874 18.8622 23.9219 46.8747 13.2587 22.9122 37.1382 21.2885 31.5995 119.0023 19.1770 30.3092 52.6511 19.0242 24.6839 48.2874 14.0171 28.0136 44.2792 17.8330 22.5156 43.2384 16.9374 22.0024 41.9580 242.8669 21.6175 34.5135 196.4550 20.8056 33.3180 70.5299 20.4606 27.1698 66.6561 17.3612 31.5995 107.2170 19.1770 30.3092 52.6511 19.0242 24.2946 46.8747 14.0171 23.4032 37.6283 12.2139 21.3516 36.2774 119.0023 21.2490 35.6130 97.2332 21.6175 34.5135 196.4550 20.8056 32.7825 70.5299 20.4606 27.1698 64.2434 17.3612 26.2984 42.3665 16.4146 25.0884 39.7766 14.7712 21.5645 38.6306 164.1116 23.4032 37.6283 12.2139 21.3516 36.2774 119.0023 21.2490 30.3092 97.2332 21.1248 29.7648 80.9330 18.8622 28.5809 45.5550 17.8330 22.9122 43.2384 337.0931 26.2984 41.9580 16.4146 21.7903 39.7766 14.7712 21.5645 37.9782 164.1116 21.4530 32.7825 151.3814 20.1861 31.9723 59.7737)
        # recalcualted from akamai based on p75 = 9.4 Mbit 
        thru_array=(1229.9898 8235.7710 11030.9676 13552.3939 8175.2129 10041.2710 12836.7470 5928.2572 9963.1007 11990.8750 5438.5491 9700.4491 11988.0710 4191.4792 9083.5710 11968.4020 17043.4992 9146.6504 11836.5000 3687.5940 8381.0933 11811.5904 15331.2729 9083.5710 11416.3680 1550.8237 9083.5710 11068.5000 615.1703 8235.7710 11030.9676 13552.3939 8175.2129 10041.2710 12836.7470 8112.4129 10628.0114 12763.4689 7790.5629 9700.4491 12717.0000 7370.0290 9204.1250 12681.0093 3766.9073 9146.6504 11836.5000 3366.4128 8381.0933 11811.5904 15331.2729 8311.5517 10481.7973 13772.6021 8287.4962 11068.5000 615.1703 8235.7710 11030.9676 13253.2461 8175.2129 10041.2710 12836.7470 5928.2572 9831.7733 11990.8750 4941.6943 9083.5710 11988.0710 1229.9898 9083.5710 11968.4020 17043.4992 9146.6504 11836.5000 3366.4128 8381.0933 11811.5904 14701.3670 8301.3750 10481.7973 13772.6021 7581.5300 10146.1250 12699.6892 7050.4492 10146.1250 12681.0093 6882.8863 9083.5710 12256.2961 2524.2865 9831.7733 11990.8750 4941.6943 9083.5710 11988.0710 1229.9898 9083.5710 11068.5000 8175.2129 10104.4917 13253.2461 5928.2572 9963.1007 11990.8750 5438.5491 9083.5710 11990.8750 1518.2076 9344.6745 11968.4020 3898.3665 8916.1996 11902.4495 3687.5940 8381.0933 11815.7572 15331.2729 8311.5517 10628.0114 14236.9829 7581.5300 10305.3544 12717.0000 7370.0290 9204.1250 12699.6892 3766.9073 10104.4917 12954.0983 5928.2572 9963.1007 11990.8750 5438.5491 9083.5710 11988.0710 1518.2076 9083.5710 11068.5000 615.1703 8184.0458 10940.4477 13253.2461 8175.2129 10849.9277 12836.7470 8311.5517 10628.0114 14236.9829 7581.5300 10146.1250 12717.0000 7370.0290 9204.1250 12681.0093 3766.9073 9089.1790 11836.5000 3366.4128 9083.5710 11719.8271 1550.8237 8301.3750 11416.3680 13625.3580 9083.5710 11068.5000 615.1703 8184.0458 10940.4477 13253.2461 8175.2129 9963.1007 12836.7470 7951.4879 9831.7733 12717.0000 4941.6943 9528.3017 11983.4740 3898.3665 9083.5710 11902.4495 16561.8735 9089.1790 11815.7572 3366.4128 8346.3241 11719.8271 1550.8237 8301.3750 11112.9090 13625.3580 8287.4962 10146.1250 13625.3580 7193.5579 10146.1250 12535.3290)
		gap_array=(0.14 0.28 0.56 2.24 0.28 0.42 1.82 0.21 0.42 0.98 0.21 0.42 0.91 0.21 0.35 0.77 6.9167 0.42 0.77 0.14 0.2984 0.7 4.06 0.35 0.63 0.14 0.35 0.63 0.07 0.28 0.56 2.24 0.28 0.42 1.82 0.28 0.56 1.68 0.28 0.42 1.4 0.21 0.42 1.1595 0.21 0.42 0.77 0.14 0.2984 0.7 4.06 0.28 0.49 2.94 0.28 0.63 0.07 0.28 0.56 2.03 0.28 0.42 1.82 0.21 0.42 0.91 0.21 0.35 0.91 0.14 0.35 0.77 6.9167 0.42 0.77 0.14 0.2984 0.7 3.85 0.28 0.49 2.94 0.24 0.49 1.2132 0.21 0.49 1.1595 0.21 0.35 1.05 0.14 0.42 0.91 0.21 0.35 0.91 0.14 0.35 0.63 0.28 0.49 2.03 0.21 0.42 0.98 0.21 0.35 0.91 0.14 0.42 0.77 0.21 0.35 0.77 0.14 0.2984 0.7 4.06 0.28 0.56 3.22 0.24 0.49 1.33 0.21 0.42 1.2132 0.21 0.49 1.89 0.21 0.42 0.98 0.21 0.35 0.91 0.14 0.35 0.63 0.07 0.28 0.56 2.03 0.28 0.56 1.82 0.28 0.56 3.22 0.24 0.49 1.33 0.21 0.42 1.1595 0.21 0.42 0.77 0.14 0.35 0.7 0.14 0.28 0.63 2.6936 0.35 0.63 0.07 0.28 0.56 2.03 0.28 0.42 1.82 0.28 0.42 1.54 0.21 0.42 0.84 0.21 0.35 0.77 5.46 0.42 0.7 0.14 0.28 0.7 0.14 0.28 0.63 2.6936 0.28 0.49 2.45 0.21 0.49 1.12)
		loss_array=(3.308304 20 50 66.6667 20 46.86628 60 11.1111 40 50 11.1111 34.66666 50 9.0909 33.3333 50 80 33.3333 50 7.1429 25 50 75 33.3333 50 4.5455 33.3333 50 2.589188 20 50 66.6667 20 46.86628 60 19.05712 50 57.1429 16.6667 34.66666 50 14.2857 33.3333 50 7.6923 33.3333 50 6.25 25 50 75 25 50 66.6667 20 50 2.589188 20 50 66.6667 20 46.86628 60 11.1111 38.4615 50 10 33.3333 50 3.308304 33.3333 50 80 33.3333 50 6.25 25 50 71.14288 25 50 66.6667 16.6667 50 50 14.2857 50 50 12.5 33.3333 50 5.8824 38.4615 50 10 33.3333 50 3.308304 26.83638 50 20 50 66.6667 11.1111 40 50 11.1111 33.3333 50 4.053344 33.3333 50 8.3333 25 50 7.1429 25 50 75 25 50 66.6667 16.6667 50 50 14.2857 33.3333 50 7.6923 50 65.50002 11.1111 40 50 11.1111 33.3333 50 4.053344 33.3333 50 2.589188 20 50 66.6667 20 50 60 25 50 66.6667 16.6667 50 50 14.2857 33.3333 50 7.6923 33.3333 50 6.25 33.3333 50 4.5455 25 50 66.6667 33.3333 50 2.589188 20 50 66.6667 20 40 60 16.6667 38.4615 55.32568 10 33.3333 50 8.3333 26.83638 50 75.23077 33.3333 50 6.25 25 50 4.5455 25 50 66.6667 20 50 66.6667 14.2857 50 50)
	elif [ "$2" == "passable" ]
	then
		echo "Simulating passable experiences. - p50"
        # recalcualted from akamai based on p50 = 150 ms rtt
        lat_array=(38.3810 61.7170 113.2996 414.5523 58.5946 96.6083 330.6039 55.7558 95.2853 184.0018 55.5572 91.8864 166.7355 53.7330 78.2041 151.6962 1021.8746 86.6540 140.7578 51.0196 70.6604 129.2911 666.8315 80.9394 123.7588 46.1644 79.8781 118.4526 34.1866 61.7170 113.2996 414.5523 58.5946 96.6083 330.6039 57.4205 106.0543 309.8415 56.6023 91.8864 263.4105 56.3655 87.7458 218.2543 51.8797 86.6540 140.7578 50.3674 70.6604 129.2911 666.8315 67.6840 104.1890 523.8035 63.1364 118.4526 34.1866 61.7170 113.2996 383.4393 58.5946 96.6083 330.6039 55.7558 93.2760 175.4917 55.4438 80.9394 166.7355 38.3810 78.2041 151.6962 1021.8746 86.6540 140.7578 50.3674 70.6604 129.2911 617.3050 65.7768 104.1890 523.8035 56.4768 100.6723 227.0175 56.1244 98.7864 218.2543 55.9968 84.8950 198.5647 49.4145 93.2760 175.4917 55.4438 79.8781 166.7355 38.3810 76.3529 116.0860 58.5946 97.5896 383.4393 55.7558 95.2853 193.2663 55.5572 82.8211 175.4917 42.8328 89.3049 151.6962 52.6645 74.3854 143.9554 51.0196 70.6604 134.0648 666.8315 67.6840 106.0543 581.4396 56.4768 101.9315 247.4467 56.3655 87.7458 227.0175 51.8797 97.5896 359.4999 55.7558 95.2853 193.2663 55.5572 80.9394 166.7355 42.8328 78.2041 118.4526 34.1866 60.0821 112.1780 383.4393 57.9182 110.8422 330.6039 67.6840 106.0543 581.4396 56.4768 100.6723 247.4467 56.3655 87.7458 218.2543 51.8797 85.9138 140.7578 50.3674 83.9938 126.2190 46.1644 65.7768 123.7588 470.1748 78.2041 118.4526 34.1866 60.0821 112.1780 383.4393 57.9182 95.2853 330.6039 56.7278 93.2760 282.6996 55.4438 90.3323 156.9074 52.6645 76.3529 143.9554 907.8873 85.9138 134.0648 50.3674 69.2119 126.2190 46.1644 65.7768 120.8788 470.1748 63.1364 100.6723 445.3803 56.2542 98.7864 210.3036)
        # recalculated from akamai based on p50 = 2.85 Mbit
		thru_array=(1099.4898 2516.8785 3343.0434 4103.4830 2507.2828 2803.5133 3415.3731 1712.8906 2776.9121 3394.6337 1708.7696 2765.8077 3394.6337 1684.6773 2673.1195 3394.6337 7480.0625 2762.1057 3394.6337 1671.5217 2641.4174 3358.0046 4490.4094 2708.2267 3343.0434 1552.4258 2673.6482 3343.0434 550.0674 2516.8785 3343.0434 4103.4830 2507.2828 2803.5133 3415.3731 2414.0076 3343.0434 3402.6821 1935.9732 2765.8077 3394.6337 1846.9286 2763.9564 3394.6337 1671.5217 2762.1057 3394.6337 1671.5217 2641.4174 3358.0046 4490.4094 2641.4174 3343.0434 4180.9840 2525.0748 3343.0434 550.0674 2516.8785 3343.0434 3794.6637 2507.2828 2803.5133 3415.3731 1712.8906 2771.3599 3394.6337 1702.4241 2708.2267 3394.6337 1099.4898 2673.1195 3394.6337 7480.0625 2762.1057 3394.6337 1671.5217 2641.4174 3358.0046 4194.7330 2608.3158 3343.0434 4180.9840 1886.5884 3323.6197 3394.6337 1756.8134 2925.4341 3394.6337 1713.4193 2760.0747 3394.6337 1671.5217 2771.3599 3394.6337 1702.4241 2673.6482 3394.6337 1099.4898 2672.5902 3343.0434 2507.2828 2836.0348 3794.6637 1712.8906 2776.9121 3394.6337 1708.7696 2743.6562 3394.6337 1416.7890 2764.5886 3394.6337 1674.1010 2664.9423 3394.6337 1671.5217 2641.4174 3379.1565 4490.4094 2641.4174 3343.0434 4187.8588 1886.5884 3343.0434 3394.6337 1846.9286 2763.9564 3394.6337 1671.5217 2836.0348 3485.8451 1712.8906 2776.9121 3394.6337 1708.7696 2708.2267 3394.6337 1416.7890 2673.1195 3343.0434 550.0674 2508.6823 3343.0434 3794.6637 2507.2828 3343.0434 3415.3731 2641.4174 3343.0434 4187.8588 1886.5884 3323.6197 3394.6337 1846.9286 2763.9564 3394.6337 1671.5217 2760.2550 3394.6337 1671.5217 2760.0747 3343.0434 1552.4258 2608.3158 3343.0434 4178.8045 2673.1195 3343.0434 550.0674 2508.6823 3343.0434 3794.6637 2507.2828 2776.9121 3415.3731 2174.9901 2771.3599 3394.6337 1702.4241 2764.5886 3394.6337 1674.1010 2672.5902 3394.6337 5766.7501 2760.2550 3379.1565 1671.5217 2641.4174 3343.0434 1552.4258 2608.3158 3343.0434 4178.8045 2525.0748 3323.6197 4178.8045 1803.6120 2925.4341 3394.6337)
		gap_array=(0.07 0.28 0.56 1.946 0.28 0.42 1.54 0.21 0.42 0.84 0.21 0.42 0.77 0.1568 0.35 0.7 6.9146 0.35 0.7 0.14 0.28 0.63 3.6484 0.35 0.63 0.14 0.35 0.56 0.07 0.28 0.56 1.946 0.28 0.42 1.54 0.26 0.49 1.4 0.21 0.42 1.19 0.21 0.35 1.05 0.14 0.35 0.7 0.14 0.28 0.63 3.6484 0.28 0.49 2.4822 0.28 0.56 0.07 0.28 0.56 1.82 0.28 0.42 1.54 0.21 0.42 0.77 0.21 0.35 0.77 0.07 0.35 0.7 6.9146 0.35 0.7 0.14 0.28 0.63 3.143 0.28 0.49 2.4822 0.21 0.49 1.05 0.21 0.42 1.05 0.21 0.35 0.91 0.14 0.42 0.77 0.21 0.35 0.77 0.07 0.2856 0.56 0.28 0.42 1.82 0.21 0.42 0.91 0.21 0.35 0.77 0.14 0.42 0.7 0.14 0.28 0.7 0.14 0.28 0.63 3.6484 0.28 0.49 2.7776 0.21 0.49 1.12 0.21 0.35 1.05 0.14 0.42 1.68 0.21 0.42 0.91 0.21 0.35 0.77 0.14 0.35 0.56 0.07 0.28 0.56 1.82 0.28 0.49 1.54 0.28 0.49 2.7776 0.21 0.49 1.12 0.21 0.35 1.05 0.14 0.35 0.7 0.14 0.35 0.63 0.14 0.28 0.63 2.31 0.35 0.56 0.07 0.28 0.56 1.82 0.28 0.42 1.54 0.21 0.42 1.26 0.21 0.42 0.77 0.14 0.2856 0.7 5.1884 0.35 0.63 0.14 0.28 0.63 0.14 0.28 0.56 2.31 0.28 0.49 2.1 0.21 0.42 0.98)
		loss_array=(0 3.4345 25 50 75 20 50 71.4286 12.5 50 66.6667 11.1111 50 66.6667 9.0909 33.3333 62.5 83.3333 39.6923 55.5556 7.1429 33.3333 50 80.82522 33.3333 50 4.5455 33.3333 50 2.7027 25 50 75 20 50 71.4286 20 50 71.4286 16.6667 50 66.6667 16.6667 50 66.6667 7.6923 39.6923 55.5556 6.283336 33.3333 50 80.82522 25 50 78.85383 25 50 2.7027 25 50 75 20 50 71.4286 12.5 50 66.6667 11.1111 33.3333 66.6667 3.4345 33.3333 62.5 83.3333 39.6923 55.5556 6.283336 33.3333 50 80 25 50 78.85383 16.6667 50 66.6667 14.2857 50 66.6667 14.2857 33.3333 66.6667 5.8824 50 66.6667 11.1111 33.3333 66.6667 3.4345 33.3333 50 20 50 75 12.5 50 66.6667 11.1111 33.3333 66.6667 4.1667 50 62.5 9.0909 33.3333 60 7.1429 33.3333 50 80.82522 25 50 80 16.6667 50 66.6667 16.6667 50 66.6667 7.6923 50 75 12.5 50 66.6667 11.1111 33.3333 66.6667 4.1667 33.3333 50 2.7027 20 50 75 20 50 71.4286 25 50 80 16.6667 50 66.6667 16.6667 50 66.6667 7.6923 34.23899 55.5556 6.283336 33.3333 50 4.5455 25 50 75 33.3333 50 2.7027 20 50 75 20 50 71.4286 20 50 71.4286 11.1111 50 66.6667 9.0909 33.3333 60 83.3333 34.23899 50 6.283336 25 50 4.5455 25 50 75 25 50 75 14.2857 50 66.6667)
	elif [ "$2" == "poor" ]
	then
		echo "Simulating poor experiences. - p75"
        # recalcualted from akamai based on p25 = 200 ms rtt
        lat_array=(44.8391 77.8441 151.1225 538.6553 74.1574 122.3679 448.9750 68.3002 121.2717 258.1822 68.0250 117.9229 238.3974 64.3807 98.3880 214.5810 1254.3138 110.1420 196.2128 61.3587 90.3930 177.4877 873.1689 102.3224 168.2904 52.1673 99.9418 158.4287 41.0327 77.8441 151.1225 538.6553 74.1574 122.3679 448.9750 71.1660 137.9538 425.3444 69.5666 117.9229 372.4741 69.1998 111.6461 315.9656 62.4834 110.1420 196.2128 59.2902 90.3930 177.4877 873.1689 86.0813 136.1647 684.2171 79.5511 158.4287 41.0327 77.8441 151.1225 506.6281 74.1574 122.3679 448.9750 68.3002 119.6424 246.0214 67.3725 102.3224 238.3974 44.8391 98.3880 214.5810 1254.3138 110.1420 196.2128 59.2902 90.3930 177.4877 779.5461 84.2470 136.1647 684.2171 69.3912 131.1584 332.8509 68.8824 125.6892 315.9656 68.6952 106.7104 277.6963 58.2907 119.6424 246.0214 67.3725 99.9418 238.3974 44.8391 97.2138 154.4160 74.1574 123.7766 506.6281 68.3002 121.2717 266.0794 68.0250 103.7736 246.0214 49.4560 113.6370 214.5810 63.3708 95.0130 205.8705 61.3587 90.3930 190.0741 873.1689 86.0813 137.9538 723.6660 69.3912 134.6746 350.1771 69.1998 111.6461 332.8509 62.4834 123.7766 472.8206 68.3002 121.2717 266.0794 68.0250 102.3224 238.3974 49.4560 98.3880 158.4287 41.0327 76.1546 147.7900 506.6281 72.1926 144.5261 448.9750 86.0813 137.9538 723.6660 69.3912 131.1584 350.1771 69.1998 111.6461 315.9656 62.4834 108.4556 196.2128 59.2902 105.2603 173.4390 52.1673 84.2470 168.2904 604.9535 98.3880 158.4287 41.0327 76.1546 147.7900 506.6281 72.1926 121.2717 448.9750 70.4133 119.6424 399.0377 67.3725 115.6592 225.6968 63.3708 97.2138 205.8705 1114.1582 108.4556 190.0741 59.2902 87.4033 173.4390 52.1673 84.2470 162.6072 604.9535 79.5511 131.1584 564.6930 69.0707 125.6892 295.7026)
        # recalculated from akamai based on p25 = 1.6 Mbit
        thru_array=(140.6254 1714.3713 1733.1250 2221.4550 1706.7862 1733.1250 2195.0631 1102.2991 1733.1250 1733.1250 905.9134 1733.1250 1733.1250 493.1241 1733.1250 1733.1250 3334.7378 1733.1250 1733.1250 321.6554 1733.1250 1733.1250 2582.4088 1733.1250 1733.1250 265.6054 1733.1250 1733.1250 70.9712 1714.3713 1733.1250 2221.4550 1706.7862 1733.1250 2195.0631 1706.7862 1733.1250 2179.9450 1706.7862 1733.1250 2101.0325 1706.7862 1733.1250 1811.4322 325.9750 1733.1250 1733.1250 318.7054 1733.1250 1733.1250 2582.4088 1733.1250 1733.1250 2223.0362 1720.8506 1733.1250 70.9712 1714.3713 1733.1250 2214.9756 1706.7862 1733.1250 2195.0631 1102.2991 1733.1250 1733.1250 764.4451 1733.1250 1733.1250 140.6254 1733.1250 1733.1250 3334.7378 1733.1250 1733.1250 318.7054 1733.1250 1733.1250 2223.0362 1730.0700 1733.1250 2223.0362 1706.7862 1733.1250 1933.4619 1706.7862 1733.1250 1811.4322 1685.4506 1733.1250 1739.2881 318.7054 1733.1250 1733.1250 764.4451 1733.1250 1733.1250 140.6254 1733.1250 1733.1250 1706.7862 1733.1250 2214.9756 1102.2991 1733.1250 1733.1250 905.9134 1733.1250 1733.1250 205.1304 1733.1250 1733.1250 361.3750 1733.1250 1733.1250 321.6554 1733.1250 1733.1250 2582.4088 1733.1250 1733.1250 2223.0362 1706.7862 1733.1250 2050.2760 1706.7862 1733.1250 1933.4619 325.9750 1733.1250 2208.4963 1102.2991 1733.1250 1733.1250 905.9134 1733.1250 1733.1250 205.1304 1733.1250 1733.1250 70.9712 1707.8919 1733.1250 2214.9756 1706.7862 1733.1250 2195.0631 1733.1250 1733.1250 2223.0362 1706.7862 1733.1250 2050.2760 1706.7862 1733.1250 1811.4322 325.9750 1733.1250 1733.1250 318.7054 1733.1250 1733.1250 265.6054 1730.0700 1733.1250 2223.0362 1733.1250 1733.1250 70.9712 1707.8919 1733.1250 2214.9756 1706.7862 1733.1250 2195.0631 1706.7862 1733.1250 2151.7878 764.4451 1733.1250 1733.1250 361.3750 1733.1250 1733.1250 3255.9044 1733.1250 1733.1250 318.7054 1733.1250 1733.1250 265.6054 1730.0700 1733.1250 2223.0362 1720.8506 1733.1250 2223.0362 1706.7862 1733.1250 1745.7675)
		gap_array=(0.07 0.28 0.49 1.82 0.21 0.42 1.33 0.21 0.42 0.77 0.14 0.35 0.7 0.14 0.28 0.7 6.9167 0.35 0.63 0.14 0.28 0.63 3.22 0.28 0.56 0.07 0.28 0.56 0.07 0.28 0.49 1.82 0.21 0.42 1.33 0.21 0.49 1.26 0.21 0.35 1.12 0.21 0.35 0.98 0.14 0.35 0.63 0.14 0.28 0.63 3.22 0.28 0.42 2.3569 0.28 0.56 0.07 0.28 0.49 1.6737 0.21 0.42 1.33 0.21 0.42 0.77 0.14 0.28 0.7 0.07 0.28 0.7 6.9167 0.35 0.63 0.14 0.28 0.63 2.87 0.28 0.42 2.3569 0.21 0.42 0.98 0.21 0.42 0.98 0.21 0.35 0.84 0.14 0.42 0.77 0.14 0.28 0.7 0.07 0.28 0.5332 0.21 0.42 1.6737 0.21 0.42 0.84 0.14 0.35 0.77 0.07 0.35 0.7 0.14 0.28 0.63 0.14 0.28 0.63 3.22 0.28 0.49 2.5802 0.21 0.42 1.05 0.21 0.35 0.98 0.14 0.42 1.54 0.21 0.42 0.84 0.14 0.28 0.7 0.07 0.28 0.56 0.07 0.24 0.49 1.6737 0.21 0.49 1.33 0.28 0.49 2.5802 0.21 0.42 1.05 0.21 0.35 0.98 0.14 0.35 0.63 0.14 0.35 0.56 0.07 0.28 0.56 2.1 0.28 0.56 0.07 0.24 0.49 1.6737 0.21 0.42 1.33 0.21 0.42 1.1475 0.14 0.35 0.7 0.14 0.28 0.63 4.97 0.35 0.63 0.14 0.28 0.56 0.07 0.28 0.56 2.1 0.28 0.42 1.89 0.21 0.42 0.91)
		loss_array=(3.4483 25 50 83.3333 20 50 81.51371 12.5 50 71.4286 12.5 50 66.6667 9.208416 33.3333 66.6667 85.7143 50 66.6667 7.6923 33.3333 66.6667 83.3333 33.3333 66.6667 4.709964 33.3333 59.33332 2.735744 25 50 83.3333 20 50 81.51371 20 50 80 16.6667 50 80 16.6667 50 75 8.3333 50 66.6667 6.704796 33.3333 66.6667 83.3333 25 50 83.3333 25 59.33332 2.735744 25 50 83.3333 20 50 81.51371 12.5 50 71.4286 11.1111 33.3333 66.6667 3.4483 33.3333 66.6667 85.7143 50 66.6667 6.704796 33.3333 66.6667 83.3333 25 50 83.3333 16.6667 50 75 14.2857 50 75 14.2857 33.3333 75 6.117664 50 71.4286 11.1111 33.3333 66.6667 3.4483 33.3333 50 20 50 83.3333 12.5 50 75 12.5 33.3333 71.4286 4.287916 50 66.6667 9.0909 33.3333 66.6667 7.6923 33.3333 66.6667 83.3333 25 50 83.3333 16.6667 50 80 16.6667 50 75 8.3333 50 83.3333 12.5 50 75 12.5 33.3333 66.6667 4.287916 33.3333 59.33332 2.735744 20 50 83.3333 20 50 81.51371 25 50 83.3333 16.6667 50 80 16.6667 50 75 8.3333 40.83077 66.6667 6.704796 33.3333 66.6667 4.709964 25 66.6667 83.3333 33.3333 59.33332 2.735744 20 50 83.3333 20 50 81.51371 20 50 80 11.1111 50 66.6667 9.0909 33.3333 66.6667 85.7143 40.83077 66.6667 6.704796 26.71699 66.6667 4.709964 25 62.5 83.3333 25 50 83.3333 16.6667 50 75)
	elif [ "$2" == "verypoor" ]
	then
		echo "Simulating very poor experiences. - p90"
        # recalcualted from akamai based on p25 = 250 ms rtt
        lat_array=(55.1469 95.7847 187.9202 669.9826 91.3198 151.1431 566.7615 84.0014 149.6814 322.1179 83.6629 145.5350 299.5786 79.1809 121.2199 273.2964 1542.6618 135.6332 246.1890 75.4641 112.1137 225.3818 1088.7806 125.8919 209.9969 64.1598 123.4305 197.6889 50.4655 95.7847 187.9202 669.9826 91.3198 151.1431 566.7615 87.5551 171.1294 532.3960 85.6000 145.5350 471.2751 85.1078 137.6876 401.7850 76.8474 135.6332 246.1890 72.9201 112.1137 225.3818 1088.7806 106.0524 168.3709 854.7879 97.9457 197.6889 50.4655 95.7847 187.9202 636.6770 91.3198 151.1431 566.7615 84.0014 147.6386 311.2433 82.8604 125.8919 299.5786 55.1469 121.2199 273.2964 1542.6618 135.6332 246.1890 72.9201 112.1137 225.3818 959.8521 104.1628 168.3709 854.7879 85.3432 162.0964 420.7112 84.7175 156.3167 401.7850 84.4872 131.3001 357.6145 71.6909 147.6386 311.2433 82.8604 123.4305 299.5786 55.1469 119.7334 192.3689 91.3198 152.8187 636.6770 84.0014 149.6814 339.0162 83.6629 127.6827 311.2433 60.8252 140.0647 273.2964 77.9388 117.1359 257.6697 75.4641 112.1137 236.8124 1088.7806 106.0524 171.1294 891.5933 85.3432 166.6837 445.1114 85.1078 137.6876 420.7112 76.8474 152.8187 600.7930 84.0014 149.6814 339.0162 83.6629 125.8919 299.5786 60.8252 121.2199 197.6889 50.4655 93.7684 184.0323 636.6770 88.7886 179.6560 566.7615 106.0524 171.1294 891.5933 85.3432 162.0964 445.1114 85.1078 137.6876 401.7850 76.8474 133.4093 246.1890 72.9201 129.5453 215.4732 64.1598 104.1628 209.9969 758.1130 121.2199 197.6889 50.4655 93.7684 184.0323 636.6770 88.7886 149.6814 566.7615 86.6456 147.6386 500.6680 82.8604 142.7688 282.6572 77.9388 119.7334 257.6697 1370.2865 133.4093 236.8124 72.9201 107.9442 215.4732 64.1598 104.1628 202.3516 758.1130 97.9457 162.0964 703.0756 84.9490 156.3167 384.0786)
        # recalcualted from akamai based on p25 = 1.35 Mbit
        thru_array=(2.8751 542.1099 961.9176 3726.0011 442.7500 718.7501 3726.0011 378.0625 718.7501 3146.1976 314.6976 718.7501 2336.6564 146.6249 695.7500 2154.5824 3726.0011 710.8439 1461.4774 72.1050 695.7500 1258.2724 3726.0011 695.7500 1173.6326 2.8751 695.7500 1081.1439 2.8751 542.1099 961.9176 3726.0011 442.7500 718.7501 3726.0011 439.5300 771.7938 3726.0011 423.0276 718.7501 3726.0011 422.6250 716.7375 3726.0011 114.5399 710.8439 1461.4774 37.8926 695.7500 1258.2724 3726.0011 695.7500 741.7499 3726.0011 626.9799 1081.1439 2.8751 542.1099 961.9176 3726.0011 442.7500 718.7501 3726.0011 378.0625 718.7501 2593.3648 221.5762 695.7500 2336.6564 2.8751 695.7500 2154.5824 3726.0011 710.8439 1461.4774 37.8926 695.7500 1258.2724 3726.0011 682.4100 741.7499 3726.0011 422.6250 740.8300 3726.0011 410.1476 721.9701 3726.0011 401.6376 701.1839 3726.0011 21.3901 718.7501 2593.3648 221.5762 695.7500 2336.6564 2.8751 695.7500 1013.9551 442.7500 718.7501 3726.0011 378.0625 718.7501 3699.0330 314.6976 695.7500 2593.3648 2.8751 718.7501 2154.5824 146.6249 695.7500 1808.0300 72.1050 695.7500 1321.9249 3726.0011 695.7500 771.7938 3726.0011 422.6250 741.7499 3726.0011 422.6250 716.7375 3726.0011 114.5399 718.7501 3726.0011 378.0625 718.7501 3699.0330 314.6976 695.7500 2336.6564 2.8751 695.7500 1081.1439 2.8751 457.2400 931.2701 3726.0011 442.7500 900.6227 3726.0011 695.7500 771.7938 3726.0011 422.6250 740.8300 3726.0011 422.6250 716.7375 3726.0011 114.5399 704.9500 1461.4774 37.8926 697.6475 1204.2800 2.8751 682.4100 1173.6326 3726.0011 695.7500 1081.1439 2.8751 457.2400 931.2701 3726.0011 442.7500 718.7501 3726.0011 431.2788 718.7501 3726.0011 221.5762 718.7501 2269.4676 146.6249 695.7500 1808.0300 3726.0011 704.9500 1321.9249 37.8926 695.7500 1204.2800 2.8751 682.4100 1142.9851 3726.0011 626.9799 740.8300 3726.0011 418.3988 721.9701 3726.0011)
		gap_array=(0.07 0.21 0.49 1.61 0.21 0.35 1.19 0.14 0.35 0.7 0.14 0.35 0.7 0.14 0.28 0.63 6.8201 0.35 0.63 0.07 0.28 0.56 2.94 0.28 0.56 0.07 0.28 0.49 0.07 0.21 0.49 1.61 0.21 0.35 1.19 0.21 0.42 1.12 0.21 0.35 0.98 0.21 0.35 0.84 0.07 0.35 0.63 0.07 0.28 0.56 2.94 0.28 0.42 2.1 0.21 0.49 0.07 0.21 0.49 1.47 0.21 0.35 1.19 0.14 0.35 0.7 0.14 0.28 0.7 0.07 0.28 0.63 6.8201 0.35 0.63 0.07 0.28 0.56 2.66 0.28 0.42 2.1 0.21 0.42 0.91 0.21 0.42 0.84 0.14 0.3417 0.77 0.07 0.35 0.7 0.14 0.28 0.7 0.07 0.28 0.49 0.21 0.42 1.47 0.14 0.35 0.77 0.14 0.28 0.7 0.07 0.35 0.63 0.14 0.28 0.63 0.07 0.28 0.56 2.94 0.28 0.42 2.38 0.21 0.42 0.98 0.21 0.35 0.91 0.07 0.42 1.33 0.14 0.35 0.77 0.14 0.28 0.7 0.07 0.28 0.49 0.07 0.21 0.49 1.47 0.21 0.49 1.19 0.28 0.42 2.38 0.21 0.42 0.98 0.21 0.35 0.84 0.07 0.35 0.63 0.07 0.28 0.56 0.07 0.28 0.56 1.89 0.28 0.49 0.07 0.21 0.49 1.47 0.21 0.35 1.19 0.21 0.35 1.05 0.14 0.35 0.63 0.14 0.28 0.63 4.6802 0.35 0.56 0.07 0.28 0.56 0.07 0.28 0.49 1.89 0.21 0.42 1.7703 0.21 0.42 0.84)
		loss_array=(3.4483 25 50 83.3333 20 50 83.3333 12.5 50 75 12.5 50 75 9.854544 33.3333 66.6667 90.9091 50 66.6667 7.6923 33.3333 66.6667 88.8889 33.3333 66.6667 4.709964 33.3333 62.5 2.735744 25 50 83.3333 20 50 83.3333 20 50 83.3333 20 50 83.3333 16.6667 50 80 8.3333 50 66.6667 6.704796 33.3333 66.6667 88.8889 25 50 85.7143 25 62.5 2.735744 25 50 83.3333 20 50 83.3333 12.5 50 75 11.1111 33.3333 75 3.4483 33.3333 66.6667 90.9091 50 66.6667 6.704796 33.3333 66.6667 85.7143 25 50 85.7143 16.6667 50 80 14.2857 50 80 14.2857 37.16666 75 6.117664 50 75 11.1111 33.3333 75 3.4483 33.3333 55.80957 20 50 83.3333 12.5 50 75 12.5 33.3333 75 4.287916 50 66.6667 9.0909 33.3333 66.6667 7.6923 33.3333 66.6667 88.8889 25 50 85.7143 16.6667 50 83.3333 16.6667 50 80 8.3333 50 83.3333 12.5 50 75 12.5 33.3333 75 4.287916 33.3333 62.5 2.735744 20.7333 50 83.3333 20 50 83.3333 25 50 85.7143 16.6667 50 83.3333 16.6667 50 80 8.3333 50 66.6667 6.704796 33.3333 66.6667 4.709964 25 66.6667 84.47618 33.3333 62.5 2.735744 20.7333 50 83.3333 20 50 83.3333 20 50 83.3333 11.1111 50 71.4286 9.0909 33.3333 66.6667 90.10909 50 66.6667 6.704796 28.87905 66.6667 4.709964 25 66.6667 84.47618 25 50 83.3333 16.6667 50 80)
	else
		echo "Please select a valid network experience to simulate. Valid values are noloss, good, fair, passable, poor, and verypoor."
		exit 1	
	fi
elif [ "$1" == "mgst_brazil_wifi" ]
then
	if [ "$2" == "noloss" ]
	then
		echo "Simulating no loss experiences."
        lat_array=(6.119046 9.154522 13.084045 45.638087 8.976189 11.754879 35.414220 7.599105 11.732140 20.289103 7.516189 11.672617 18.308032 7.262260 10.535712 17.583925 200.077289 11.341962 16.278092 6.982856 10.046546 15.265354 104.638911 10.758331 14.612021 6.356665 10.642736 13.538688 6.022201 9.154522 13.084045 45.638087 8.976189 11.754879 35.414220 8.787736 11.986664 32.174875 8.491189 11.672617 26.492019 8.132736 11.535355 23.177436 7.107141 11.341962 16.278092 6.833332 10.046546 15.265354 104.638911 9.763927 11.904760 70.231119 9.283748 13.538688 6.022201 9.154522 13.084045 41.564100 8.976189 11.754879 35.414220 7.599105 11.708331 19.398806 7.424582 10.758331 18.308032 6.119046 10.535712 17.583925 200.077289 11.341962 16.278092 6.833332 10.046546 15.265354 92.345223 9.563272 11.904760 70.231119 8.281070 11.865831 23.992853 7.845236 11.815474 23.177436 7.741070 11.110891 21.182020 6.665237 11.708331 19.398806 7.424582 10.642736 18.308032 6.119046 10.451426 13.296069 8.976189 11.785712 41.564100 7.599105 11.732140 20.734758 7.516189 10.876843 19.398806 6.255713 11.620652 17.583925 7.190475 10.363093 16.939044 6.982856 10.046546 15.686307 104.638911 9.763927 11.986664 83.063081 8.281070 11.883926 25.057079 8.132736 11.535355 23.992853 7.107141 11.785712 37.991303 7.599105 11.732140 20.734758 7.516189 10.758331 18.308032 6.255713 10.535712 13.538688 6.022201 9.042081 12.612617 41.564100 8.879462 12.318628 35.414220 9.763927 11.986664 83.063081 8.281070 11.865831 25.057079 8.132736 11.535355 23.177436 7.107141 11.227141 16.278092 6.833332 10.976188 14.811069 6.356665 9.563272 14.612021 59.501300 10.535712 13.538688 6.022201 9.042081 12.612617 41.564100 8.879462 11.732140 35.414220 8.639879 11.708331 28.399697 7.424582 11.648807 17.917735 7.190475 10.451426 16.939044 157.730689 11.227141 15.686307 6.833332 9.920355 14.811069 6.356665 9.563272 13.980950 59.501300 9.283748 11.865831 52.745646 7.976189 11.815474 22.055948 )
        thru_array=(600.7359 9962.4053 11341.2429 12652.2353 9772.2426 10992.8574 12467.8502 6975.9351 10975.9869 11863.5058 6843.4671 10822.2723 11564.8926 6552.8401 10269.5000 11432.5721 14939.2926 10553.1426 11432.5721 6202.1229 10133.8400 11399.3282 14146.0974 10269.5000 11385.7500 2820.9026 10269.5000 11376.3093 312.1581 9962.4053 11341.2429 12652.2353 9772.2426 10992.8574 12467.8502 9626.1600 11245.7398 12425.4239 9382.4447 10822.2723 12350.0684 9262.5000 10553.1426 12138.3126 6304.4356 10553.1426 11432.5721 5854.8606 10133.8400 11399.3282 14146.0974 10116.0347 11225.6180 12922.4092 10081.4821 11376.3093 312.1581 9962.4053 11341.2429 12583.7958 9772.2426 10992.8574 12467.8502 6975.9351 10899.1296 11680.4400 6773.4970 10269.5000 11564.8926 600.7359 10269.5000 11432.5721 14939.2926 10553.1426 11432.5721 5854.8606 10133.8400 11399.3282 13999.0982 10113.4279 11225.6180 12922.4092 9320.9258 11155.7147 12228.4547 8143.5079 11016.6074 12138.3126 7457.5243 10448.1942 12069.7910 4980.0155 10899.1296 11680.4400 6773.4970 10269.5000 11564.8926 600.7359 10269.5000 11365.2498 9772.2426 10992.8574 12583.7958 6975.9351 10975.9869 12046.5700 6843.4671 10269.5000 11680.4400 1479.7709 10621.2523 11432.5721 6415.3333 10237.2547 11432.5721 6202.1229 10133.8400 11418.5242 14146.0974 10116.0347 11245.7398 13460.7537 9320.9258 11192.4410 12314.5962 9262.5000 10553.1426 12228.4547 6304.4356 10992.8574 12515.3547 6975.9351 10975.9869 12046.5700 6843.4671 10269.5000 11564.8926 1479.7709 10269.5000 11376.3093 312.1581 9843.3300 11298.9534 12583.7958 9711.0353 11256.6655 12467.8502 10116.0347 11245.7398 13460.7537 9320.9258 11155.7147 12314.5962 9262.5000 10553.1426 12138.3126 6304.4356 10553.1426 11432.5721 5854.8606 10331.9021 11385.7500 2820.9026 10113.4279 11385.7500 12728.5347 10269.5000 11376.3093 312.1581 9843.3300 11298.9534 12583.7958 9711.0353 10975.9869 12467.8502 9504.3016 10899.1296 12385.5406 6773.4970 10724.6792 11492.5574 6415.3333 10269.5000 11432.5721 14488.5853 10553.1426 11418.5242 5854.8606 10124.9374 11385.7500 2820.9026 10113.4279 11385.7500 12728.5347 10081.4821 11155.7147 12694.5916 8864.6400 11016.6074 12084.8147)
		gap_array=(99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999)
		loss_array=(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 )
	elif [ "$2" == "good" ]
	then
		echo "Simulating good experiences. - p10"
        lat_array=(6.119046 9.154522 13.084045 45.638087 8.976189 11.754879 35.414220 7.599105 11.732140 20.289103 7.516189 11.672617 18.308032 7.262260 10.535712 17.583925 200.077289 11.341962 16.278092 6.982856 10.046546 15.265354 104.638911 10.758331 14.612021 6.356665 10.642736 13.538688 6.022201 9.154522 13.084045 45.638087 8.976189 11.754879 35.414220 8.787736 11.986664 32.174875 8.491189 11.672617 26.492019 8.132736 11.535355 23.177436 7.107141 11.341962 16.278092 6.833332 10.046546 15.265354 104.638911 9.763927 11.904760 70.231119 9.283748 13.538688 6.022201 9.154522 13.084045 41.564100 8.976189 11.754879 35.414220 7.599105 11.708331 19.398806 7.424582 10.758331 18.308032 6.119046 10.535712 17.583925 200.077289 11.341962 16.278092 6.833332 10.046546 15.265354 92.345223 9.563272 11.904760 70.231119 8.281070 11.865831 23.992853 7.845236 11.815474 23.177436 7.741070 11.110891 21.182020 6.665237 11.708331 19.398806 7.424582 10.642736 18.308032 6.119046 10.451426 13.296069 8.976189 11.785712 41.564100 7.599105 11.732140 20.734758 7.516189 10.876843 19.398806 6.255713 11.620652 17.583925 7.190475 10.363093 16.939044 6.982856 10.046546 15.686307 104.638911 9.763927 11.986664 83.063081 8.281070 11.883926 25.057079 8.132736 11.535355 23.992853 7.107141 11.785712 37.991303 7.599105 11.732140 20.734758 7.516189 10.758331 18.308032 6.255713 10.535712 13.538688 6.022201 9.042081 12.612617 41.564100 8.879462 12.318628 35.414220 9.763927 11.986664 83.063081 8.281070 11.865831 25.057079 8.132736 11.535355 23.177436 7.107141 11.227141 16.278092 6.833332 10.976188 14.811069 6.356665 9.563272 14.612021 59.501300 10.535712 13.538688 6.022201 9.042081 12.612617 41.564100 8.879462 11.732140 35.414220 8.639879 11.708331 28.399697 7.424582 11.648807 17.917735 7.190475 10.451426 16.939044 157.730689 11.227141 15.686307 6.833332 9.920355 14.811069 6.356665 9.563272 13.980950 59.501300 9.283748 11.865831 52.745646 7.976189 11.815474 22.055948 )
        thru_array=(600.7359 9962.4053 11341.2429 12652.2353 9772.2426 10992.8574 12467.8502 6975.9351 10975.9869 11863.5058 6843.4671 10822.2723 11564.8926 6552.8401 10269.5000 11432.5721 14939.2926 10553.1426 11432.5721 6202.1229 10133.8400 11399.3282 14146.0974 10269.5000 11385.7500 2820.9026 10269.5000 11376.3093 312.1581 9962.4053 11341.2429 12652.2353 9772.2426 10992.8574 12467.8502 9626.1600 11245.7398 12425.4239 9382.4447 10822.2723 12350.0684 9262.5000 10553.1426 12138.3126 6304.4356 10553.1426 11432.5721 5854.8606 10133.8400 11399.3282 14146.0974 10116.0347 11225.6180 12922.4092 10081.4821 11376.3093 312.1581 9962.4053 11341.2429 12583.7958 9772.2426 10992.8574 12467.8502 6975.9351 10899.1296 11680.4400 6773.4970 10269.5000 11564.8926 600.7359 10269.5000 11432.5721 14939.2926 10553.1426 11432.5721 5854.8606 10133.8400 11399.3282 13999.0982 10113.4279 11225.6180 12922.4092 9320.9258 11155.7147 12228.4547 8143.5079 11016.6074 12138.3126 7457.5243 10448.1942 12069.7910 4980.0155 10899.1296 11680.4400 6773.4970 10269.5000 11564.8926 600.7359 10269.5000 11365.2498 9772.2426 10992.8574 12583.7958 6975.9351 10975.9869 12046.5700 6843.4671 10269.5000 11680.4400 1479.7709 10621.2523 11432.5721 6415.3333 10237.2547 11432.5721 6202.1229 10133.8400 11418.5242 14146.0974 10116.0347 11245.7398 13460.7537 9320.9258 11192.4410 12314.5962 9262.5000 10553.1426 12228.4547 6304.4356 10992.8574 12515.3547 6975.9351 10975.9869 12046.5700 6843.4671 10269.5000 11564.8926 1479.7709 10269.5000 11376.3093 312.1581 9843.3300 11298.9534 12583.7958 9711.0353 11256.6655 12467.8502 10116.0347 11245.7398 13460.7537 9320.9258 11155.7147 12314.5962 9262.5000 10553.1426 12138.3126 6304.4356 10553.1426 11432.5721 5854.8606 10331.9021 11385.7500 2820.9026 10113.4279 11385.7500 12728.5347 10269.5000 11376.3093 312.1581 9843.3300 11298.9534 12583.7958 9711.0353 10975.9869 12467.8502 9504.3016 10899.1296 12385.5406 6773.4970 10724.6792 11492.5574 6415.3333 10269.5000 11432.5721 14488.5853 10553.1426 11418.5242 5854.8606 10124.9374 11385.7500 2820.9026 10113.4279 11385.7500 12728.5347 10081.4821 11155.7147 12694.5916 8864.6400 11016.6074 12084.8147)
		gap_array=(0.14 0.28 0.63 2.52 0.28 0.49 2.03 0.21 0.48 1.05 0.21 0.42 0.98 0.21 0.35 0.91 6.9167 0.42 0.8043 0.14 0.35 0.77 4.13 0.35 0.7 0.14 0.35 0.63 0.07 0.28 0.63 2.52 0.28 0.49 2.03 0.28 0.56 1.89 0.28 0.42 1.75 0.26 0.42 1.3573 0.21 0.42 0.8043 0.14 0.35 0.77 4.13 0.28 0.56 3.22 0.28 0.63 0.07 0.28 0.63 2.38 0.28 0.49 2.03 0.21 0.42 1.05 0.21 0.35 0.98 0.14 0.35 0.91 6.9167 0.42 0.8043 0.14 0.35 0.77 3.99 0.28 0.56 3.22 0.28 0.49 1.47 0.21 0.49 1.3573 0.21 0.42 1.19 0.14 0.42 1.05 0.21 0.35 0.98 0.14 0.35 0.63 0.28 0.49 2.38 0.21 0.48 1.12 0.21 0.35 1.05 0.14 0.42 0.91 0.21 0.35 0.84 0.14 0.35 0.77 4.13 0.28 0.56 3.5602 0.28 0.56 1.61 0.26 0.42 1.47 0.21 0.49 2.17 0.21 0.48 1.12 0.21 0.35 0.98 0.14 0.35 0.63 0.07 0.28 0.63 2.38 0.28 0.56 2.03 0.28 0.56 3.5602 0.28 0.49 1.61 0.26 0.42 1.3573 0.21 0.42 0.8043 0.14 0.35 0.7 0.14 0.28 0.7 2.94 0.35 0.63 0.07 0.28 0.63 2.38 0.28 0.48 2.03 0.28 0.42 1.82 0.21 0.42 0.91 0.21 0.35 0.84 5.46 0.42 0.77 0.14 0.35 0.7 0.14 0.28 0.7 2.94 0.28 0.49 2.73 0.21 0.49 1.26)
		loss_array=(2.838572 16.6667 33.3333 50 16.6667 33.3333 50 9.0909 33.3333 50 9.0909 33.3333 50 7.1429 21.89471 50 73.42858 25 50 5.8824 20 50 66.6667 25 40 3.780248 25 37.5 1.7241 16.6667 33.3333 50 16.6667 33.3333 50 14.2857 33.3333 50 14.2857 33.3333 50 12.5 25 50 6.25 25 50 5.2632 20 50 66.6667 20 33.3333 50 16.6667 37.5 1.7241 16.6667 33.3333 50 16.6667 33.3333 50 9.0909 33.3333 50 8.878772 25 50 2.838572 21.89471 50 73.42858 25 50 5.2632 20 50 59.8919 20 33.3333 50 12.5 33.3333 50 11.1111 33.3333 50 11.1111 25 50 5 33.3333 50 8.878772 25 50 2.838572 20 33.3333 16.6667 33.3333 50 9.0909 33.3333 50 9.0909 25 50 3.3701 26.55441 50 6.6667 20 50 5.8824 20 50 66.6667 20 33.3333 50 12.5 33.3333 50 12.5 25 50 6.25 33.3333 50 9.0909 33.3333 50 9.0909 25 50 3.3701 21.89471 37.5 1.7241 16.6667 33.3333 50 14.2857 33.3333 50 20 33.3333 50 12.5 33.3333 50 12.5 25 50 6.25 25 50 5.2632 25 45.24671 3.780248 20 40 50 21.89471 37.5 1.7241 16.6667 33.3333 50 14.2857 33.3333 50 14.2857 33.3333 50 8.878772 30 50 6.6667 20 50 66.6667 25 50 5.2632 20 45.24671 3.780248 20 40 50 16.6667 33.3333 50 11.1111 33.3333 50)
	elif [ "$2" == "fair" ]
	then
		echo "Simulating fair experiences. - p25"
        lat_array=(8.02374 12.95395 22.28269 81.30600 12.88310 18.74833 58.84226 11.60529 18.34213 30.32330 11.51281 17.70129 28.36700 11.03582 14.16281 26.79632 230.28832 16.19538 25.63876 10.24996 13.31512 24.53264 146.97497 14.70228 23.37796 8.93901 14.47673 22.77138 7.39146 12.95395 22.28269 81.30600 12.88310 18.74833 58.84226 12.82872 20.88639 52.41227 12.75147 17.70129 45.75726 12.38207 16.44224 38.87794 10.50642 16.19538 25.63876 9.93356 13.31512 24.53264 146.97497 13.08218 20.58633 106.75262 12.98264 22.77138 7.39146 12.95395 22.28269 72.01621 12.88310 18.74833 58.84226 11.60529 18.01266 29.22195 11.41477 14.70228 28.36700 8.02374 14.16281 26.79632 230.28832 16.19538 25.63876 9.93356 13.31512 24.53264 134.08291 13.05009 20.58633 106.75262 12.59082 19.83889 40.33804 12.04874 19.34858 38.87794 11.94051 15.55520 33.61819 9.74252 18.01266 29.22195 11.41477 14.47673 28.36700 8.02374 13.86569 22.47478 12.88310 19.12296 72.01621 11.60529 18.34213 31.86267 11.51281 14.93789 29.22195 8.48268 16.95288 26.79632 10.79191 13.62570 26.16646 10.24996 13.31512 25.39158 146.97497 13.08218 20.88639 118.88803 12.59082 20.16294 42.68236 12.38207 16.44224 40.33804 10.50642 19.12296 64.88415 11.60529 18.34213 31.86267 11.51281 14.70228 28.36700 8.48268 14.16281 22.77138 7.39146 12.92127 21.95388 72.01621 12.85918 21.55180 58.84226 13.08218 20.88639 118.88803 12.59082 19.83889 42.68236 12.38207 16.44224 38.87794 10.50642 15.91493 25.63876 9.93356 15.18266 24.07148 8.93901 13.05009 23.37796 99.31487 14.16281 22.77138 7.39146 12.92127 21.95388 72.01621 12.85918 18.34213 58.84226 12.78402 18.01266 48.97797 11.41477 17.29621 27.56839 10.79191 13.86569 26.16646 203.99748 15.91493 25.39158 9.93356 13.18676 24.07148 8.93901 13.05009 22.98314 99.31487 12.98264 19.83889 91.61100 12.21593 19.34858 36.17303 )
        thru_array=(598.89023 9931.79710 11306.39840 12613.36295 9742.21871 10959.08325 12429.54433 6954.50247 10942.26460 11827.05669 6822.44146 10789.02231 11529.36102 6532.70734 10237.94831 11397.44700 14893.39362 10520.71949 11397.44700 6183.06767 10102.70511 11364.30522 14102.63533 10237.94831 11350.76878 2812.23578 10237.94831 11341.35706 311.19907 9931.79710 11306.39840 12613.36295 9742.21871 10959.08325 12429.54433 9596.58489 11211.18870 12387.24843 9353.61839 10789.02231 12312.12443 9234.04218 10520.71949 12101.01927 6285.06605 10520.71949 11397.44700 5836.87235 10102.70511 11364.30522 14102.63533 10084.95453 11191.12876 12882.70679 10050.50805 11341.35706 311.19907 9931.79710 11306.39840 12545.13370 9742.21871 10959.08325 12429.54433 6954.50247 10865.64345 11644.55338 6752.68628 10237.94831 11529.36102 598.89023 10237.94831 11397.44700 14893.39362 10520.71949 11397.44700 5836.87235 10102.70511 11364.30522 13956.08777 10082.35574 11191.12876 12882.70679 9292.28844 11121.44025 12190.88440 8118.48806 10982.76028 12101.01927 7434.61205 10416.09353 12032.70819 4964.71507 10865.64345 11644.55338 6752.68628 10237.94831 11529.36102 598.89023 10237.94831 11330.33152 9742.21871 10959.08325 12545.13370 6954.50247 10942.26460 12009.55849 6822.44146 10237.94831 11644.55338 1475.22451 10588.61991 11397.44700 6395.62301 10205.80210 11397.44700 6183.06767 10102.70511 11383.44232 14102.63533 10084.95453 11211.18870 13419.39728 9292.28844 11158.05365 12276.76118 9234.04218 10520.71949 12190.88440 6285.06605 10959.08325 12476.90293 6954.50247 10942.26460 12009.55849 6822.44146 10237.94831 11529.36102 1475.22451 10237.94831 11341.35706 311.19907 9813.08766 11264.23889 12545.13370 9681.19940 11222.08089 12429.54433 10084.95453 11211.18870 13419.39728 9292.28844 11121.44025 12276.76118 9234.04218 10520.71949 12101.01927 6285.06605 10520.71949 11397.44700 5836.87235 10300.15867 11350.76878 2812.23578 10082.35574 11350.76878 12689.42797 10237.94831 11341.35706 311.19907 9813.08766 11264.23889 12545.13370 9681.19940 10942.26460 12429.54433 9475.10088 10865.64345 12347.48769 6752.68628 10691.72903 11457.24798 6395.62301 10237.94831 11397.44700 14444.07100 10520.71949 11383.44232 5836.87235 10093.82982 11350.76878 2812.23578 10082.35574 11350.76878 12689.42797 10050.50805 11121.44025 12655.58913 8837.40456 10982.76028 12047.68571)
		gap_array=(0.14 0.28 0.56 2.24 0.28 0.42 1.82 0.21 0.42 0.98 0.21 0.42 0.91 0.21 0.35 0.77 6.9167 0.42 0.77 0.14 0.2984 0.7 4.06 0.35 0.63 0.14 0.35 0.63 0.07 0.28 0.56 2.24 0.28 0.42 1.82 0.28 0.56 1.68 0.28 0.42 1.4 0.21 0.42 1.1595 0.21 0.42 0.77 0.14 0.2984 0.7 4.06 0.28 0.49 2.94 0.28 0.63 0.07 0.28 0.56 2.03 0.28 0.42 1.82 0.21 0.42 0.91 0.21 0.35 0.91 0.14 0.35 0.77 6.9167 0.42 0.77 0.14 0.2984 0.7 3.85 0.28 0.49 2.94 0.24 0.49 1.2132 0.21 0.49 1.1595 0.21 0.35 1.05 0.14 0.42 0.91 0.21 0.35 0.91 0.14 0.35 0.63 0.28 0.49 2.03 0.21 0.42 0.98 0.21 0.35 0.91 0.14 0.42 0.77 0.21 0.35 0.77 0.14 0.2984 0.7 4.06 0.28 0.56 3.22 0.24 0.49 1.33 0.21 0.42 1.2132 0.21 0.49 1.89 0.21 0.42 0.98 0.21 0.35 0.91 0.14 0.35 0.63 0.07 0.28 0.56 2.03 0.28 0.56 1.82 0.28 0.56 3.22 0.24 0.49 1.33 0.21 0.42 1.1595 0.21 0.42 0.77 0.14 0.35 0.7 0.14 0.28 0.63 2.6936 0.35 0.63 0.07 0.28 0.56 2.03 0.28 0.42 1.82 0.28 0.42 1.54 0.21 0.42 0.84 0.21 0.35 0.77 5.46 0.42 0.7 0.14 0.28 0.7 0.14 0.28 0.63 2.6936 0.28 0.49 2.45 0.21 0.49 1.12)
		loss_array=(3.308304 20 50 66.6667 20 46.86628 60 11.1111 40 50 11.1111 34.66666 50 9.0909 33.3333 50 80 33.3333 50 7.1429 25 50 75 33.3333 50 4.5455 33.3333 50 2.589188 20 50 66.6667 20 46.86628 60 19.05712 50 57.1429 16.6667 34.66666 50 14.2857 33.3333 50 7.6923 33.3333 50 6.25 25 50 75 25 50 66.6667 20 50 2.589188 20 50 66.6667 20 46.86628 60 11.1111 38.4615 50 10 33.3333 50 3.308304 33.3333 50 80 33.3333 50 6.25 25 50 71.14288 25 50 66.6667 16.6667 50 50 14.2857 50 50 12.5 33.3333 50 5.8824 38.4615 50 10 33.3333 50 3.308304 26.83638 50 20 50 66.6667 11.1111 40 50 11.1111 33.3333 50 4.053344 33.3333 50 8.3333 25 50 7.1429 25 50 75 25 50 66.6667 16.6667 50 50 14.2857 33.3333 50 7.6923 50 65.50002 11.1111 40 50 11.1111 33.3333 50 4.053344 33.3333 50 2.589188 20 50 66.6667 20 50 60 25 50 66.6667 16.6667 50 50 14.2857 33.3333 50 7.6923 33.3333 50 6.25 33.3333 50 4.5455 25 50 66.6667 33.3333 50 2.589188 20 50 66.6667 20 40 60 16.6667 38.4615 55.32568 10 33.3333 50 8.3333 26.83638 50 75.23077 33.3333 50 6.25 25 50 4.5455 25 50 66.6667 20 50 66.6667 14.2857 50 50)
	elif [ "$2" == "passable" ]
	then
		echo "Simulating passable experiences. - p50"
        lat_array=(25.08515 40.33717 74.05064 270.94413 38.29640 63.14152 216.07690 36.44098 62.27683 120.26036 36.31124 60.05534 108.97542 35.11893 51.11284 99.14599 667.87937 56.63552 91.99681 33.34554 46.18237 84.50241 435.82941 52.90060 80.88657 30.17224 52.20690 77.41856 22.34373 40.33717 74.05064 270.94413 38.29640 63.14152 216.07690 37.52902 69.31526 202.50699 36.99427 60.05534 172.16050 36.83950 57.34914 142.64719 33.90763 56.63552 91.99681 32.91922 46.18237 84.50241 435.82941 44.23706 68.09608 342.34882 41.26487 77.41856 22.34373 40.33717 74.05064 250.60918 38.29640 63.14152 216.07690 36.44098 60.96358 114.69829 36.23709 52.90060 108.97542 25.08515 51.11284 99.14599 667.87937 56.63552 91.99681 32.91922 46.18237 84.50241 403.45977 42.99054 68.09608 342.34882 36.91225 65.79767 148.37469 36.68195 64.56505 142.64719 36.59854 55.48585 129.77839 32.29642 60.96358 114.69829 36.23709 52.20690 108.97542 25.08515 49.90293 75.87177 38.29640 63.78285 250.60918 36.44098 62.27683 126.31548 36.31124 54.13043 114.69829 27.99478 58.36814 99.14599 34.42060 48.61702 94.08670 33.34554 46.18237 87.62241 435.82941 44.23706 69.31526 380.01872 36.91225 66.62065 161.72681 36.83950 57.34914 148.37469 33.90763 63.78285 234.96282 36.44098 62.27683 126.31548 36.31124 52.90060 108.97542 27.99478 51.11284 77.41856 22.34373 39.26859 73.31756 250.60918 37.85432 72.44453 216.07690 44.23706 69.31526 380.01872 36.91225 65.79767 161.72681 36.83950 57.34914 142.64719 33.90763 56.15174 91.99681 32.91922 54.89688 82.49454 30.17224 42.99054 80.88657 307.29800 51.11284 77.41856 22.34373 39.26859 73.31756 250.60918 37.85432 62.27683 216.07690 37.07629 60.96358 184.76749 36.23709 59.03959 102.55191 34.42060 49.90293 94.08670 593.37923 56.15174 87.62241 32.91922 45.23566 82.49454 30.17224 42.99054 79.00428 307.29800 41.26487 65.79767 291.09279 36.76675 64.56505 137.45074 )
        thru_array=(1813.34660 4150.99179 5513.55401 6767.71798 4135.16598 4623.72761 5632.84459 2825.00513 4579.85524 5598.64000 2818.20862 4561.54125 5598.64000 2778.47400 4408.67408 5598.64000 12336.58179 4555.43564 5598.64000 2756.77700 4356.38897 5538.22900 7405.86097 4466.57497 5513.55401 2560.35670 4409.54604 5513.55401 907.20515 4150.99179 5513.55401 6767.71798 4135.16598 4623.72761 5632.84459 3981.33060 5513.55401 5611.91377 3192.92678 4561.54125 5598.64000 3046.06897 4558.48797 5598.64000 2756.77700 4555.43564 5598.64000 2756.77700 4356.38897 5538.22900 7405.86097 4356.38897 5513.55401 6895.53755 4164.50953 5513.55401 907.20515 4150.99179 5513.55401 6258.39422 4135.16598 4623.72761 5632.84459 2825.00513 4570.69824 5598.64000 2807.74321 4466.57497 5598.64000 1813.34660 4408.67408 5598.64000 12336.58179 4555.43564 5598.64000 2756.77700 4356.38897 5538.22900 6918.21324 4301.79580 5513.55401 6895.53755 3111.47824 5481.51931 5598.64000 2897.44533 4824.80693 5598.64000 2825.87708 4552.08598 5598.64000 2756.77700 4570.69824 5598.64000 2807.74321 4409.54604 5598.64000 1813.34660 4407.80117 5513.55401 4135.16598 4677.36401 6258.39422 2825.00513 4579.85524 5598.64000 2818.20862 4525.00762 5598.64000 2336.65601 4559.53051 5598.64000 2761.03102 4395.18779 5598.64000 2756.77700 4356.38897 5573.11401 7405.86097 4356.38897 5513.55401 6906.87587 3111.47824 5513.55401 5598.64000 3046.06897 4558.48797 5598.64000 2756.77700 4677.36401 5749.07140 2825.00513 4579.85524 5598.64000 2818.20862 4466.57497 5598.64000 2336.65601 4408.67408 5513.55401 907.20515 4137.47405 5513.55401 6258.39422 4135.16598 5513.55401 5632.84459 4356.38897 5513.55401 6906.87587 3111.47824 5481.51931 5598.64000 3046.06897 4558.48797 5598.64000 2756.77700 4552.38331 5598.64000 2756.77700 4552.08598 5513.55401 2560.35670 4301.79580 5513.55401 6891.94299 4408.67408 5513.55401 907.20515 4137.47405 5513.55401 6258.39422 4135.16598 4579.85524 5632.84459 3587.12822 4570.69824 5598.64000 2807.74321 4559.53051 5598.64000 2761.03102 4407.80117 5598.64000 9510.88100 4552.38331 5573.11401 2756.77700 4356.38897 5513.55401 2560.35670 4301.79580 5513.55401 6891.94299 4164.50953 5481.51931 6891.94299 2974.62842 4824.80693 5598.64000)
		gap_array=(0.07 0.28 0.56 1.946 0.28 0.42 1.54 0.21 0.42 0.84 0.21 0.42 0.77 0.1568 0.35 0.7 6.9146 0.35 0.7 0.14 0.28 0.63 3.6484 0.35 0.63 0.14 0.35 0.56 0.07 0.28 0.56 1.946 0.28 0.42 1.54 0.26 0.49 1.4 0.21 0.42 1.19 0.21 0.35 1.05 0.14 0.35 0.7 0.14 0.28 0.63 3.6484 0.28 0.49 2.4822 0.28 0.56 0.07 0.28 0.56 1.82 0.28 0.42 1.54 0.21 0.42 0.77 0.21 0.35 0.77 0.07 0.35 0.7 6.9146 0.35 0.7 0.14 0.28 0.63 3.143 0.28 0.49 2.4822 0.21 0.49 1.05 0.21 0.42 1.05 0.21 0.35 0.91 0.14 0.42 0.77 0.21 0.35 0.77 0.07 0.2856 0.56 0.28 0.42 1.82 0.21 0.42 0.91 0.21 0.35 0.77 0.14 0.42 0.7 0.14 0.28 0.7 0.14 0.28 0.63 3.6484 0.28 0.49 2.7776 0.21 0.49 1.12 0.21 0.35 1.05 0.14 0.42 1.68 0.21 0.42 0.91 0.21 0.35 0.77 0.14 0.35 0.56 0.07 0.28 0.56 1.82 0.28 0.49 1.54 0.28 0.49 2.7776 0.21 0.49 1.12 0.21 0.35 1.05 0.14 0.35 0.7 0.14 0.35 0.63 0.14 0.28 0.63 2.31 0.35 0.56 0.07 0.28 0.56 1.82 0.28 0.42 1.54 0.21 0.42 1.26 0.21 0.42 0.77 0.14 0.2856 0.7 5.1884 0.35 0.63 0.14 0.28 0.63 0.14 0.28 0.56 2.31 0.28 0.49 2.1 0.21 0.42 0.98)
		loss_array=(0 3.4345 25 50 75 20 50 71.4286 12.5 50 66.6667 11.1111 50 66.6667 9.0909 33.3333 62.5 83.3333 39.6923 55.5556 7.1429 33.3333 50 80.82522 33.3333 50 4.5455 33.3333 50 2.7027 25 50 75 20 50 71.4286 20 50 71.4286 16.6667 50 66.6667 16.6667 50 66.6667 7.6923 39.6923 55.5556 6.283336 33.3333 50 80.82522 25 50 78.85383 25 50 2.7027 25 50 75 20 50 71.4286 12.5 50 66.6667 11.1111 33.3333 66.6667 3.4345 33.3333 62.5 83.3333 39.6923 55.5556 6.283336 33.3333 50 80 25 50 78.85383 16.6667 50 66.6667 14.2857 50 66.6667 14.2857 33.3333 66.6667 5.8824 50 66.6667 11.1111 33.3333 66.6667 3.4345 33.3333 50 20 50 75 12.5 50 66.6667 11.1111 33.3333 66.6667 4.1667 50 62.5 9.0909 33.3333 60 7.1429 33.3333 50 80.82522 25 50 80 16.6667 50 66.6667 16.6667 50 66.6667 7.6923 50 75 12.5 50 66.6667 11.1111 33.3333 66.6667 4.1667 33.3333 50 2.7027 20 50 75 20 50 71.4286 25 50 80 16.6667 50 66.6667 16.6667 50 66.6667 7.6923 34.23899 55.5556 6.283336 33.3333 50 4.5455 25 50 75 33.3333 50 2.7027 20 50 75 20 50 71.4286 20 50 71.4286 11.1111 50 66.6667 9.0909 33.3333 60 83.3333 34.23899 50 6.283336 25 50 4.5455 25 50 75 25 50 75 14.2857 50 66.6667)
	elif [ "$2" == "poor" ]
	then
		echo "Simulating poor experiences. - p75"
        lat_array=(33.55408 58.25245 113.08825 403.08750 55.49360 91.57059 335.97778 51.11054 90.75028 193.20341 50.90455 88.24430 178.39798 48.17748 73.62585 160.57563 938.63040 82.42166 146.83035 45.91602 67.64305 132.81788 653.41134 76.57011 125.93535 39.03792 74.78861 118.55568 30.70565 58.25245 113.08825 403.08750 55.49360 91.57059 335.97778 53.25507 103.23385 318.29449 52.05820 88.24430 278.73053 51.78372 83.54718 236.44392 46.75769 82.42166 146.83035 44.36811 67.64305 132.81788 653.41134 64.41650 101.89505 512.01457 59.52979 118.55568 30.70565 58.25245 113.08825 379.12090 55.49360 91.57059 335.97778 51.11054 89.53102 184.10317 50.41627 76.57011 178.39798 33.55408 73.62585 160.57563 938.63040 82.42166 146.83035 44.36811 67.64305 132.81788 583.35137 63.04384 101.89505 512.01457 51.92695 98.14870 249.07957 51.54622 94.05600 236.44392 51.40611 79.85370 207.80623 43.62020 89.53102 184.10317 50.41627 74.78861 178.39798 33.55408 72.74720 115.55282 55.49360 92.62476 379.12090 51.11054 90.75028 199.11303 50.90455 77.65605 184.10317 37.00901 85.03702 160.57563 47.42175 71.10033 154.05741 45.91602 67.64305 142.23661 653.41134 64.41650 103.23385 541.53507 51.92695 100.77995 262.04516 51.78372 83.54718 249.07957 46.75769 92.62476 353.82201 51.11054 90.75028 199.11303 50.90455 76.57011 178.39798 37.00901 73.62585 118.55568 30.70565 56.98813 110.59450 379.12090 54.02329 108.15206 335.97778 64.41650 103.23385 541.53507 51.92695 98.14870 262.04516 51.78372 83.54718 236.44392 46.75769 81.15968 146.83035 44.36811 78.76854 129.78820 39.03792 63.04384 125.93535 452.69988 73.62585 118.55568 30.70565 56.98813 110.59450 379.12090 54.02329 90.75028 335.97778 52.69179 89.53102 298.60861 50.41627 86.55029 168.89383 47.42175 72.74720 154.05741 833.74890 81.15968 142.23661 44.36811 65.40582 129.78820 39.03792 63.04384 121.68250 452.69988 59.52979 98.14870 422.57209 51.68710 94.05600 221.28068 )
        thru_array=(140.6254 1714.3713 1733.1250 2221.4550 1706.7862 1733.1250 2195.0631 1102.2991 1733.1250 1733.1250 905.9134 1733.1250 1733.1250 493.1241 1733.1250 1733.1250 3334.7378 1733.1250 1733.1250 321.6554 1733.1250 1733.1250 2582.4088 1733.1250 1733.1250 265.6054 1733.1250 1733.1250 70.9712 1714.3713 1733.1250 2221.4550 1706.7862 1733.1250 2195.0631 1706.7862 1733.1250 2179.9450 1706.7862 1733.1250 2101.0325 1706.7862 1733.1250 1811.4322 325.9750 1733.1250 1733.1250 318.7054 1733.1250 1733.1250 2582.4088 1733.1250 1733.1250 2223.0362 1720.8506 1733.1250 70.9712 1714.3713 1733.1250 2214.9756 1706.7862 1733.1250 2195.0631 1102.2991 1733.1250 1733.1250 764.4451 1733.1250 1733.1250 140.6254 1733.1250 1733.1250 3334.7378 1733.1250 1733.1250 318.7054 1733.1250 1733.1250 2223.0362 1730.0700 1733.1250 2223.0362 1706.7862 1733.1250 1933.4619 1706.7862 1733.1250 1811.4322 1685.4506 1733.1250 1739.2881 318.7054 1733.1250 1733.1250 764.4451 1733.1250 1733.1250 140.6254 1733.1250 1733.1250 1706.7862 1733.1250 2214.9756 1102.2991 1733.1250 1733.1250 905.9134 1733.1250 1733.1250 205.1304 1733.1250 1733.1250 361.3750 1733.1250 1733.1250 321.6554 1733.1250 1733.1250 2582.4088 1733.1250 1733.1250 2223.0362 1706.7862 1733.1250 2050.2760 1706.7862 1733.1250 1933.4619 325.9750 1733.1250 2208.4963 1102.2991 1733.1250 1733.1250 905.9134 1733.1250 1733.1250 205.1304 1733.1250 1733.1250 70.9712 1707.8919 1733.1250 2214.9756 1706.7862 1733.1250 2195.0631 1733.1250 1733.1250 2223.0362 1706.7862 1733.1250 2050.2760 1706.7862 1733.1250 1811.4322 325.9750 1733.1250 1733.1250 318.7054 1733.1250 1733.1250 265.6054 1730.0700 1733.1250 2223.0362 1733.1250 1733.1250 70.9712 1707.8919 1733.1250 2214.9756 1706.7862 1733.1250 2195.0631 1706.7862 1733.1250 2151.7878 764.4451 1733.1250 1733.1250 361.3750 1733.1250 1733.1250 3255.9044 1733.1250 1733.1250 318.7054 1733.1250 1733.1250 265.6054 1730.0700 1733.1250 2223.0362 1720.8506 1733.1250 2223.0362 1706.7862 1733.1250 1745.7675)
		gap_array=(0.07 0.28 0.49 1.82 0.21 0.42 1.33 0.21 0.42 0.77 0.14 0.35 0.7 0.14 0.28 0.7 6.9167 0.35 0.63 0.14 0.28 0.63 3.22 0.28 0.56 0.07 0.28 0.56 0.07 0.28 0.49 1.82 0.21 0.42 1.33 0.21 0.49 1.26 0.21 0.35 1.12 0.21 0.35 0.98 0.14 0.35 0.63 0.14 0.28 0.63 3.22 0.28 0.42 2.3569 0.28 0.56 0.07 0.28 0.49 1.6737 0.21 0.42 1.33 0.21 0.42 0.77 0.14 0.28 0.7 0.07 0.28 0.7 6.9167 0.35 0.63 0.14 0.28 0.63 2.87 0.28 0.42 2.3569 0.21 0.42 0.98 0.21 0.42 0.98 0.21 0.35 0.84 0.14 0.42 0.77 0.14 0.28 0.7 0.07 0.28 0.5332 0.21 0.42 1.6737 0.21 0.42 0.84 0.14 0.35 0.77 0.07 0.35 0.7 0.14 0.28 0.63 0.14 0.28 0.63 3.22 0.28 0.49 2.5802 0.21 0.42 1.05 0.21 0.35 0.98 0.14 0.42 1.54 0.21 0.42 0.84 0.14 0.28 0.7 0.07 0.28 0.56 0.07 0.24 0.49 1.6737 0.21 0.49 1.33 0.28 0.49 2.5802 0.21 0.42 1.05 0.21 0.35 0.98 0.14 0.35 0.63 0.14 0.35 0.56 0.07 0.28 0.56 2.1 0.28 0.56 0.07 0.24 0.49 1.6737 0.21 0.42 1.33 0.21 0.42 1.1475 0.14 0.35 0.7 0.14 0.28 0.63 4.97 0.35 0.63 0.14 0.28 0.56 0.07 0.28 0.56 2.1 0.28 0.42 1.89 0.21 0.42 0.91)
		loss_array=(3.4483 25 50 83.3333 20 50 81.51371 12.5 50 71.4286 12.5 50 66.6667 9.208416 33.3333 66.6667 85.7143 50 66.6667 7.6923 33.3333 66.6667 83.3333 33.3333 66.6667 4.709964 33.3333 59.33332 2.735744 25 50 83.3333 20 50 81.51371 20 50 80 16.6667 50 80 16.6667 50 75 8.3333 50 66.6667 6.704796 33.3333 66.6667 83.3333 25 50 83.3333 25 59.33332 2.735744 25 50 83.3333 20 50 81.51371 12.5 50 71.4286 11.1111 33.3333 66.6667 3.4483 33.3333 66.6667 85.7143 50 66.6667 6.704796 33.3333 66.6667 83.3333 25 50 83.3333 16.6667 50 75 14.2857 50 75 14.2857 33.3333 75 6.117664 50 71.4286 11.1111 33.3333 66.6667 3.4483 33.3333 50 20 50 83.3333 12.5 50 75 12.5 33.3333 71.4286 4.287916 50 66.6667 9.0909 33.3333 66.6667 7.6923 33.3333 66.6667 83.3333 25 50 83.3333 16.6667 50 80 16.6667 50 75 8.3333 50 83.3333 12.5 50 75 12.5 33.3333 66.6667 4.287916 33.3333 59.33332 2.735744 20 50 83.3333 20 50 81.51371 25 50 83.3333 16.6667 50 80 16.6667 50 75 8.3333 40.83077 66.6667 6.704796 33.3333 66.6667 4.709964 25 66.6667 83.3333 33.3333 59.33332 2.735744 20 50 83.3333 20 50 81.51371 20 50 80 11.1111 50 66.6667 9.0909 33.3333 66.6667 85.7143 40.83077 66.6667 6.704796 26.71699 66.6667 4.709964 25 62.5 83.3333 25 50 83.3333 16.6667 50 75)
	elif [ "$2" == "verypoor" ]
	then
		echo "Simulating very poor experiences. - p90"
        lat_array=(44.16368 76.70786 150.49338 536.54651 73.13221 121.04087 453.88322 67.27139 119.87035 257.96378 67.00027 116.54971 239.91346 63.41091 97.07729 218.86572 1235.41979 108.62001 197.15714 60.43440 89.78477 180.49396 871.93522 100.81883 168.17318 51.38148 98.84763 158.31649 40.41459 76.70786 150.49338 536.54651 73.13221 121.04087 453.88322 70.11731 137.04664 426.36216 68.55160 116.54971 377.41426 68.15742 110.26524 321.76407 61.54219 108.62001 197.15714 58.39705 89.78477 180.49396 871.93522 84.93063 134.83756 684.54530 78.43845 158.31649 40.41459 76.70786 150.49338 509.87411 73.13221 121.04087 453.88322 67.27139 118.23437 249.25498 66.35760 100.81883 239.91346 44.16368 97.07729 218.86572 1235.41979 108.62001 197.15714 58.39705 89.78477 180.49396 768.68451 83.41735 134.83756 684.54530 68.34594 129.81273 336.92083 67.84483 125.18413 321.76407 67.66042 105.14992 286.39076 57.41265 118.23437 249.25498 66.35760 98.84763 239.91346 44.16368 95.88689 154.05601 73.13221 122.38277 509.87411 67.27139 119.87035 271.49655 67.00027 102.25293 249.25498 48.71105 112.16892 218.86572 62.41623 93.80669 206.35128 60.43440 89.78477 189.64800 871.93522 84.93063 137.04664 714.02044 68.34594 133.48641 356.46146 68.15742 110.26524 336.92083 61.54219 122.38277 481.13694 67.27139 119.87035 271.49655 67.00027 100.81883 239.91346 48.71105 97.07729 158.31649 40.41459 75.09313 147.37977 509.87411 71.10514 143.87506 453.88322 84.93063 137.04664 714.02044 68.34594 129.81273 356.46146 68.15742 110.26524 321.76407 61.54219 106.83903 197.15714 58.39705 103.74462 172.55877 51.38148 83.41735 168.17318 607.12450 97.07729 158.31649 40.41459 75.09313 147.37977 509.87411 71.10514 119.87035 453.88322 69.38895 118.23437 400.95316 66.35760 114.33447 226.36218 62.41623 95.88689 206.35128 1097.37538 106.83903 189.64800 58.39705 86.44562 172.55877 51.38148 83.41735 162.05049 607.12450 78.43845 129.81273 563.04856 68.03026 125.18413 307.58417 )
        thru_array=(3.08844 582.34201 1033.30520 4002.52216 475.60820 772.09135 4002.52216 406.12001 772.09135 3379.68918 338.05248 772.09135 2510.06874 157.50649 747.38435 2314.48232 4002.52216 763.59834 1569.93930 77.456216 747.38435 1351.65374 4002.52216 747.38435 1260.73240 3.08844 747.38435 1161.37975 3.08844 582.34201 1033.30520 4002.52216 475.60820 772.09135 4002.52216 472.14923 829.07164 4002.52216 454.42215 772.09135 4002.52216 453.98964 769.92936 4002.52216 123.040388 763.59834 1569.93930 40.704729 747.38435 1351.65374 4002.52216 747.38435 796.79807 4002.52216 673.51047 1161.37975 3.08844 582.34201 1033.30520 4002.52216 475.60820 772.09135 4002.52216 406.12001 772.09135 2785.82852 238.02021 747.38435 2510.06874 3.08844 747.38435 2314.48232 4002.52216 763.59834 1569.93930 40.704729 747.38435 1351.65374 4002.52216 733.05426 796.79807 4002.52216 453.98964 795.80992 4002.52216 440.58628 775.55032 4002.52216 431.44464 753.22143 4002.52216 22.97751 772.09135 2785.82852 238.02021 747.38435 2510.06874 3.08844 747.38435 1089.20463 475.60820 772.09135 4002.52216 406.12001 772.09135 3973.55261 338.05248 747.38435 2785.82852 3.08844 772.09135 2314.48232 157.50649 747.38435 1942.21095 77.456216 747.38435 1420.03008 4002.52216 747.38435 829.07164 4002.52216 453.98964 796.79807 4002.52216 453.98964 769.92936 4002.52216 123.040388 772.09135 4002.52216 406.12001 772.09135 3973.55261 338.05248 747.38435 2510.06874 3.08844 747.38435 1161.37975 3.08844 491.17356 1000.38329 4002.52216 475.60820 967.46138 4002.52216 747.38435 829.07164 4002.52216 453.98964 795.80992 4002.52216 453.98964 769.92936 4002.52216 123.040388 757.26704 1569.93930 40.704729 749.42265 1293.65431 3.08844 733.05426 1260.73240 4002.52216 747.38435 1161.37975 3.08844 491.17356 1000.38329 4002.52216 475.60820 772.09135 4002.52216 463.28569 772.09135 4002.52216 238.02021 772.09135 2437.89362 157.50649 747.38435 1942.21095 4002.52216 757.26704 1420.03008 40.704729 747.38435 1293.65431 3.08844 733.05426 1227.81049 4002.52216 673.51047 795.80992 4002.52216 449.44982 775.55032 4002.52216)
		gap_array=(0.07 0.21 0.49 1.61 0.21 0.35 1.19 0.14 0.35 0.7 0.14 0.35 0.7 0.14 0.28 0.63 6.8201 0.35 0.63 0.07 0.28 0.56 2.94 0.28 0.56 0.07 0.28 0.49 0.07 0.21 0.49 1.61 0.21 0.35 1.19 0.21 0.42 1.12 0.21 0.35 0.98 0.21 0.35 0.84 0.07 0.35 0.63 0.07 0.28 0.56 2.94 0.28 0.42 2.1 0.21 0.49 0.07 0.21 0.49 1.47 0.21 0.35 1.19 0.14 0.35 0.7 0.14 0.28 0.7 0.07 0.28 0.63 6.8201 0.35 0.63 0.07 0.28 0.56 2.66 0.28 0.42 2.1 0.21 0.42 0.91 0.21 0.42 0.84 0.14 0.3417 0.77 0.07 0.35 0.7 0.14 0.28 0.7 0.07 0.28 0.49 0.21 0.42 1.47 0.14 0.35 0.77 0.14 0.28 0.7 0.07 0.35 0.63 0.14 0.28 0.63 0.07 0.28 0.56 2.94 0.28 0.42 2.38 0.21 0.42 0.98 0.21 0.35 0.91 0.07 0.42 1.33 0.14 0.35 0.77 0.14 0.28 0.7 0.07 0.28 0.49 0.07 0.21 0.49 1.47 0.21 0.49 1.19 0.28 0.42 2.38 0.21 0.42 0.98 0.21 0.35 0.84 0.07 0.35 0.63 0.07 0.28 0.56 0.07 0.28 0.56 1.89 0.28 0.49 0.07 0.21 0.49 1.47 0.21 0.35 1.19 0.21 0.35 1.05 0.14 0.35 0.63 0.14 0.28 0.63 4.6802 0.35 0.56 0.07 0.28 0.56 0.07 0.28 0.49 1.89 0.21 0.42 1.7703 0.21 0.42 0.84)
		loss_array=(3.4483 25 50 83.3333 20 50 83.3333 12.5 50 75 12.5 50 75 9.854544 33.3333 66.6667 90.9091 50 66.6667 7.6923 33.3333 66.6667 88.8889 33.3333 66.6667 4.709964 33.3333 62.5 2.735744 25 50 83.3333 20 50 83.3333 20 50 83.3333 20 50 83.3333 16.6667 50 80 8.3333 50 66.6667 6.704796 33.3333 66.6667 88.8889 25 50 85.7143 25 62.5 2.735744 25 50 83.3333 20 50 83.3333 12.5 50 75 11.1111 33.3333 75 3.4483 33.3333 66.6667 90.9091 50 66.6667 6.704796 33.3333 66.6667 85.7143 25 50 85.7143 16.6667 50 80 14.2857 50 80 14.2857 37.16666 75 6.117664 50 75 11.1111 33.3333 75 3.4483 33.3333 55.80957 20 50 83.3333 12.5 50 75 12.5 33.3333 75 4.287916 50 66.6667 9.0909 33.3333 66.6667 7.6923 33.3333 66.6667 88.8889 25 50 85.7143 16.6667 50 83.3333 16.6667 50 80 8.3333 50 83.3333 12.5 50 75 12.5 33.3333 75 4.287916 33.3333 62.5 2.735744 20.7333 50 83.3333 20 50 83.3333 25 50 85.7143 16.6667 50 83.3333 16.6667 50 80 8.3333 50 66.6667 6.704796 33.3333 66.6667 4.709964 25 66.6667 84.47618 33.3333 62.5 2.735744 20.7333 50 83.3333 20 50 83.3333 20 50 83.3333 11.1111 50 71.4286 9.0909 33.3333 66.6667 90.10909 50 66.6667 6.704796 28.87905 66.6667 4.709964 25 66.6667 84.47618 25 50 83.3333 16.6667 50 80)
	else
		echo "Please select a valid network experience to simulate. Valid values are noloss, good, fair, passable, poor, and verypoor."
		exit 1	
	fi
elif [ "$1" == "mgst_brazil_cell" ]
then
	if [ "$2" == "noloss" ]
	then
		echo "Simulating no loss experiences."
        lat_array=(6.119046 9.154522 13.084045 45.638087 8.976189 11.754879 35.414220 7.599105 11.732140 20.289103 7.516189 11.672617 18.308032 7.262260 10.535712 17.583925 200.077289 11.341962 16.278092 6.982856 10.046546 15.265354 104.638911 10.758331 14.612021 6.356665 10.642736 13.538688 6.022201 9.154522 13.084045 45.638087 8.976189 11.754879 35.414220 8.787736 11.986664 32.174875 8.491189 11.672617 26.492019 8.132736 11.535355 23.177436 7.107141 11.341962 16.278092 6.833332 10.046546 15.265354 104.638911 9.763927 11.904760 70.231119 9.283748 13.538688 6.022201 9.154522 13.084045 41.564100 8.976189 11.754879 35.414220 7.599105 11.708331 19.398806 7.424582 10.758331 18.308032 6.119046 10.535712 17.583925 200.077289 11.341962 16.278092 6.833332 10.046546 15.265354 92.345223 9.563272 11.904760 70.231119 8.281070 11.865831 23.992853 7.845236 11.815474 23.177436 7.741070 11.110891 21.182020 6.665237 11.708331 19.398806 7.424582 10.642736 18.308032 6.119046 10.451426 13.296069 8.976189 11.785712 41.564100 7.599105 11.732140 20.734758 7.516189 10.876843 19.398806 6.255713 11.620652 17.583925 7.190475 10.363093 16.939044 6.982856 10.046546 15.686307 104.638911 9.763927 11.986664 83.063081 8.281070 11.883926 25.057079 8.132736 11.535355 23.992853 7.107141 11.785712 37.991303 7.599105 11.732140 20.734758 7.516189 10.758331 18.308032 6.255713 10.535712 13.538688 6.022201 9.042081 12.612617 41.564100 8.879462 12.318628 35.414220 9.763927 11.986664 83.063081 8.281070 11.865831 25.057079 8.132736 11.535355 23.177436 7.107141 11.227141 16.278092 6.833332 10.976188 14.811069 6.356665 9.563272 14.612021 59.501300 10.535712 13.538688 6.022201 9.042081 12.612617 41.564100 8.879462 11.732140 35.414220 8.639879 11.708331 28.399697 7.424582 11.648807 17.917735 7.190475 10.451426 16.939044 157.730689 11.227141 15.686307 6.833332 9.920355 14.811069 6.356665 9.563272 13.980950 59.501300 9.283748 11.865831 52.745646 7.976189 11.815474 22.055948 )
        thru_array=(600.7359 9962.4053 11341.2429 12652.2353 9772.2426 10992.8574 12467.8502 6975.9351 10975.9869 11863.5058 6843.4671 10822.2723 11564.8926 6552.8401 10269.5000 11432.5721 14939.2926 10553.1426 11432.5721 6202.1229 10133.8400 11399.3282 14146.0974 10269.5000 11385.7500 2820.9026 10269.5000 11376.3093 312.1581 9962.4053 11341.2429 12652.2353 9772.2426 10992.8574 12467.8502 9626.1600 11245.7398 12425.4239 9382.4447 10822.2723 12350.0684 9262.5000 10553.1426 12138.3126 6304.4356 10553.1426 11432.5721 5854.8606 10133.8400 11399.3282 14146.0974 10116.0347 11225.6180 12922.4092 10081.4821 11376.3093 312.1581 9962.4053 11341.2429 12583.7958 9772.2426 10992.8574 12467.8502 6975.9351 10899.1296 11680.4400 6773.4970 10269.5000 11564.8926 600.7359 10269.5000 11432.5721 14939.2926 10553.1426 11432.5721 5854.8606 10133.8400 11399.3282 13999.0982 10113.4279 11225.6180 12922.4092 9320.9258 11155.7147 12228.4547 8143.5079 11016.6074 12138.3126 7457.5243 10448.1942 12069.7910 4980.0155 10899.1296 11680.4400 6773.4970 10269.5000 11564.8926 600.7359 10269.5000 11365.2498 9772.2426 10992.8574 12583.7958 6975.9351 10975.9869 12046.5700 6843.4671 10269.5000 11680.4400 1479.7709 10621.2523 11432.5721 6415.3333 10237.2547 11432.5721 6202.1229 10133.8400 11418.5242 14146.0974 10116.0347 11245.7398 13460.7537 9320.9258 11192.4410 12314.5962 9262.5000 10553.1426 12228.4547 6304.4356 10992.8574 12515.3547 6975.9351 10975.9869 12046.5700 6843.4671 10269.5000 11564.8926 1479.7709 10269.5000 11376.3093 312.1581 9843.3300 11298.9534 12583.7958 9711.0353 11256.6655 12467.8502 10116.0347 11245.7398 13460.7537 9320.9258 11155.7147 12314.5962 9262.5000 10553.1426 12138.3126 6304.4356 10553.1426 11432.5721 5854.8606 10331.9021 11385.7500 2820.9026 10113.4279 11385.7500 12728.5347 10269.5000 11376.3093 312.1581 9843.3300 11298.9534 12583.7958 9711.0353 10975.9869 12467.8502 9504.3016 10899.1296 12385.5406 6773.4970 10724.6792 11492.5574 6415.3333 10269.5000 11432.5721 14488.5853 10553.1426 11418.5242 5854.8606 10124.9374 11385.7500 2820.9026 10113.4279 11385.7500 12728.5347 10081.4821 11155.7147 12694.5916 8864.6400 11016.6074 12084.8147)
		gap_array=(99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999 99999)
		loss_array=(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 )
	elif [ "$2" == "good" ]
	then
		echo "Simulating good experiences. - p10"
        lat_array=(6.119046 9.154522 13.084045 45.638087 8.976189 11.754879 35.414220 7.599105 11.732140 20.289103 7.516189 11.672617 18.308032 7.262260 10.535712 17.583925 200.077289 11.341962 16.278092 6.982856 10.046546 15.265354 104.638911 10.758331 14.612021 6.356665 10.642736 13.538688 6.022201 9.154522 13.084045 45.638087 8.976189 11.754879 35.414220 8.787736 11.986664 32.174875 8.491189 11.672617 26.492019 8.132736 11.535355 23.177436 7.107141 11.341962 16.278092 6.833332 10.046546 15.265354 104.638911 9.763927 11.904760 70.231119 9.283748 13.538688 6.022201 9.154522 13.084045 41.564100 8.976189 11.754879 35.414220 7.599105 11.708331 19.398806 7.424582 10.758331 18.308032 6.119046 10.535712 17.583925 200.077289 11.341962 16.278092 6.833332 10.046546 15.265354 92.345223 9.563272 11.904760 70.231119 8.281070 11.865831 23.992853 7.845236 11.815474 23.177436 7.741070 11.110891 21.182020 6.665237 11.708331 19.398806 7.424582 10.642736 18.308032 6.119046 10.451426 13.296069 8.976189 11.785712 41.564100 7.599105 11.732140 20.734758 7.516189 10.876843 19.398806 6.255713 11.620652 17.583925 7.190475 10.363093 16.939044 6.982856 10.046546 15.686307 104.638911 9.763927 11.986664 83.063081 8.281070 11.883926 25.057079 8.132736 11.535355 23.992853 7.107141 11.785712 37.991303 7.599105 11.732140 20.734758 7.516189 10.758331 18.308032 6.255713 10.535712 13.538688 6.022201 9.042081 12.612617 41.564100 8.879462 12.318628 35.414220 9.763927 11.986664 83.063081 8.281070 11.865831 25.057079 8.132736 11.535355 23.177436 7.107141 11.227141 16.278092 6.833332 10.976188 14.811069 6.356665 9.563272 14.612021 59.501300 10.535712 13.538688 6.022201 9.042081 12.612617 41.564100 8.879462 11.732140 35.414220 8.639879 11.708331 28.399697 7.424582 11.648807 17.917735 7.190475 10.451426 16.939044 157.730689 11.227141 15.686307 6.833332 9.920355 14.811069 6.356665 9.563272 13.980950 59.501300 9.283748 11.865831 52.745646 7.976189 11.815474 22.055948 )
        thru_array=(600.7359 9962.4053 11341.2429 12652.2353 9772.2426 10992.8574 12467.8502 6975.9351 10975.9869 11863.5058 6843.4671 10822.2723 11564.8926 6552.8401 10269.5000 11432.5721 14939.2926 10553.1426 11432.5721 6202.1229 10133.8400 11399.3282 14146.0974 10269.5000 11385.7500 2820.9026 10269.5000 11376.3093 312.1581 9962.4053 11341.2429 12652.2353 9772.2426 10992.8574 12467.8502 9626.1600 11245.7398 12425.4239 9382.4447 10822.2723 12350.0684 9262.5000 10553.1426 12138.3126 6304.4356 10553.1426 11432.5721 5854.8606 10133.8400 11399.3282 14146.0974 10116.0347 11225.6180 12922.4092 10081.4821 11376.3093 312.1581 9962.4053 11341.2429 12583.7958 9772.2426 10992.8574 12467.8502 6975.9351 10899.1296 11680.4400 6773.4970 10269.5000 11564.8926 600.7359 10269.5000 11432.5721 14939.2926 10553.1426 11432.5721 5854.8606 10133.8400 11399.3282 13999.0982 10113.4279 11225.6180 12922.4092 9320.9258 11155.7147 12228.4547 8143.5079 11016.6074 12138.3126 7457.5243 10448.1942 12069.7910 4980.0155 10899.1296 11680.4400 6773.4970 10269.5000 11564.8926 600.7359 10269.5000 11365.2498 9772.2426 10992.8574 12583.7958 6975.9351 10975.9869 12046.5700 6843.4671 10269.5000 11680.4400 1479.7709 10621.2523 11432.5721 6415.3333 10237.2547 11432.5721 6202.1229 10133.8400 11418.5242 14146.0974 10116.0347 11245.7398 13460.7537 9320.9258 11192.4410 12314.5962 9262.5000 10553.1426 12228.4547 6304.4356 10992.8574 12515.3547 6975.9351 10975.9869 12046.5700 6843.4671 10269.5000 11564.8926 1479.7709 10269.5000 11376.3093 312.1581 9843.3300 11298.9534 12583.7958 9711.0353 11256.6655 12467.8502 10116.0347 11245.7398 13460.7537 9320.9258 11155.7147 12314.5962 9262.5000 10553.1426 12138.3126 6304.4356 10553.1426 11432.5721 5854.8606 10331.9021 11385.7500 2820.9026 10113.4279 11385.7500 12728.5347 10269.5000 11376.3093 312.1581 9843.3300 11298.9534 12583.7958 9711.0353 10975.9869 12467.8502 9504.3016 10899.1296 12385.5406 6773.4970 10724.6792 11492.5574 6415.3333 10269.5000 11432.5721 14488.5853 10553.1426 11418.5242 5854.8606 10124.9374 11385.7500 2820.9026 10113.4279 11385.7500 12728.5347 10081.4821 11155.7147 12694.5916 8864.6400 11016.6074 12084.8147)
		gap_array=(0.14 0.28 0.63 2.52 0.28 0.49 2.03 0.21 0.48 1.05 0.21 0.42 0.98 0.21 0.35 0.91 6.9167 0.42 0.8043 0.14 0.35 0.77 4.13 0.35 0.7 0.14 0.35 0.63 0.07 0.28 0.63 2.52 0.28 0.49 2.03 0.28 0.56 1.89 0.28 0.42 1.75 0.26 0.42 1.3573 0.21 0.42 0.8043 0.14 0.35 0.77 4.13 0.28 0.56 3.22 0.28 0.63 0.07 0.28 0.63 2.38 0.28 0.49 2.03 0.21 0.42 1.05 0.21 0.35 0.98 0.14 0.35 0.91 6.9167 0.42 0.8043 0.14 0.35 0.77 3.99 0.28 0.56 3.22 0.28 0.49 1.47 0.21 0.49 1.3573 0.21 0.42 1.19 0.14 0.42 1.05 0.21 0.35 0.98 0.14 0.35 0.63 0.28 0.49 2.38 0.21 0.48 1.12 0.21 0.35 1.05 0.14 0.42 0.91 0.21 0.35 0.84 0.14 0.35 0.77 4.13 0.28 0.56 3.5602 0.28 0.56 1.61 0.26 0.42 1.47 0.21 0.49 2.17 0.21 0.48 1.12 0.21 0.35 0.98 0.14 0.35 0.63 0.07 0.28 0.63 2.38 0.28 0.56 2.03 0.28 0.56 3.5602 0.28 0.49 1.61 0.26 0.42 1.3573 0.21 0.42 0.8043 0.14 0.35 0.7 0.14 0.28 0.7 2.94 0.35 0.63 0.07 0.28 0.63 2.38 0.28 0.48 2.03 0.28 0.42 1.82 0.21 0.42 0.91 0.21 0.35 0.84 5.46 0.42 0.77 0.14 0.35 0.7 0.14 0.28 0.7 2.94 0.28 0.49 2.73 0.21 0.49 1.26)
		loss_array=(2.838572 16.6667 33.3333 50 16.6667 33.3333 50 9.0909 33.3333 50 9.0909 33.3333 50 7.1429 21.89471 50 73.42858 25 50 5.8824 20 50 66.6667 25 40 3.780248 25 37.5 1.7241 16.6667 33.3333 50 16.6667 33.3333 50 14.2857 33.3333 50 14.2857 33.3333 50 12.5 25 50 6.25 25 50 5.2632 20 50 66.6667 20 33.3333 50 16.6667 37.5 1.7241 16.6667 33.3333 50 16.6667 33.3333 50 9.0909 33.3333 50 8.878772 25 50 2.838572 21.89471 50 73.42858 25 50 5.2632 20 50 59.8919 20 33.3333 50 12.5 33.3333 50 11.1111 33.3333 50 11.1111 25 50 5 33.3333 50 8.878772 25 50 2.838572 20 33.3333 16.6667 33.3333 50 9.0909 33.3333 50 9.0909 25 50 3.3701 26.55441 50 6.6667 20 50 5.8824 20 50 66.6667 20 33.3333 50 12.5 33.3333 50 12.5 25 50 6.25 33.3333 50 9.0909 33.3333 50 9.0909 25 50 3.3701 21.89471 37.5 1.7241 16.6667 33.3333 50 14.2857 33.3333 50 20 33.3333 50 12.5 33.3333 50 12.5 25 50 6.25 25 50 5.2632 25 45.24671 3.780248 20 40 50 21.89471 37.5 1.7241 16.6667 33.3333 50 14.2857 33.3333 50 14.2857 33.3333 50 8.878772 30 50 6.6667 20 50 66.6667 25 50 5.2632 20 45.24671 3.780248 20 40 50 16.6667 33.3333 50 11.1111 33.3333 50)
	elif [ "$2" == "fair" ]
	then
		echo "Simulating fair experiences. - p25"
        lat_array=(8.02374 12.95395 22.28269 81.30600 12.88310 18.74833 58.84226 11.60529 18.34213 30.32330 11.51281 17.70129 28.36700 11.03582 14.16281 26.79632 230.28832 16.19538 25.63876 10.24996 13.31512 24.53264 146.97497 14.70228 23.37796 8.93901 14.47673 22.77138 7.39146 12.95395 22.28269 81.30600 12.88310 18.74833 58.84226 12.82872 20.88639 52.41227 12.75147 17.70129 45.75726 12.38207 16.44224 38.87794 10.50642 16.19538 25.63876 9.93356 13.31512 24.53264 146.97497 13.08218 20.58633 106.75262 12.98264 22.77138 7.39146 12.95395 22.28269 72.01621 12.88310 18.74833 58.84226 11.60529 18.01266 29.22195 11.41477 14.70228 28.36700 8.02374 14.16281 26.79632 230.28832 16.19538 25.63876 9.93356 13.31512 24.53264 134.08291 13.05009 20.58633 106.75262 12.59082 19.83889 40.33804 12.04874 19.34858 38.87794 11.94051 15.55520 33.61819 9.74252 18.01266 29.22195 11.41477 14.47673 28.36700 8.02374 13.86569 22.47478 12.88310 19.12296 72.01621 11.60529 18.34213 31.86267 11.51281 14.93789 29.22195 8.48268 16.95288 26.79632 10.79191 13.62570 26.16646 10.24996 13.31512 25.39158 146.97497 13.08218 20.88639 118.88803 12.59082 20.16294 42.68236 12.38207 16.44224 40.33804 10.50642 19.12296 64.88415 11.60529 18.34213 31.86267 11.51281 14.70228 28.36700 8.48268 14.16281 22.77138 7.39146 12.92127 21.95388 72.01621 12.85918 21.55180 58.84226 13.08218 20.88639 118.88803 12.59082 19.83889 42.68236 12.38207 16.44224 38.87794 10.50642 15.91493 25.63876 9.93356 15.18266 24.07148 8.93901 13.05009 23.37796 99.31487 14.16281 22.77138 7.39146 12.92127 21.95388 72.01621 12.85918 18.34213 58.84226 12.78402 18.01266 48.97797 11.41477 17.29621 27.56839 10.79191 13.86569 26.16646 203.99748 15.91493 25.39158 9.93356 13.18676 24.07148 8.93901 13.05009 22.98314 99.31487 12.98264 19.83889 91.61100 12.21593 19.34858 36.17303 )
        thru_array=(1270.14858 8504.66627 11391.12515 13994.87520 8442.13103 10369.11527 13255.86274 6121.81290 10288.39274 12382.37325 5616.11597 10017.16567 12379.47767 4328.32970 9380.14667 12359.16653 17599.96406 9445.28566 12222.95799 3807.99279 8654.73334 12197.23508 15831.83411 9380.14667 11789.10882 1601.45760 9380.14667 11429.88300 635.25538 8504.66627 11391.12515 13994.87520 8442.13103 10369.11527 13255.86274 8377.28063 10975.01256 13180.19205 8044.92233 10017.16567 13132.20600 7610.65812 9504.63675 13095.04023 3889.89560 9445.28566 12222.95799 3476.32514 8654.73334 12197.23508 15831.83411 8582.92125 10824.02462 14222.27313 8558.08031 11429.88300 635.25538 8504.66627 11391.12515 13685.96032 8442.13103 10369.11527 13255.86274 6121.81290 10152.77758 12382.37325 5103.03906 9380.14667 12379.47767 1270.14858 9380.14667 12359.16653 17599.96406 9445.28566 12222.95799 3476.32514 8654.73334 12197.23508 15181.36190 8572.41225 10824.02462 14222.27313 7829.06454 10477.39275 13114.32998 7280.64416 10477.39275 13095.04023 7107.61032 9380.14667 12656.46022 2606.70365 10152.77758 12382.37325 5103.03906 9380.14667 12379.47767 1270.14858 9380.14667 11429.88300 8442.13103 10434.40017 13685.96032 6121.81290 10288.39274 12382.37325 5616.11597 9380.14667 12382.37325 1567.77657 9649.77518 12359.16653 4025.64694 9207.31063 12291.06064 3807.99279 8654.73334 12201.53790 15831.83411 8582.92125 10975.01256 14701.81589 7829.06454 10641.82093 13132.20600 7610.65812 9504.63675 13114.32998 3889.89560 10434.40017 13377.04544 6121.81290 10288.39274 12382.37325 5616.11597 9380.14667 12379.47767 1567.77657 9380.14667 11429.88300 635.25538 8451.25224 11297.64979 13685.96032 8442.13103 11204.17442 13255.86274 8582.92125 10975.01256 14701.81589 7829.06454 10477.39275 13132.20600 7610.65812 9504.63675 13095.04023 3889.89560 9385.93782 12222.95799 3476.32514 9380.14667 12102.47568 1601.45760 8572.41225 11789.10882 14070.22164 9380.14667 11429.88300 635.25538 8451.25224 11297.64979 13685.96032 8442.13103 10288.39274 13255.86274 8211.10148 10152.77758 13132.20600 5103.03906 9839.39775 12374.73063 4025.64694 9380.14667 12291.06064 17102.61337 9385.93782 12201.53790 3476.32514 8618.82892 12102.47568 1601.45760 8572.41225 11475.74196 14070.22164 8558.08031 10477.39275 14070.22164 7428.42525 10477.39275 12944.60352)
		gap_array=(0.14 0.28 0.56 2.24 0.28 0.42 1.82 0.21 0.42 0.98 0.21 0.42 0.91 0.21 0.35 0.77 6.9167 0.42 0.77 0.14 0.2984 0.7 4.06 0.35 0.63 0.14 0.35 0.63 0.07 0.28 0.56 2.24 0.28 0.42 1.82 0.28 0.56 1.68 0.28 0.42 1.4 0.21 0.42 1.1595 0.21 0.42 0.77 0.14 0.2984 0.7 4.06 0.28 0.49 2.94 0.28 0.63 0.07 0.28 0.56 2.03 0.28 0.42 1.82 0.21 0.42 0.91 0.21 0.35 0.91 0.14 0.35 0.77 6.9167 0.42 0.77 0.14 0.2984 0.7 3.85 0.28 0.49 2.94 0.24 0.49 1.2132 0.21 0.49 1.1595 0.21 0.35 1.05 0.14 0.42 0.91 0.21 0.35 0.91 0.14 0.35 0.63 0.28 0.49 2.03 0.21 0.42 0.98 0.21 0.35 0.91 0.14 0.42 0.77 0.21 0.35 0.77 0.14 0.2984 0.7 4.06 0.28 0.56 3.22 0.24 0.49 1.33 0.21 0.42 1.2132 0.21 0.49 1.89 0.21 0.42 0.98 0.21 0.35 0.91 0.14 0.35 0.63 0.07 0.28 0.56 2.03 0.28 0.56 1.82 0.28 0.56 3.22 0.24 0.49 1.33 0.21 0.42 1.1595 0.21 0.42 0.77 0.14 0.35 0.7 0.14 0.28 0.63 2.6936 0.35 0.63 0.07 0.28 0.56 2.03 0.28 0.42 1.82 0.28 0.42 1.54 0.21 0.42 0.84 0.21 0.35 0.77 5.46 0.42 0.7 0.14 0.28 0.7 0.14 0.28 0.63 2.6936 0.28 0.49 2.45 0.21 0.49 1.12)
		loss_array=(3.308304 20 50 66.6667 20 46.86628 60 11.1111 40 50 11.1111 34.66666 50 9.0909 33.3333 50 80 33.3333 50 7.1429 25 50 75 33.3333 50 4.5455 33.3333 50 2.589188 20 50 66.6667 20 46.86628 60 19.05712 50 57.1429 16.6667 34.66666 50 14.2857 33.3333 50 7.6923 33.3333 50 6.25 25 50 75 25 50 66.6667 20 50 2.589188 20 50 66.6667 20 46.86628 60 11.1111 38.4615 50 10 33.3333 50 3.308304 33.3333 50 80 33.3333 50 6.25 25 50 71.14288 25 50 66.6667 16.6667 50 50 14.2857 50 50 12.5 33.3333 50 5.8824 38.4615 50 10 33.3333 50 3.308304 26.83638 50 20 50 66.6667 11.1111 40 50 11.1111 33.3333 50 4.053344 33.3333 50 8.3333 25 50 7.1429 25 50 75 25 50 66.6667 16.6667 50 50 14.2857 33.3333 50 7.6923 50 65.50002 11.1111 40 50 11.1111 33.3333 50 4.053344 33.3333 50 2.589188 20 50 66.6667 20 50 60 25 50 66.6667 16.6667 50 50 14.2857 33.3333 50 7.6923 33.3333 50 6.25 33.3333 50 4.5455 25 50 66.6667 33.3333 50 2.589188 20 50 66.6667 20 40 60 16.6667 38.4615 55.32568 10 33.3333 50 8.3333 26.83638 50 75.23077 33.3333 50 6.25 25 50 4.5455 25 50 66.6667 20 50 66.6667 14.2857 50 50)
	elif [ "$2" == "passable" ]
	then
		echo "Simulating passable experiences. - p50"
        lat_array=(37.62773 60.50575 111.07597 406.41619 57.44460 94.71228 324.11535 54.66148 93.41525 180.39054 54.46686 90.08301 163.46313 52.67840 76.66926 148.71899 1001.81905 84.95328 137.99522 50.01831 69.27356 126.75361 653.74412 79.35090 121.32986 45.25837 78.31036 116.12785 33.51560 60.50575 111.07597 406.41619 57.44460 94.71228 324.11535 56.29354 103.97289 303.76048 55.49141 90.08301 258.24075 55.25925 86.02371 213.97079 50.86145 84.95328 137.99522 49.37883 69.27356 126.75361 653.74412 66.35559 102.14413 513.52323 61.89731 116.12785 33.51560 60.50575 111.07597 375.91378 57.44460 94.71228 324.11535 54.66148 91.44538 172.04743 54.35564 79.35090 163.46313 37.62773 76.66926 148.71899 1001.81905 84.95328 137.99522 49.37883 69.27356 126.75361 605.18965 64.48581 102.14413 513.52323 55.36838 98.69650 222.56204 55.02292 96.84758 213.97079 54.89781 83.22878 194.66759 48.44464 91.44538 172.04743 54.35564 78.31036 163.46313 37.62773 74.85439 113.80765 57.44460 95.67427 375.91378 54.66148 93.41525 189.47322 54.46686 81.19565 172.04743 41.99217 87.55221 148.71899 51.63091 72.92553 141.13005 50.01831 69.27356 131.43362 653.74412 66.35559 103.97289 570.02808 55.36838 99.93098 242.59022 55.25925 86.02371 222.56204 50.86145 95.67427 352.44423 54.66148 93.41525 189.47322 54.46686 79.35090 163.46313 41.99217 76.66926 116.12785 33.51560 58.90289 109.97634 375.91378 56.78149 108.66680 324.11535 66.35559 103.97289 570.02808 55.36838 98.69650 242.59022 55.25925 86.02371 213.97079 50.86145 84.22761 137.99522 49.37883 82.34532 123.74181 45.25837 64.48581 121.32986 460.94700 76.66926 116.12785 33.51560 58.90289 109.97634 375.91378 56.78149 93.41525 324.11535 55.61444 91.44538 277.15124 54.35564 88.55938 153.82787 51.63091 74.85439 141.13005 890.06885 84.22761 131.43362 49.37883 67.85350 123.74181 45.25837 64.48581 118.50643 460.94700 61.89731 98.69650 436.63919 55.15012 96.84758 206.17611 )
        thru_array=(1041.70955 2384.61184 3167.36020 3887.83723 2375.52042 2656.18343 3235.88881 1622.87497 2630.98015 3216.23937 1618.97059 2620.45936 3216.23937 1596.14432 2532.64206 3216.23937 7086.97114 2616.95188 3216.23937 1583.68010 2502.60594 3181.53519 4254.42994 2565.90427 3167.36020 1470.84292 2533.14297 3167.36020 521.16030 2384.61184 3167.36020 3887.83723 2375.52042 2656.18343 3235.88881 2287.14692 3167.36020 3223.86473 1834.23418 2620.45936 3216.23937 1749.86907 2618.70534 3216.23937 1583.68010 2616.95188 3216.23937 1583.68010 2502.60594 3181.53519 4254.42994 2502.60594 3167.36020 3961.26548 2392.37735 3167.36020 521.16030 2384.61184 3167.36020 3595.24704 2375.52042 2656.18343 3235.88881 1622.87497 2625.71976 3216.23937 1612.95855 2565.90427 3216.23937 1041.70955 2532.64206 3216.23937 7086.97114 2616.95188 3216.23937 1583.68010 2502.60594 3181.53519 3974.29194 2471.24391 3167.36020 3961.26548 1787.44460 3148.95728 3216.23937 1664.48955 2771.69706 3216.23937 1623.37588 2615.02761 3216.23937 1583.68010 2625.71976 3216.23937 1612.95855 2533.14297 3216.23937 1041.70955 2532.14060 3167.36020 2375.52042 2686.99582 3595.24704 1622.87497 2630.98015 3216.23937 1618.97059 2599.47196 3216.23937 1342.33404 2619.30425 3216.23937 1586.12389 2524.89462 3216.23937 1583.68010 2502.60594 3201.57551 4254.42994 2502.60594 3167.36020 3967.77898 1787.44460 3167.36020 3216.23937 1749.86907 2618.70534 3216.23937 1583.68010 2686.99582 3302.65740 1622.87497 2630.98015 3216.23937 1618.97059 2565.90427 3216.23937 1342.33404 2532.64206 3167.36020 521.16030 2376.84633 3167.36020 3595.24704 2375.52042 3167.36020 3235.88881 2502.60594 3167.36020 3967.77898 1787.44460 3148.95728 3216.23937 1749.86907 2618.70534 3216.23937 1583.68010 2615.19841 3216.23937 1583.68010 2615.02761 3167.36020 1470.84292 2471.24391 3167.36020 3959.20052 2532.64206 3167.36020 521.16030 2376.84633 3167.36020 3595.24704 2375.52042 2630.98015 3235.88881 2060.69027 2625.71976 3216.23937 1612.95855 2619.30425 3216.23937 1586.12389 2532.14060 3216.23937 5463.69653 2615.19841 3201.57551 1583.68010 2502.60594 3167.36020 1470.84292 2471.24391 3167.36020 3959.20052 2392.37735 3148.95728 3959.20052 1708.82876 2771.69706 3216.23937 )
		gap_array=(0.07 0.28 0.56 1.946 0.28 0.42 1.54 0.21 0.42 0.84 0.21 0.42 0.77 0.1568 0.35 0.7 6.9146 0.35 0.7 0.14 0.28 0.63 3.6484 0.35 0.63 0.14 0.35 0.56 0.07 0.28 0.56 1.946 0.28 0.42 1.54 0.26 0.49 1.4 0.21 0.42 1.19 0.21 0.35 1.05 0.14 0.35 0.7 0.14 0.28 0.63 3.6484 0.28 0.49 2.4822 0.28 0.56 0.07 0.28 0.56 1.82 0.28 0.42 1.54 0.21 0.42 0.77 0.21 0.35 0.77 0.07 0.35 0.7 6.9146 0.35 0.7 0.14 0.28 0.63 3.143 0.28 0.49 2.4822 0.21 0.49 1.05 0.21 0.42 1.05 0.21 0.35 0.91 0.14 0.42 0.77 0.21 0.35 0.77 0.07 0.2856 0.56 0.28 0.42 1.82 0.21 0.42 0.91 0.21 0.35 0.77 0.14 0.42 0.7 0.14 0.28 0.7 0.14 0.28 0.63 3.6484 0.28 0.49 2.7776 0.21 0.49 1.12 0.21 0.35 1.05 0.14 0.42 1.68 0.21 0.42 0.91 0.21 0.35 0.77 0.14 0.35 0.56 0.07 0.28 0.56 1.82 0.28 0.49 1.54 0.28 0.49 2.7776 0.21 0.49 1.12 0.21 0.35 1.05 0.14 0.35 0.7 0.14 0.35 0.63 0.14 0.28 0.63 2.31 0.35 0.56 0.07 0.28 0.56 1.82 0.28 0.42 1.54 0.21 0.42 1.26 0.21 0.42 0.77 0.14 0.2856 0.7 5.1884 0.35 0.63 0.14 0.28 0.63 0.14 0.28 0.56 2.31 0.28 0.49 2.1 0.21 0.42 0.98)
		loss_array=(0 3.4345 25 50 75 20 50 71.4286 12.5 50 66.6667 11.1111 50 66.6667 9.0909 33.3333 62.5 83.3333 39.6923 55.5556 7.1429 33.3333 50 80.82522 33.3333 50 4.5455 33.3333 50 2.7027 25 50 75 20 50 71.4286 20 50 71.4286 16.6667 50 66.6667 16.6667 50 66.6667 7.6923 39.6923 55.5556 6.283336 33.3333 50 80.82522 25 50 78.85383 25 50 2.7027 25 50 75 20 50 71.4286 12.5 50 66.6667 11.1111 33.3333 66.6667 3.4345 33.3333 62.5 83.3333 39.6923 55.5556 6.283336 33.3333 50 80 25 50 78.85383 16.6667 50 66.6667 14.2857 50 66.6667 14.2857 33.3333 66.6667 5.8824 50 66.6667 11.1111 33.3333 66.6667 3.4345 33.3333 50 20 50 75 12.5 50 66.6667 11.1111 33.3333 66.6667 4.1667 50 62.5 9.0909 33.3333 60 7.1429 33.3333 50 80.82522 25 50 80 16.6667 50 66.6667 16.6667 50 66.6667 7.6923 50 75 12.5 50 66.6667 11.1111 33.3333 66.6667 4.1667 33.3333 50 2.7027 20 50 75 20 50 71.4286 25 50 80 16.6667 50 66.6667 16.6667 50 66.6667 7.6923 34.23899 55.5556 6.283336 33.3333 50 4.5455 25 50 75 33.3333 50 2.7027 20 50 75 20 50 71.4286 20 50 71.4286 11.1111 50 66.6667 9.0909 33.3333 60 83.3333 34.23899 50 6.283336 25 50 4.5455 25 50 75 25 50 75 14.2857 50 66.6667)
	elif [ "$2" == "poor" ]
	then
		echo "Simulating poor experiences. - p75"
        lat_array=(44.73886 77.67008 150.78462 537.45104 73.99161 122.09436 447.97124 68.14752 121.00061 257.60504 67.87287 117.65929 237.86443 64.23676 98.16799 214.10125 1251.50961 109.89576 195.77418 61.22148 90.19091 177.09085 871.21680 102.09368 167.91412 52.05066 99.71833 158.07455 40.94094 77.67008 150.78462 537.45104 73.99161 122.09436 447.97124 71.00689 137.64539 424.39347 69.41106 117.65929 371.64142 69.04509 111.39645 315.25917 62.34371 109.89576 195.77418 59.15760 90.19091 177.09085 871.21680 85.88883 135.86032 682.68741 79.37321 158.07455 40.94094 77.67008 150.78462 505.49550 73.99161 122.09436 447.97124 68.14752 119.37492 245.47137 67.22183 102.09368 237.86443 44.73886 98.16799 214.10125 1251.50961 109.89576 195.77418 59.15760 90.19091 177.09085 777.80332 84.05862 135.86032 682.68741 69.23606 130.86519 332.10673 68.72842 125.40825 315.25917 68.54162 106.47180 277.07551 58.16037 119.37492 245.47137 67.22183 99.71833 237.86443 44.73886 96.99646 154.07073 73.99161 123.49992 505.49550 68.14752 121.00061 265.48455 67.87287 103.54160 245.47137 49.34545 113.38291 214.10125 63.22912 94.80063 205.41028 61.22148 90.19091 189.64918 871.21680 85.88883 137.64539 722.04814 69.23606 134.37352 349.39422 69.04509 111.39645 332.10673 62.34371 123.49992 471.76358 68.14752 121.00061 265.48455 67.87287 102.09368 237.86443 49.34545 98.16799 158.07455 40.94094 75.98432 147.45962 505.49550 72.03120 144.20303 447.97124 85.88883 137.64539 722.04814 69.23606 130.86519 349.39422 69.04509 111.39645 315.25917 62.34371 108.21312 195.77418 59.15760 105.02493 173.05127 52.05066 84.05862 167.91412 603.60100 98.16799 158.07455 40.94094 75.98432 147.45962 505.49550 72.03120 121.00061 447.97124 70.25585 119.37492 398.14557 67.22183 115.40062 225.19221 63.22912 96.99646 205.41028 1111.66734 108.21312 189.64918 59.15760 87.20793 173.05127 52.05066 84.05862 162.24364 603.60100 79.37321 130.86519 563.43054 68.91627 125.40825 295.04147 )
        thru_array=(127.24766 1551.28225 1568.25193 2010.12687 1544.41877 1568.25193 1986.24566 997.43684 1568.25193 1568.25193 819.73337 1568.25193 1568.25193 446.21297 1568.25193 1568.25193 3017.50251 1568.25193 1568.25193 291.05613 1568.25193 1568.25193 2336.74290 1568.25193 1568.25193 240.33819 1568.25193 1568.25193 64.219700 1551.28225 1568.25193 2010.12687 1544.41877 1568.25193 1986.24566 1544.41877 1568.25193 1972.56570 1544.41877 1568.25193 1901.16019 1544.41877 1568.25193 1639.10969 294.96483 1568.25193 1568.25193 288.38676 1568.25193 1568.25193 2336.74290 1568.25193 1568.25193 2011.55765 1557.14524 1568.25193 64.219700 1551.28225 1568.25193 2004.26388 1544.41877 1568.25193 1986.24566 997.43684 1568.25193 1568.25193 691.72301 1568.25193 1568.25193 127.24766 1568.25193 1568.25193 3017.50251 1568.25193 1568.25193 288.38676 1568.25193 1568.25193 2011.55765 1565.48754 1568.25193 2011.55765 1544.41877 1568.25193 1749.53065 1544.41877 1568.25193 1639.10969 1525.11286 1568.25193 1573.82877 288.38676 1568.25193 1568.25193 691.72301 1568.25193 1568.25193 127.24766 1568.25193 1568.25193 1544.41877 1568.25193 2004.26388 997.43684 1568.25193 1568.25193 819.73337 1568.25193 1568.25193 185.61621 1568.25193 1568.25193 326.99721 1568.25193 1568.25193 291.05613 1568.25193 1568.25193 2336.74290 1568.25193 1568.25193 2011.55765 1544.41877 1568.25193 1855.23216 1544.41877 1568.25193 1749.53065 294.96483 1568.25193 1998.40088 997.43684 1568.25193 1568.25193 819.73337 1568.25193 1568.25193 185.61621 1568.25193 1568.25193 64.219700 1545.41925 1568.25193 2004.26388 1544.41877 1568.25193 1986.24566 1568.25193 1568.25193 2011.55765 1544.41877 1568.25193 1855.23216 1544.41877 1568.25193 1639.10969 294.96483 1568.25193 1568.25193 288.38676 1568.25193 1568.25193 240.33819 1565.48754 1568.25193 2011.55765 1568.25193 1568.25193 64.219700 1545.41925 1568.25193 2004.26388 1544.41877 1568.25193 1986.24566 1544.41877 1568.25193 1947.08715 691.72301 1568.25193 1568.25193 326.99721 1568.25193 1568.25193 2946.16854 1568.25193 1568.25193 288.38676 1568.25193 1568.25193 240.33819 1565.48754 1568.25193 2011.55765 1557.14524 1568.25193 2011.55765 1544.41877 1568.25193 1579.69176 )
		gap_array=(0.07 0.28 0.49 1.82 0.21 0.42 1.33 0.21 0.42 0.77 0.14 0.35 0.7 0.14 0.28 0.7 6.9167 0.35 0.63 0.14 0.28 0.63 3.22 0.28 0.56 0.07 0.28 0.56 0.07 0.28 0.49 1.82 0.21 0.42 1.33 0.21 0.49 1.26 0.21 0.35 1.12 0.21 0.35 0.98 0.14 0.35 0.63 0.14 0.28 0.63 3.22 0.28 0.42 2.3569 0.28 0.56 0.07 0.28 0.49 1.6737 0.21 0.42 1.33 0.21 0.42 0.77 0.14 0.28 0.7 0.07 0.28 0.7 6.9167 0.35 0.63 0.14 0.28 0.63 2.87 0.28 0.42 2.3569 0.21 0.42 0.98 0.21 0.42 0.98 0.21 0.35 0.84 0.14 0.42 0.77 0.14 0.28 0.7 0.07 0.28 0.5332 0.21 0.42 1.6737 0.21 0.42 0.84 0.14 0.35 0.77 0.07 0.35 0.7 0.14 0.28 0.63 0.14 0.28 0.63 3.22 0.28 0.49 2.5802 0.21 0.42 1.05 0.21 0.35 0.98 0.14 0.42 1.54 0.21 0.42 0.84 0.14 0.28 0.7 0.07 0.28 0.56 0.07 0.24 0.49 1.6737 0.21 0.49 1.33 0.28 0.49 2.5802 0.21 0.42 1.05 0.21 0.35 0.98 0.14 0.35 0.63 0.14 0.35 0.56 0.07 0.28 0.56 2.1 0.28 0.56 0.07 0.24 0.49 1.6737 0.21 0.42 1.33 0.21 0.42 1.1475 0.14 0.35 0.7 0.14 0.28 0.63 4.97 0.35 0.63 0.14 0.28 0.56 0.07 0.28 0.56 2.1 0.28 0.42 1.89 0.21 0.42 0.91)
		loss_array=(3.4483 25 50 83.3333 20 50 81.51371 12.5 50 71.4286 12.5 50 66.6667 9.208416 33.3333 66.6667 85.7143 50 66.6667 7.6923 33.3333 66.6667 83.3333 33.3333 66.6667 4.709964 33.3333 59.33332 2.735744 25 50 83.3333 20 50 81.51371 20 50 80 16.6667 50 80 16.6667 50 75 8.3333 50 66.6667 6.704796 33.3333 66.6667 83.3333 25 50 83.3333 25 59.33332 2.735744 25 50 83.3333 20 50 81.51371 12.5 50 71.4286 11.1111 33.3333 66.6667 3.4483 33.3333 66.6667 85.7143 50 66.6667 6.704796 33.3333 66.6667 83.3333 25 50 83.3333 16.6667 50 75 14.2857 50 75 14.2857 33.3333 75 6.117664 50 71.4286 11.1111 33.3333 66.6667 3.4483 33.3333 50 20 50 83.3333 12.5 50 75 12.5 33.3333 71.4286 4.287916 50 66.6667 9.0909 33.3333 66.6667 7.6923 33.3333 66.6667 83.3333 25 50 83.3333 16.6667 50 80 16.6667 50 75 8.3333 50 83.3333 12.5 50 75 12.5 33.3333 66.6667 4.287916 33.3333 59.33332 2.735744 20 50 83.3333 20 50 81.51371 25 50 83.3333 16.6667 50 80 16.6667 50 75 8.3333 40.83077 66.6667 6.704796 33.3333 66.6667 4.709964 25 66.6667 83.3333 33.3333 59.33332 2.735744 20 50 83.3333 20 50 81.51371 20 50 80 11.1111 50 66.6667 9.0909 33.3333 66.6667 85.7143 40.83077 66.6667 6.704796 26.71699 66.6667 4.709964 25 62.5 83.3333 25 50 83.3333 16.6667 50 75)
	elif [ "$2" == "verypoor" ]
	then
		echo "Simulating very poor experiences. - p90"
        lat_array=(88.32762 153.41618 300.98764 1073.09616 146.26486 242.08245 907.76910 134.54319 239.74141 515.92907 134.00094 233.10011 479.82832 126.82220 194.15515 437.73272 2470.84680 217.24065 394.31543 120.86916 179.57006 360.98898 1743.87552 201.63826 336.34735 102.76326 197.69585 316.63390 80.82942 153.41618 300.98764 1073.09616 146.26486 242.08245 907.76910 140.23504 274.09408 852.72680 137.10360 233.10011 754.83072 136.31525 220.53114 643.53002 123.08475 217.24065 394.31543 116.79444 179.57006 360.98898 1743.87552 169.86176 269.67592 1369.09461 156.87736 316.63390 80.82942 153.41618 300.98764 1019.75121 146.26486 242.08245 907.76910 134.54319 236.46943 498.51143 132.71559 201.63826 479.82832 88.32762 194.15515 437.73272 2470.84680 217.24065 394.31543 116.79444 179.57006 360.98898 1537.37351 166.83520 269.67592 1369.09461 136.69228 259.62623 673.84362 135.69006 250.36899 643.53002 135.32125 210.30046 572.78319 114.82563 236.46943 498.51143 132.71559 197.69585 479.82832 88.32762 191.77434 308.11292 146.26486 244.76625 1019.75121 134.54319 239.74141 542.99469 134.00094 204.50647 498.51143 97.42239 224.33850 437.73272 124.83282 187.61393 412.70377 120.86916 179.57006 379.29710 1743.87552 169.86176 274.09408 1428.04504 136.69228 266.97361 712.92500 136.31525 220.53114 673.84362 123.08475 244.76625 962.27669 134.54319 239.74141 542.99469 134.00094 201.63826 479.82832 97.42239 194.15515 316.63390 80.82942 150.18671 294.76040 1019.75121 142.21070 287.75097 907.76910 169.86176 274.09408 1428.04504 136.69228 259.62623 712.92500 136.31525 220.53114 643.53002 123.08475 213.67870 394.31543 116.79444 207.48984 345.11855 102.76326 166.83520 336.34735 1214.25254 194.15515 316.63390 80.82942 150.18671 294.76040 1019.75121 142.21070 239.74141 907.76910 138.77832 236.46943 801.90867 132.71559 228.66961 452.72568 124.83282 191.77434 412.70377 2194.75717 213.67870 379.29710 116.79444 172.89175 345.11855 102.76326 166.83520 324.10194 1214.25254 156.87736 259.62623 1126.10041 136.06092 250.36899 615.17014 )
        thru_array=(0.85198 160.64594 285.04948 1104.14314 131.20215 212.99054 1104.14314 112.03301 212.99054 932.32729 93.25578 212.99054 692.43219 43.45003 206.17482 638.47736 1104.14314 210.64764 433.08635 21.367214 206.17482 372.86969 1104.14314 206.17482 347.78796 0.85198 206.17482 320.38036 0.85198 160.64594 285.04948 1104.14314 131.20215 212.99054 1104.14314 130.24795 228.70923 1104.14314 125.35773 212.99054 1104.14314 125.23842 212.39413 1104.14314 33.942148 210.64764 433.08635 11.228881 206.17482 372.86969 1104.14314 206.17482 219.80618 1104.14314 185.79584 320.38036 0.85198 160.64594 285.04948 1104.14314 131.20215 212.99054 1104.14314 112.03301 212.99054 768.50379 65.66069 206.17482 692.43219 0.85198 206.17482 638.47736 1104.14314 210.64764 433.08635 11.228881 206.17482 372.86969 1104.14314 202.22170 219.80618 1104.14314 125.23842 219.53359 1104.14314 121.54094 213.94474 1104.14314 119.01911 207.78505 1104.14314 6.33861 212.99054 768.50379 65.66069 206.17482 692.43219 0.85198 206.17482 300.46999 131.20215 212.99054 1104.14314 112.03301 212.99054 1096.15155 93.25578 206.17482 768.50379 0.85198 212.99054 638.47736 43.45003 206.17482 535.78189 21.367214 206.17482 391.73211 1104.14314 206.17482 228.70923 1104.14314 125.23842 219.80618 1104.14314 125.23842 212.39413 1104.14314 33.942148 212.99054 1104.14314 112.03301 212.99054 1096.15155 93.25578 206.17482 692.43219 0.85198 206.17482 320.38036 0.85198 135.49604 275.96758 1104.14314 131.20215 266.88568 1104.14314 206.17482 228.70923 1104.14314 125.23842 219.53359 1104.14314 125.23842 212.39413 1104.14314 33.942148 208.90108 433.08635 11.228881 206.73711 356.86986 0.85198 202.22170 347.78796 1104.14314 206.17482 320.38036 0.85198 135.49604 275.96758 1104.14314 131.20215 212.99054 1104.14314 127.80284 212.99054 1104.14314 65.66069 212.99054 672.52183 43.45003 206.17482 535.78189 1104.14314 208.90108 391.73211 11.228881 206.17482 356.86986 0.85198 202.22170 338.70606 1104.14314 185.79584 219.53359 1104.14314 123.98605 213.94474 1104.14314 )
		gap_array=(0.07 0.21 0.49 1.61 0.21 0.35 1.19 0.14 0.35 0.7 0.14 0.35 0.7 0.14 0.28 0.63 6.8201 0.35 0.63 0.07 0.28 0.56 2.94 0.28 0.56 0.07 0.28 0.49 0.07 0.21 0.49 1.61 0.21 0.35 1.19 0.21 0.42 1.12 0.21 0.35 0.98 0.21 0.35 0.84 0.07 0.35 0.63 0.07 0.28 0.56 2.94 0.28 0.42 2.1 0.21 0.49 0.07 0.21 0.49 1.47 0.21 0.35 1.19 0.14 0.35 0.7 0.14 0.28 0.7 0.07 0.28 0.63 6.8201 0.35 0.63 0.07 0.28 0.56 2.66 0.28 0.42 2.1 0.21 0.42 0.91 0.21 0.42 0.84 0.14 0.3417 0.77 0.07 0.35 0.7 0.14 0.28 0.7 0.07 0.28 0.49 0.21 0.42 1.47 0.14 0.35 0.77 0.14 0.28 0.7 0.07 0.35 0.63 0.14 0.28 0.63 0.07 0.28 0.56 2.94 0.28 0.42 2.38 0.21 0.42 0.98 0.21 0.35 0.91 0.07 0.42 1.33 0.14 0.35 0.77 0.14 0.28 0.7 0.07 0.28 0.49 0.07 0.21 0.49 1.47 0.21 0.49 1.19 0.28 0.42 2.38 0.21 0.42 0.98 0.21 0.35 0.84 0.07 0.35 0.63 0.07 0.28 0.56 0.07 0.28 0.56 1.89 0.28 0.49 0.07 0.21 0.49 1.47 0.21 0.35 1.19 0.21 0.35 1.05 0.14 0.35 0.63 0.14 0.28 0.63 4.6802 0.35 0.56 0.07 0.28 0.56 0.07 0.28 0.49 1.89 0.21 0.42 1.7703 0.21 0.42 0.84)
		loss_array=(3.4483 25 50 83.3333 20 50 83.3333 12.5 50 75 12.5 50 75 9.854544 33.3333 66.6667 90.9091 50 66.6667 7.6923 33.3333 66.6667 88.8889 33.3333 66.6667 4.709964 33.3333 62.5 2.735744 25 50 83.3333 20 50 83.3333 20 50 83.3333 20 50 83.3333 16.6667 50 80 8.3333 50 66.6667 6.704796 33.3333 66.6667 88.8889 25 50 85.7143 25 62.5 2.735744 25 50 83.3333 20 50 83.3333 12.5 50 75 11.1111 33.3333 75 3.4483 33.3333 66.6667 90.9091 50 66.6667 6.704796 33.3333 66.6667 85.7143 25 50 85.7143 16.6667 50 80 14.2857 50 80 14.2857 37.16666 75 6.117664 50 75 11.1111 33.3333 75 3.4483 33.3333 55.80957 20 50 83.3333 12.5 50 75 12.5 33.3333 75 4.287916 50 66.6667 9.0909 33.3333 66.6667 7.6923 33.3333 66.6667 88.8889 25 50 85.7143 16.6667 50 83.3333 16.6667 50 80 8.3333 50 83.3333 12.5 50 75 12.5 33.3333 75 4.287916 33.3333 62.5 2.735744 20.7333 50 83.3333 20 50 83.3333 25 50 85.7143 16.6667 50 83.3333 16.6667 50 80 8.3333 50 66.6667 6.704796 33.3333 66.6667 4.709964 25 66.6667 84.47618 33.3333 62.5 2.735744 20.7333 50 83.3333 20 50 83.3333 20 50 83.3333 11.1111 50 71.4286 9.0909 33.3333 66.6667 90.10909 50 66.6667 6.704796 28.87905 66.6667 4.709964 25 66.6667 84.47618 25 50 83.3333 16.6667 50 80)
	else
		echo "Please select a valid network experience to simulate. Valid values are noloss, good, fair, passable, poor, and verypoor."
		exit 1	
	fi
else
	echo "Please select a valid simulation technique. Valid values are mgst_brazil_cell, mgst_brazil_wifi, mgst_brazil_2019_09_17, loss_based and experience_based."
	exit 1
fi

#initializing TC NETEM
reset_netem () {
	sudo ${TC} qdisc del dev ${ETH1} root
	sudo ${TC} qdisc add dev ${ETH1} root handle 1:0 netem delay 0ms loss 0.01%
	sudo ${TC} qdisc add dev ${ETH1} parent 1:1 handle 10: tbf rate 4mbit buffer 64k limit 128k
	sudo ${TC} qdisc del dev ${ETH2} root
	sudo ${TC} qdisc add dev ${ETH2} root handle 1:0 netem delay 0ms loss 0.01%
	sudo ${TC} qdisc add dev ${ETH2} parent 1:1 handle 10: tbf rate 4mbit buffer 64k limit 128k
	echo "Resetting all tc Netem configurations to client and server."
}


count=0
current_time=9999
interval=0.07
loss_loop=0

thru=0
latency=0
t=0
loss=0
echo -n "        thru_array=("
for ((loop=0;loop<=199;loop++));
do
	gap=${gap_array[$loop]}
    lat=${lat_array[$loop]}
    # lat=$(echo "scale=5; ${lat}*3.42759" | bc)
    # echo -n "${lat} "

    t=$(echo "scale=5; ${t}+${gap}" | bc)
    latency=$(echo "scale=5; ${latency}+${lat}" | bc)
    # k=$(echo "scale=5; ${thru_array[$loop]}*7.63358" | bc)
    # thru=$(echo "scale=5; ${thru}+${k}" | bc)
    thru=$(echo "scale=5; ${thru}+${thru_array[$loop]}" | bc)
    loss=$(echo "scale=5; ${loss}+${loss_array[$loop]}*${interval}" | bc)
done
echo ")"

latency=$(echo "scale=1; ${latency}/200" | bc)
thru=$(echo "scale=1; ${thru}/200" | bc)
loss=$(echo "scale=5; ${loss}/${t}" | bc)

echo "thru: ${thru} kbit"
echo "RTT: ${latency} ms"
echo "loss: ${loss} %"

sudo ethtool -K $ETH1 gro off
sudo ethtool -K $ETH1 tso off
sudo ethtool -K $ETH1 gso off
sudo ethtool -K $ETH2 gro off
sudo ethtool -K $ETH2 tso off
sudo ethtool -K $ETH2 gso off
echo "$(reset_netem)"

get_current_time () {
	echo $(date +%s%3N)
}


#Run the outer loop for about 5150*200*70*ms = about 20hours
for ((outer_loop=0;outer_loop<5150;outer_loop++))
do
	for ((loop=0;loop<=199;loop++));
	do
		#echo "$(get_current_time)"
		latency=${lat_array[$loop]}
        half_latency=$(python3 -c "print($latency*0.5)")
		thru=${thru_array[$loop]}
		loss=${loss_array[$loss_loop]}

		if [[ (($count == 0)) ]]
		then
			#inject latency and 0% loss when new time gap starts
			sudo ${TC} qdisc change dev ${ETH1} root handle 1:0 netem delay ${half_latency}ms loss 0.01%
			sudo ${TC} qdisc change dev ${ETH2} root handle 1:0 netem delay ${half_latency}ms loss 0.01%
			#echo "Resetting loss"

			#fetch the time gap value before the loss needs to be injected
			gap=${gap_array[$loop]}
			current_time=$gap
		elif [[ (("$count" > "$current_time")) || (("$count" == "$current_time")) ]]
		then
			#inject latency and loss after the time gap is over
			sudo ${TC} qdisc change dev ${ETH1} root handle 1:0 netem delay ${half_latency}ms loss ${loss}%
			sudo ${TC} qdisc change dev ${ETH2} root handle 1:0 netem delay ${half_latency}ms loss ${loss}%

			#get new time gap value
			((loss_loop++))
			if [ $loss_loop == 199 ]
			then
				loss_loop=0
			fi
			loss=${loss_array[$loss_loop]}
			gap=${gap_array[$loop]}
			current_time=$gap
			count=0
		else
			#inject latency and 0loss% until new time gap value is not fetched
			loss=0
			sudo ${TC} qdisc change dev ${ETH1} root handle 1:0 netem delay ${half_latency}ms loss 0.01%
			sudo ${TC} qdisc change dev ${ETH2} root handle 1:0 netem delay ${half_latency}ms loss 0.01%
			#echo "Runing TC Command without loss $loss"
		fi

		#set throughput on the link
		sudo ${TC} qdisc change dev ${ETH1} parent 1:1 handle 10: tbf rate ${thru}kbit buffer 64k limit 128k
		sudo ${TC} qdisc change dev ${ETH2} parent 1:1 handle 10: tbf rate ${thru}kbit buffer 64k limit 128k

		echo "Setting latency on each link: $half_latency, thru: $thru, gap: $gap, loss: $loss%"
        count=$(python3 -c "print($count+$interval)")
		sleep 0.032
	done
	echo "$(reset_netem)"
done

sudo ${TC} qdisc del dev ${ETH1} root netem
sudo ${TC} qdisc del dev ${ETH2} root netem

#TC takes 4 ms to execute
#get_current_time takes 2 ms to execute
#python takes 9ms to execute
