package main

import (
	"fmt"
	"log"
	"net/http"
	"os"

	"github.com/apex/gateway"

	"code.justin.tv/esports-exp/centaur/internal/server"
	pb "code.justin.tv/esports-exp/centaur/proto"
	"github.com/rs/cors"
)

func getMux() *http.ServeMux {
	srv := server.NewCentaur()
	twirpHandler := pb.NewCentaurServer(srv, nil)
	corsWrapper := cors.New(cors.Options{
		AllowedOrigins: []string{"*"},
		AllowedMethods: []string{"POST"},
		AllowedHeaders: []string{"Content-Type"},
	})

	// You can use any mux you like - NewHelloWorldServer gives you an http.LambdaHandler.
	mux := http.NewServeMux()
	mux.HandleFunc("/", func(w http.ResponseWriter, r *http.Request) {
		fmt.Fprintf(w, "Hello")
	})
	mux.Handle(pb.CentaurPathPrefix, corsWrapper.Handler(twirpHandler))
	return mux
}

// Run the implementation in a local server
func LambdaHandler() {
	mux := getMux()
	log.Fatal(gateway.ListenAndServe("", mux))
}

func main() {
	if _, ok := os.LookupEnv("STAGE"); ok {
		fmt.Println("listening for gateway")
		LambdaHandler()
	} else {
		mux := getMux()
		fmt.Println("listening local http")
		http.ListenAndServe("0.0.0.0:8080", mux)
	}
	fmt.Println("Server stopped")
}
