package main

import (
	"fmt"
	"time"

	"code.justin.tv/esports-exp/centaur/internal/config"
	"code.justin.tv/esports-exp/centaur/internal/redrec"
)

func main() {
	cfg := config.New()

	rr, err := redrec.New(cfg.RedisHost)
	if err != nil {
		panic(fmt.Errorf("failed to setup redrec: %s", err))
	}

	for {
		start := time.Now()

		err := rr.BatchUpdateSimilarUsers(100)
		if err != nil {
			fmt.Printf("Update failed %s", err.Error())
		}

		fmt.Printf("Updated completed in %s\n", time.Now().Sub(start))
		time.Sleep(time.Second)
	}
}
