package config

import "os"

type Config struct {
	DBHost     string
	DBUser     string
	DBPassword string

	RedisHost string
}

func New() *Config {
	return &Config{
		DBHost:     os.Getenv("DB_HOST"),
		DBUser:     os.Getenv("DB_USER"),
		DBPassword: os.Getenv("DB_PASSWORD"),

		RedisHost: os.Getenv("REDIS_HOST"),
	}
}
